// copyright 2001-2002 by The Mind Electric
// based on source code contributed by the jaxen group, http://www.jaxen.org

package electric.xml.jaxen;

import electric.xml.*;

/**
 * <tt>Namespace</tt>
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class Namespace
  {
  private Element element;
  private String prefix;
  private String uri;

  // ********** CONSTRUCTION ************************************************

  /**
   * @param prefix
   * @param uri
   */
  public Namespace( String prefix, String uri )
    {
    this.prefix = prefix;
    this.uri = uri;
    }

  /**
   * @param element
   * @param prefix
   * @param uri
   */
  public Namespace( Element element, String prefix, String uri )
    {
    this.element = element;
    this.prefix = prefix;
    this.uri = uri;
    }

  // ********** STANDARD METHODS *********************************************

  /**
   *
   */
  public String toString()
    {
    return "[xmlns:" + prefix + "=\"" + uri + "\", element=" + element.getName() + "]";
    }

  // ********** ACCESSORS ***************************************************

  /**
   *
   */
  public String getURI()
    {
    return uri;
    }

  /**
   *
   */
  public String getPrefix()
    {
    return prefix;
    }

  /**
   * @param element
   */
  public void setElement( Element element )
    {
    this.element = element;
    }

  /**
   *
   */
  public Element getElement()
    {
    return element;
    }
  }