// copyright 2001-2002 by The Mind Electric

package electric.xml.sax;

import org.xml.sax.*;

/**
 * <tt>SAXSink</tt>.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

final class SAXSink implements ContentHandler, ErrorHandler, DTDHandler
  {
  // ********** CONTENT HANDLER *********************************************

  /**
   * Receive notification of the beginning of a document.
   */
  public void startDocument()
    {
    }

  /**
   * Receive notification of the end of a document.
   */
  public void endDocument()
    {
    }

  /**
   * Receive notification of the beginning of an element.
   * @param uri
   * @param localName
   * @param qName
   * @param attributes
   */
  public void startElement( String uri, String localName, String qName, Attributes attributes )
    {
    }

  /**
   * Receive notification of the end of an element.
   * @param uri
   * @param localName
   * @param qName
   */
  public void endElement( String uri, String localName, String qName )
    {
    }

  /**
   * Begin the scope of a prefix-URI Namespace mapping.
   * @param prefix
   * @param uri
   */
  public void startPrefixMapping( String prefix, String uri )
    {
    }

  /**
   * End the scope of a prefix-URI mapping.
   * @param prefix
   */
  public void endPrefixMapping( String prefix )
    {
    }

  /**
   * Receive notification of character data.
   * @param chars
   * @param start
   * @param length
   */
  public void characters( char[] chars, int start, int length )
    {
    }

  /**
   * Receive notification of ignorable whitespace in element content.
   * @param chars
   * @param start
   * @param length
   */
  public void ignorableWhitespace( char[] chars, int start, int length )
    {
    }

  /**
   * Receive notification of a processing instruction.
   * @param target
   * @param data
   */
  public void processingInstruction( String target, String data )
    {
    }

  /**
   * Receive an object for locating the origin of SAX document events.
   * @param locator
   */
  public void setDocumentLocator( Locator locator )
    {
    }

  /**
   * Receive notification of a skipped entity.
   * @param name
   */
  public void skippedEntity( String name )
    {
    }

  // ********** ERROR HANDLER ***********************************************

  /**
   * Receive notification of a warning.
   * @param exception
   */
  public void warning( SAXParseException exception )
    {
    }

  /**
   * Receive notification of a recoverable error.
   * @param exception
   */
  public void error( SAXParseException exception )
    {
    }

  /**
   * Receive notification of a non-recoverable error.
   * @param exception
   */
  public void fatalError( SAXParseException exception )
    {
    }

  // ********** DTD HANDLER *************************************************

  /**
   * Receive notification of a notation declaration event.
   * @param name
   * @param publicId
   * @param systemId
   */
  public void notationDecl( String name, String publicId, String systemId )
    {
    }

  /**
   * Receive notification of an unparsed entity declaration event.
   * @param name
   * @param publicId
   * @param systemId
   * @param notationName
   */
  public void unparsedEntityDecl( String name, String publicId, String systemId, String notationName )
    {
    }
  }