// copyright 2001-2002 by The Mind Electric

package electric.xml.xpath;

import electric.xml.*;

/**
 * <tt>WildNode</tt> processes XPath "//" sub-expressions.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public class WildNode extends XPathNode
  {
  // ********** MATCHING ****************************************************

  /**
   * @param xpath
   * @param node
   * @param list
   * @throws XPathException
   */
  public void addNodes( TMEXPath xpath, Node node, NodeList list )
    throws XPathException
    {
    XPathNode next = next();

    if( next == null )
      throw new XPathException( "// cannot be at the end of an XPath expression" );

    next.addNodes( xpath, node, list );

    for( Elements elements = ((Parent) node).getElements(); elements.hasMoreElements(); )
      addNodes( xpath, elements.next(), list );
    }
  }