// copyright 2001-2002 by The Mind Electric

package electric.xml.xpath;

import java.io.*;
import electric.util.*;
import electric.xml.*;

/**
 * <tt>AllAttributesNode</tt> processes XPath "@*" sub-expressions.
 *
 * @author <a href="http://www.themindelectric.com">The Mind Electric</a>
 */

public final class XPathNodeFactory
  {
  // ********** PARSING *****************************************************

  /**
   * @param xpath
   * @throws XPathException
   */
  public synchronized static NodeList newNodes( String xpath )
    throws XPathException
    {
    try
      {
      NodeList nodes = new NodeList();
      Lex lex = new Lex( xpath, "/", Lex.QUOTES | Lex.SKIP_WS | Lex.CONSUME );

      if( lex.peek() == '/' )
        {
        nodes.append( new RootNode() );
        lex.read();
        }

      if( !lex.eof() )
        {
        String token = lex.readToken();
        nodes.append( newNode( token ) );

        while( !lex.eof() )
          {
          if( !token.equals( "/" ) )
            lex.readChar( '/' );

          token = lex.readToken();
          nodes.append( newNode( token ) );
          }
        }

      return nodes;
      }
    catch( IOException exception )
      {
      throw new XPathException( exception.toString() );
      }
    }

  // ********** ADDING NODES ************************************************

  /**
   * @param string
   * @throws XPathException
   */
  private static Node newNode( String string )
    throws XPathException
    {
    if( string.equals( ".." ) )
      return new ParentNode();
    else if( string.equals( "." ) )
      return new CurrentNode();
    else if( string.equals( "/" ) )
      return new WildNode();
    else if( string.equals( "*" ) )
      return new AllNode();
    else if( string.equals( "@*" ) )
      return new AllAttributesNode();
    else if( string.startsWith( "@" ) )
      return new AttributeNode( string );
    else if( string.indexOf( "[@" ) != -1 )
      return new AttributePredicate( string );
    else if( string.indexOf( "[text" ) != -1 )
      return new TextPredicate( string );
    else if( string.indexOf( "[" ) != -1 )
      return new IndexPredicate( string );
    else
      return new NameNode( string );
    }
  }