/**
 * Title:        Comedia Utils
 * Description:  Project contains some general purpose non-visual beans.
 * Beans do not require any special libraies.
 * Copyright:    Copyright (c) 2001
 * Company:      Capella Development Group
 * @author Sergey Seroukhov
 * @version 1.0
 */

package org.comedia.util.xml;

import java.util.*;
import java.io.*;
import org.comedia.util.scanner.*;

/**
 * Presents an interface of generic XML element.
 */
public interface CXmlElement {
  /**
   * Clears the content of this element and restores an initial state.
   */
  public void clear();

  /**
   * Parses this element from input stream.
   * @param scanner lexical scanner to parse XML.
   */
  public void parseElement(CXmlScanner scanner) throws CXmlException;

  /**
   * Parses child elements from input stream.
   * @param scanner lexical scanner to parse XML.
   */
  public void parseChildElements(CXmlScanner scanner) throws CXmlException;

  /**
   * Writes this element from output stream.
   * @param output stream to write this element and all contents.
   * @param indent number of indent spaces.
   */
  public void writeElement(Writer out, int indent) throws IOException;

  /**
   * Writes child elements of this element to output stream.
   * @param output stream to write child elemens.
   * @param indent number of indent spaces.
   */
  public void writeChildElements(Writer out, int indent) throws IOException;

  /**
   * Creates a child element to this one.
   * @param tagName a name of element tag.
   */
  public CXmlElement createChildElement(String tagName);
}