/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;


import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


public class LizardClassListenerTable extends JATable {

    public LizardClassListenerTableModel theModel = null;
    public MetadataDispenser theMetadataDispenser = null;

    public LizardClassListenerTable(LizardClassListenerTableModel theTableModel) {
        super(theTableModel);
        theModel = theTableModel;
        createDefaultColumnsFromModel();
    }

    public void Load(MetaClass objClass) {
        theModel.theMetadataDispenser = theMetadataDispenser;
        theModel.Load(objClass, theMetadataDispenser);
        updateUI();
    }

    public void resetContents() {
        theModel.clear();
        updateUI();
    }


}

