/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.renderer.common.MetaDataMember;
import ch.abacus.lib.ui.renderer.common.MetaClass;

import java.awt.event.*;
import java.lang.reflect.Method;

/**
 * Title:        uifactory
 * Description:  This is a program design tool that creates Abacus java applications using the UI Factory.  The output of this tool is an xml document that is processed by the UI factory to create the java programs.
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


public class LizardMemberDataComboBox extends LizardComboBox {

    LizardMemberDataComboBoxModel theModel = null;
    MetaDataMember theMemberData = null;

    public LizardMemberDataComboBox(LizardMemberDataComboBoxModel objModel, Object objReceiver) {
        super(objModel, objReceiver);
        theModel = objModel;
        theReceiver = objReceiver;
        setEditable(true);
        setMaximumRowCount(10);
        addActionListener(new LizardMemberDataComboBoxListener());
    }

    public void selectItem() {
        String sSelectedItem = (String) getSelectedItem();
        selectItem(sSelectedItem);
    }

    public void appendItem(String sText) {
        theMetaClass.setData(sText, "", "", "", "");
        Reload(theMetaClass);
        selectMemberData(sText);
    }

    public void selectItem(String sSelectedItem) {
        if (sSelectedItem.trim().length() == 0)
            return;
        configureEditor(getEditor(), sSelectedItem);
        // Find out if it already exists.
        for (int i = 0; i < getItemCount(); i++) {
            if (getItemAt(i).equals(sSelectedItem)) {
                selectMemberData(sSelectedItem);
                return;
            }
        }
        // If not, add a new MemberData.
        appendItem(sSelectedItem);
    }

    public void selectMemberData(String sMemberDataName) {
        if (theMetaClass != null) {
            if (!sMemberDataName.trim().equals("")) {
                MetaDataMember theOldMemberData = theMemberData;
                theMemberData = theMetaClass.getData(sMemberDataName, false);
                if (theReceiver != null) {
                    try {
                        Class clsReceiver = theReceiver.getClass();
                        Class[] clsParams = new Class[2];
                        clsParams[0] = theMemberData.getClass();
                        clsParams[1] = theMemberData.getClass();
                        Method m = clsReceiver.getMethod("selectMemberData", clsParams);
                        Object[] objArgList = new Object[2];
                        objArgList[0] = theOldMemberData;
                        objArgList[1] = theMemberData;
                        m.invoke(theReceiver, objArgList);
                    } catch (java.lang.NoSuchMethodException e1) {
                        System.out.println("LizardMemberDataComboBox Error: Bad Receiver - SelectMemberData!");
                    } catch (java.lang.reflect.InvocationTargetException e2) {
                        System.out.println("MemberData ComboBox Error: Bad Target Receiver!");
                    } catch (java.lang.IllegalAccessException e3) {
                        System.out.println("MemberData ComboBox Error: Illegal Access!");
                    }
                }
            }
        }
    }

    public void Load(MetaClass someClass) {
        theMetaClass = someClass;
        theModel.Load(someClass);
        updateUI();
    }

    public void resetContents() {
        theMetaClass = null;
        theModel.setMetaClass(null);
        updateUI();
    }

    public void Reload(MetaClass someClass) {
        theMetaClass = someClass;
        theModel.Load(someClass);
    }

}

class LizardMemberDataComboBoxListener implements ActionListener {

    public void actionPerformed(ActionEvent evt) {
        LizardMemberDataComboBox theCombo = (LizardMemberDataComboBox) evt.getSource();
        theCombo.selectItem();
    }

}
