/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.classEditor;

import ch.abacus.lib.ui.renderer.common.MetaMethod;
import ch.abacus.lib.ui.renderer.common.MetaClass;

import java.awt.event.*;
import java.lang.reflect.*;


/**
 * Title:        uifactory
 * Description:  This is a program design tool that creates Abacus java applications using the UI Factory.  The output of this tool is an xml document that is processed by the UI factory to create the java programs.
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */


public class LizardMethodComboBox extends LizardComboBox {

    LizardMethodComboBoxModel theModel = null;
    MetaMethod theMethod = null;

    public LizardMethodComboBox(LizardMethodComboBoxModel objModel, Object objReceiver) {
        super(objModel, objReceiver);
        theModel = objModel;
        theReceiver = objReceiver;
        setEditable(true);
        setMaximumRowCount(10);
        addActionListener(new LizardMethodComboBoxListener());
    }

    public void selectMethod(String sMethodName) {
        if (theMetaClass != null) {
            if (!sMethodName.trim().equals("")) {
                MetaMethod theOldMethod = theMethod;
                theMethod = theMetaClass.getMethod(sMethodName, false);
                if (theReceiver != null) {
                    Class clsReceiver = theReceiver.getClass();
                    Class[] clsParams = new Class[2];
                    clsParams[0] = theMethod.getClass();
                    clsParams[1] = theMethod.getClass();
                    try {
                        Method m = clsReceiver.getMethod("selectMethod", clsParams);
                        Object[] objArgList = new Object[2];
                        objArgList[0] = theOldMethod;
                        objArgList[1] = theMethod;
                        m.invoke(theReceiver, objArgList);
                    } catch (java.lang.NoSuchMethodException e1) {
                        System.out.println("Method ComboBox Error: Bad Receiver - SelectMethod!");
                    } catch (java.lang.reflect.InvocationTargetException e2) {
                        System.out.println("Method ComboBox Error: Bad Target Receiver!");
                    } catch (java.lang.IllegalAccessException e3) {
                        System.out.println("Method ComboBox Error: Illegal Access!");
                    }
                }
            }
        }
    }

    public void Load(MetaClass someClass) {
        theMetaClass = someClass;
        theModel.Load(someClass);
        updateUI();
    }

    public void resetContents() {
        theMetaClass = null;
        theModel.theMetaClass = null;
        updateUI();
    }

    public void Reload(MetaClass someClass) {
        theMetaClass = someClass;
        theModel.Load(someClass);
    }

    public void selectItem() {
        String sSelectedItem = (String) getSelectedItem();
        selectItem(sSelectedItem);
    }

    public void appendItem(String sText) {
        theMetaClass.setMethod(sText, "", "");
        Load(theMetaClass);
        selectMethod(sText);
    }

    public void selectItem(String sSelectedItem) {
        if (sSelectedItem.trim().length() == 0)
            return;
        configureEditor(getEditor(), sSelectedItem);
        // Find out if it already exists.
        for (int i = 0; i < getItemCount(); i++) {
            if (getItemAt(i).equals(sSelectedItem)) {
                selectMethod(sSelectedItem);
                return;
            }
        }
        // If not, add a new MemberData.
        appendItem(sSelectedItem);
    }

}

class LizardMethodComboBoxListener implements ActionListener {

    public void actionPerformed(ActionEvent evt) {

        LizardMethodComboBox theCombo = (LizardMethodComboBox) evt.getSource();
        theCombo.selectItem();
    }

}
