/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.*;
import java.util.*;
import java.net.URL;
import java.net.JarURLConnection;
import java.net.URLConnection;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Array;

/**
 * @author Adam Graham, Erin Bay Associates, LLC.
 * @version 1.0
 */


public class DefaultPropertyHelper extends AbstractPropertyHelper {
    String sPropertyName;
    MetaObject theObject;
    SuperDesignCockpit theDesignCockpit;

    public boolean execute(MetaObject metaObject, String sPropertyName, SuperDesignCockpit superDesignCockpit) {
        this.theObject = metaObject;
        this.theDesignCockpit = superDesignCockpit;
        this.sPropertyName = sPropertyName;

        if (theDesignCockpit.getSelectedObject() == null)
            return false;

        if (sPropertyName.equalsIgnoreCase("font")) {
            return doFontHelper(sPropertyName);
        } else if (sPropertyName.equalsIgnoreCase("Foreground")) {
            return doForeground();
        } else if (sPropertyName.equalsIgnoreCase("Background")) {
            return doBackground();
        } else if (sPropertyName.equalsIgnoreCase("Icon")) {
            return doIcon(sPropertyName);
        }

        return false;
    }

    private boolean doIcon(String sPropertyName) {
        String defaultImagesDirectory = "/ch/abacus/lib/ui/renderer/deploy/images";
        try {
            String cname = getClass().getName().replace('.', '/');
            URL uthis = getClass().getResource("/" + cname + ".class");

            URL uImageDir = null;
            Object[] files = null;

            if (uthis.toString().startsWith("file:/")) {
                uthis = getClass().getClassLoader().getResource(".");
                uImageDir = new URL(uthis, defaultImagesDirectory);
                files = new File(uthis.getFile() + defaultImagesDirectory + "/").list();
                for (int fi = 0; fi < files.length; fi++) {
                    String afile = (String) files[fi];
                    files[fi] = (defaultImagesDirectory + "/" + afile);
                }
            } else if (uthis.toString().startsWith("jar:")) {
                uImageDir = getClass().getResource(defaultImagesDirectory + "/");
                JarURLConnection uconn = (JarURLConnection) uImageDir.openConnection();
                Enumeration entries = uconn.getJarFile().entries();
                ArrayList filelist = new ArrayList();
                while (entries.hasMoreElements()) {
                    String afile = (String) entries.nextElement().toString();
                    if (afile.endsWith(".gif") || afile.endsWith(".jpg") || afile.endsWith(".png"))
                        filelist.add(afile);
                }
                files = new String[filelist.size()];
                System.arraycopy(filelist.toArray(), 0, files, 0, files.length);
            } else {

            }

            String selectedFileName = null;
            try {
                selectedFileName = (String) JOptionPane.showInputDialog(theDesignCockpit,
                        null, "Choose Icon", JOptionPane.PLAIN_MESSAGE, null, ((String[]) files), (String) files[0]);
            } catch (Exception i) {
            }

            if (selectedFileName == null || selectedFileName.length() == 0)
                return false;

            theObject.setPropertyValue(sPropertyName, 0, 0, selectedFileName, true);

            URL uImage = new URL(uImageDir, selectedFileName);
            ImageIcon icon = new ImageIcon(uImage);
            if (theObject.theVisualObject instanceof AbstractButton)
                ((AbstractButton) theObject.theVisualObject).setIcon(icon);
            theObject.refresh();
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(theDesignCockpit, e, "Icon Helper Error", JOptionPane.ERROR_MESSAGE);
            return false;
        }
        return true;
    }

    private boolean doBackground() {
        try {
            IDEObjectColorChooser chooser = new IDEObjectColorChooser(theDesignCockpit, false);
            //Color selColor=chooser.theColorChooser.getColor();
            //theObject.setPropertyValue(sPropertyName, 0, 0, selColor, true);
            theObject.refresh();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(theDesignCockpit, e, "Error", JOptionPane.ERROR_MESSAGE);
            //e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean doForeground() {
        try {
            IDEObjectColorChooser chooser = new IDEObjectColorChooser(theDesignCockpit, true);
            //Color selColor=chooser.theColorChooser.getColor();
            //theObject.setPropertyValue(sPropertyName, 0, 0, selColor, true);
            theObject.refresh();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(theDesignCockpit, e, "Error", JOptionPane.ERROR_MESSAGE);
            //e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean doFontHelper(String sPropertyName) {
        String sFontChooserClass = theDesignCockpit.getConfigurationManager().getConfigurationVariable("FONT_CHOOSER", theDesignCockpit.thePreferences.sFontChooserName);
        try {
            Class cls = theDesignCockpit.getClassLoader().getLoader().loadClass(sFontChooserClass);
            if (cls != null) {
                Object[] parameters = new Object[1];
                parameters[0] = theDesignCockpit;
                Class[] parameterTypes = new Class[1];
                parameterTypes[0] = SuperDesignCockpit.class;
                Constructor constructor = cls.getConstructor(parameterTypes);
                Object newValue = constructor.newInstance(parameters);

                theObject.setPropertyValue(sPropertyName, 0, 0, theDesignCockpit.getSelectedObject().getFont(), true);
                theObject.refresh();
            }
        } catch (Exception e) {
            JOptionPane.showMessageDialog(theDesignCockpit, e + ": " + sFontChooserClass, "Error", JOptionPane.ERROR_MESSAGE);
            //e.printStackTrace();
            return false;
        }
        return true;
    }

}
