/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.classEditor.Lizard;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import ch.abacus.lib.ui.renderer.common.MetaContainerType;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.HammerImageIconFactory;
import ch.abacus.lib.ui.JATree;
import ch.abacus.lib.ui.customizer.CustomizerDataElementInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataTableInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataConnectionInterface;

import javax.swing.*;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.dnd.*;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.TooManyListenersException;

/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

//DropTarget implementation that links the drop to the TransferHandler when the transferHandler property is set and the dropTarget property is null.

class IDEComponentPaletteMouseListener implements MouseListener {
    IDEComponentPalette theComponentPalette;

    public IDEComponentPaletteMouseListener (IDEComponentPalette objComponentPalette) {
        theComponentPalette = objComponentPalette;
    }

    public void mouseClicked (MouseEvent evt) {
    }

    public void mouseEntered (MouseEvent evt) {
    }

    public void mouseExited (MouseEvent evt) {
    }

    public void mousePressed (MouseEvent evt) {
    }

    public void mouseReleased (MouseEvent evt) {
    }

}


class IDEComponentPaletteMouseMotionListener implements MouseMotionListener {
    IDEComponentPalette theComponentPalette;

    public IDEComponentPaletteMouseMotionListener (IDEComponentPalette objComponentPalette) {
        theComponentPalette = objComponentPalette;
    }

    public void mouseMoved (MouseEvent e) {
    }

    public void mouseDragged (MouseEvent e) {
    }
}

class IDEComponentPaletteTransferHandler extends TransferHandler {
    IDEComponentPalette theComponentPalette = null;

    public IDEComponentPaletteTransferHandler (IDEComponentPalette objComponentPalette) {
        super("text");
        theComponentPalette = objComponentPalette;
    }
}

/**
 * Transferable
 */
class ComponentTransferable implements Transferable {
    private final String text;  // The data is just a String for now
    private final DataFlavor flavor = DataFlavor.stringFlavor;    //new DataFlavor("mime/type; class=java.io.InputStream", "URL contents");
    IDEComponentPalette palette;

    public ComponentTransferable(IDEComponentPalette paramPalette) {
        palette=paramPalette;
        this.text = "";
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[] { flavor };
    }

    public boolean isDataFlavorSupported(DataFlavor df) {
        return flavor.equals(df);
    }

    public Object getTransferData(DataFlavor df)
      throws UnsupportedFlavorException, IOException {
        if (!isDataFlavorSupported(df)) {
            throw new UnsupportedFlavorException(df);
        }

        return text;
    }
}

public class IDEComponentPalette extends JATree implements java.io.Serializable {
    public SuperDesignCockpit theCockpit = null;
    public DefaultTreeModel theModel = null;
//    private String text = "";
    private IDEComponentPaletteNode selectedNode;
    static final int NO_ERROR = 0;
    static final int INVALID_TOP_LEVEL_SELECTION = 1;
    static final int INVALID_ABALET_SELECTION = 2;
    static final int USE_TABBEDPANE_MENU_OPTION = 3;
    static final int OPERATION_FAILED = 4;
    int dragErrorCondition = NO_ERROR;
    static int INVALID_SELECTION = 5;
    DragSource dragSource;

    public IDEComponentPalette () {
		this.initObject();
    }

    public IDEComponentPalette (DefaultTreeModel objModel,
                                SuperDesignCockpit objCockpit) {
        super(objModel);
        theCockpit = objCockpit;
        theModel = objModel;
		this.initObject();
    }

    private void initObject() {
        addTreeSelectionListener(new IDEComponentPaletteSelectionListener(this));
        if (theCockpit.isCustomizing()) {
            addTreeWillExpandListener(new IDEComponentPaletteWillExpandListener(theCockpit, this));
        }

        // 2005-04-27, acg: Drag cursor
        final DragSourceListener dsl = new DragSourceListener(){
            IDEComponentPalette theTree = IDEComponentPalette.this;

            public void dragEnter(DragSourceDragEvent dsde)
            {
                Point loc = dsde.getLocation();
                Rectangle targetRect = theTree.theCockpit.theViewDisplayer.getBounds();
                SwingUtilities.convertPointFromScreen(loc, theTree.theCockpit.theViewDisplayer);
                if ( targetRect.contains(loc) )
                    dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
                else
                {
                    dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
                }
            }
            public void dragOver(DragSourceDragEvent dsde)
            {
            }
            public void dropActionChanged(DragSourceDragEvent dsde)
            {
            }
            public void dragDropEnd(DragSourceDropEvent dsde)
            {
            }
            public void dragExit(DragSourceEvent dse)
            {
                Point loc = dse.getLocation();
                Rectangle targetRect = theTree.theCockpit.theViewDisplayer.getBounds();
                SwingUtilities.convertPointFromScreen(loc, theTree.theCockpit.theViewDisplayer);
                if ( targetRect.contains(loc) )
                    dse.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
                else
                {
                    dse.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
                }
            }
        };

        // Enables JTree Drag support.
        final ComponentTransferable stfa=new ComponentTransferable(this);
        DragGestureListener aDragGestureListener = new DragGestureListener()
        {
            public void dragGestureRecognized(DragGestureEvent dge)
            {
                dge.startDrag(DragSource.DefaultCopyNoDrop, stfa, dsl);
            }
        };
        dragSource = new DragSource();
        dragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, DnDConstants.ACTION_COPY, aDragGestureListener);
        dragSource.addDragSourceListener(dsl);  // 2005-04-27, acg: Drag cursor

        addMouseMotionListener(new IDEComponentPaletteMouseMotionListener(this));
        addMouseListener(new IDEComponentPaletteMouseListener(this));

        if (theCockpit.isCustomizing()) {
            setCellRenderer(new IDEComponentPaletteCellRenderer());
            ToolTipManager.sharedInstance().registerComponent(this);
        }
        else
        {
            // Reads <Icon> per class from metadata.meta
            setCellRenderer(new IDEOpenComponentPaletteCellRenderer());
            ToolTipManager.sharedInstance().registerComponent(this);
        }
	}

    public TransferHandler getTransferHandlerOld () {
        if (dragErrorCondition == IDEComponentPalette.NO_ERROR)
            return super.getTransferHandler();
        else {
            if (dragErrorCondition == IDEComponentPalette.INVALID_ABALET_SELECTION) {
                JOptionPane pane = new JOptionPane("Only one abalet may be declared for each project and it must be a top level object.",
                        JOptionPane.ERROR_MESSAGE);
                JDialog dialog = pane.createDialog(null, "Component Selection Error");
                dialog.show();
                setDragErrorCondition(IDEComponentPalette.OPERATION_FAILED);
            } else if (dragErrorCondition == IDEComponentPalette.INVALID_TOP_LEVEL_SELECTION) {
                JOptionPane pane = new JOptionPane("Only an abalet or a frame may be a top level selection.",
                        JOptionPane.ERROR_MESSAGE);
                JDialog dialog = pane.createDialog(null, "Component Selection Error");
                dialog.show();
                setDragErrorCondition(IDEComponentPalette.OPERATION_FAILED);
            } else if (dragErrorCondition == IDEComponentPalette.USE_TABBEDPANE_MENU_OPTION) {
                JOptionPane pane = new JOptionPane("Right Click on Tabbed Pane to add Tab Page.",
                        JOptionPane.ERROR_MESSAGE);
                JDialog dialog = pane.createDialog(null, "Component Selection Error");
                dialog.show();
                setDragErrorCondition(IDEComponentPalette.OPERATION_FAILED);
            }
            return null;
        }

    }

    public void setSelectionPath (TreePath path) {
        super.setSelectionPath(path);
        IDEComponentPaletteNode theSelectedNode = (IDEComponentPaletteNode) getLastSelectedPathComponent();
        clearDragErrorCondition();  // Clear error flag.
        // You can get valueChanged while you are dragging.  This avoids the reentrancy.
        if ((theSelectedNode != null) && (theSelectedNode.getMetaClass() != null)) {
            theCockpit.setMouseSelectState(false);
            // Disallow selection of a non frame or non abalet when there is nothing in the project.
            if (theCockpit.getDesignProject().getFirstObject() == null) {
                if ((theSelectedNode.getMetaClass().getMetadata().containerType.getContainerType() != MetaContainerType.CONTAINER_ABALET) &&
                        (theSelectedNode.getMetaClass().getMetadata().containerType.getContainerType() != MetaContainerType.CONTAINER_FRAME)) {
                    setDragErrorCondition(IDEComponentPalette.INVALID_TOP_LEVEL_SELECTION);  // error.
                    return;
                }
            } else {  // abalet must be top object.
                if (theSelectedNode.getMetaClass().getMetadata().containerType.getContainerType() == MetaContainerType.CONTAINER_ABALET) {
                    setDragErrorCondition(IDEComponentPalette.INVALID_ABALET_SELECTION);  // error.
                    return;
                } else if (theSelectedNode.getMetaClass().getMetadata().containerType.getContainerType() == MetaContainerType.CONTAINER_TABPAGE) {
                    setDragErrorCondition(IDEComponentPalette.USE_TABBEDPANE_MENU_OPTION);  // error.
                    return;
                }
            }
        }
        if (theSelectedNode.isCustomizerDataElementGroup() == false) { // leave the selected node, if it represents a Customizer element-group
            if (theSelectedNode.getMetaClass() != null) {
                if (theSelectedNode.getChildCount() == 0)
                    setSelectedNode(theSelectedNode);
                else
                    setSelectedNode(null);
            }
        }
    }


//    public String getText() {
//        return text;
//    }
//
//    public void setText(String sText) {
//        text = sText;
//    }

    public IDEComponentPaletteNode getSelectedNode () {
        return selectedNode;
    }

    public void setSelectedNode (IDEComponentPaletteNode selectedNode) {
        this.selectedNode = selectedNode;
    }


    public void setDragErrorCondition (int iError) {
        dragErrorCondition = iError;
    }

    public int getDragErrorCondition () {
        return dragErrorCondition;
    }

    public void clearDragErrorCondition () {
        dragErrorCondition = NO_ERROR;
    }

    public void PopupClassTool () {

        IDEComponentPaletteNode theSelectedNode = (IDEComponentPaletteNode) getLastSelectedPathComponent();
        if (theSelectedNode != null) {
            if (theSelectedNode.getMetaClass() != null) {
                // Pop it up at the place they double click.
                new Lizard(theSelectedNode.getMetaClass(), theCockpit.theCurrentDesignProject.theMetaProject.getMetadataDispenser(), theCockpit);
            }
        }

    }

    public void setFolderIcons () {
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer) this.getCellRenderer();
        renderer.setOpenIcon(theCockpit.folderCubeIcon);
        // Remove the icons
        renderer.setLeafIcon(theCockpit.componentIcon);
        //renderer.setClosedIcon(theCockpit.folderCubeIcon);
        renderer.setOpenIcon(theCockpit.folderCubeIcon);
    }

    class IDEComponentPaletteCellRenderer extends DefaultTreeCellRenderer {
        /**
         * Configures the renderer based on the passed in components.
         * The value is set from messaging the tree with
         * <code>convertValueToText</code>, which ultimately invokes
         * <code>toString</code> on <code>value</code>.
         * The foreground color is set based on the selection and the icon
         * is set based on on leaf and expanded.
         */
        public Component getTreeCellRendererComponent (JTree tree, Object value,
                                                       boolean sel,
                                                       boolean expanded,
                                                       boolean leaf, int row,
                                                       boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);

            IDEComponentPaletteNode node = (IDEComponentPaletteNode) value;
            if (node.isCustomizerDataConnection()) {
                CustomizerDataConnectionInterface dataConnection = node.getCustomizerDataConnection();
                setIcon(dataConnection.getIcon());
                setToolTipText(dataConnection.getToolTip());
            } else if (node.isCustomizerDataTable()) {
                CustomizerDataTableInterface dataTable = node.getCustomizerDataTable();
                setIcon(dataTable.getIcon());
                setToolTipText(dataTable.getToolTip());
            } else if (node.isCustomizerDataElement()) {
                CustomizerDataElementInterface element = node.getCustomizerDataElement();
                setIcon(element.getIcon());
                setToolTipText(element.getToolTip());
            }
            else if(node.getMetaClass()!=null) // added for Icon supported for customizer
            {
                HammerImageIconFactory theIconFactory = new HammerImageIconFactory(theCockpit.getClassLoader());
                String metadataIcon=node.getMetaClass().getMetadata().sDisplayClassIcon;
                Icon componentIcon = null;

                componentIcon = theIconFactory.getHammerImageIcon(metadataIcon);

                if(componentIcon!=null && metadataIcon.length()>0)
                    setIcon(componentIcon);

                String sDisplayClass=node.getMetaClass().getMetadata().sFullClassName;
                if(sDisplayClass!=null)
                    setToolTipText(sDisplayClass);
            }
            else
                setToolTipText(null);
            return this;
        }
    }

    class IDEOpenComponentPaletteCellRenderer extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent (JTree tree, Object value,
                                                       boolean sel,
                                                       boolean expanded,
                                                       boolean leaf, int row,
                                                       boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);

            IDEComponentPaletteNode node = (IDEComponentPaletteNode) value;

            if(node.getMetaClass()!=null)
            {
                HammerImageIconFactory theIconFactory = new HammerImageIconFactory(theCockpit.getClassLoader());
                String metadataIcon=node.getMetaClass().getMetadata().sDisplayClassIcon;
                //String imagePath = theCockpit.theConfigurationManager.getConfigurationVariable("ImagePath");
                //Icon componentIcon = theIconFactory.getHammerImageIcon(imagePath + "//" + metadataIcon);
                Icon componentIcon = null;

                componentIcon = theIconFactory.getHammerImageIcon(metadataIcon);
                if(componentIcon!=null && metadataIcon.length()>0)
                    setIcon(componentIcon);
                String sDisplayClass=node.getMetaClass().getMetadata().sFullClassName;
                if(sDisplayClass!=null)
                    setToolTipText(sDisplayClass);
            }

            return this;
        }
    }

    class IDEComponentPaletteWillExpandListener implements TreeWillExpandListener {
        private final SuperDesignCockpit theCockpit;
        private final IDEComponentPalette theComponentPalette;

        public IDEComponentPaletteWillExpandListener (SuperDesignCockpit theCockpit, IDEComponentPalette componentPalette) {
            this.theCockpit = theCockpit;
            this.theComponentPalette = componentPalette;
        }

        public void treeWillExpand (TreeExpansionEvent evt) throws ExpandVetoException {
            boolean bPopulated = false;

            // Get the path that will be expanded
            TreePath path = evt.getPath();
            IDEComponentPaletteNode node = (IDEComponentPaletteNode) path.getLastPathComponent();
            if (node.isCustomizerDataTable() && node.deferredNode) {
                bPopulated = theCockpit.theCustomizer.populateDeferredDataElements(node.getCustomizerDataTable(), node);
                if (bPopulated) {
                    node.deferredNode = false; // as it has been populated, it is no longer a deferred node
                } else {
                    // Cancel the operation if the DataTable was not populated
                    throw new ExpandVetoException(evt);
                }
            }

        }

        public void treeWillCollapse (TreeExpansionEvent evt) {
        }
    }
}
