/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.MetaProject;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Aug 30, 2004
 * Time: 2:12:57 PM
 */
public class IDEMenuBar extends JMenuBar {

    private final SuperDesignCockpit theCockpit;
    private final IDEActionManager theActionManager;
    private FileMenu theFileMenu;
    private EditMenu theEditMenu;
    private ToolsMenu theToolsMenu;
    private WindowMenu theWindowMenu;
    private LanguageMenu theLanguageMenu;
    private HelpMenu theHelpMenu;

    public IDEMenuBar (SuperDesignCockpit superDesignCockpit, IDEActionManager ideActionManager) {
        this.theCockpit = superDesignCockpit;
        this.theActionManager = ideActionManager;

        initializeMenus();

        setBorder(null);
        setBackground(null);
    }

    void initializeMenus () {
        LanguageManager langManager = theCockpit.theLanguageManager;

        String sFileMenuLabel = langManager.getMessage("MenuBar.File.label", "File");
        char cFileMenuMnemonic = langManager.getMessage("MenuBar.File.mnemonic", "F").charAt(0);
        String sReopenMenuLabel = langManager.getMessage("MenuBar.File.Reopen.label", "Reopen");
        char cReopenMenuMnemonic = langManager.getMessage("MenuBar.File.Reopen.mnemonic", "R").charAt(0);
        this.theFileMenu = new FileMenu(sFileMenuLabel, cFileMenuMnemonic, sReopenMenuLabel, cReopenMenuMnemonic);

        String sEditMenuLabel = langManager.getMessage("MenuBar.Edit.label", "Edit");
        char cEditMenuMnemonic = langManager.getMessage("MenuBar.Edit.mnemonic", "E").charAt(0);
        this.theEditMenu = new EditMenu(sEditMenuLabel, cEditMenuMnemonic);

        String sToolsMenuLabel = langManager.getMessage("MenuBar.Tools.label", "Tools");
        char cToolsMenuMnemonic = langManager.getMessage("MenuBar.Tools.mnemonic", "T").charAt(0);
        this.theToolsMenu = new ToolsMenu(sToolsMenuLabel, cToolsMenuMnemonic);

        String sWindowMenuLabel = langManager.getMessage("MenuBar.Window.label", "Window");
        char cWindowMenuMnemonic = langManager.getMessage("MenuBar.Window.mnemonic", "W").charAt(0);
        this.theWindowMenu = new WindowMenu(sWindowMenuLabel, cWindowMenuMnemonic);

        String sLanguageMenuLabel = langManager.getMessage("MenuBar.Language.label", "Language");
        char cLanguageMenuMnemonic = langManager.getMessage("MenuBar.Language.mnemonic", "L").charAt(0);
        this.theLanguageMenu = new LanguageMenu(sLanguageMenuLabel, cLanguageMenuMnemonic);

        String sHelpMenuLabel = langManager.getMessage("MenuBar.Help.label", "Help");
        char cHelpMenuMnemonic = langManager.getMessage("MenuBar.Help.mnemonic", "H").charAt(0);
        this.theHelpMenu = new HelpMenu(sHelpMenuLabel, cHelpMenuMnemonic);

        add(theFileMenu);
        add(theEditMenu);
        add(theToolsMenu);
        if (theCockpit.isCustomizing() == false) {
            add(theWindowMenu);
        }
        add(theLanguageMenu);
        add(theHelpMenu);
    }

    public void addProjectItem (SelectProjectAction projectAction) {
        theWindowMenu.addProjectItem(projectAction);
    }

    public WindowMenu getWindowMenu () {
        return theWindowMenu;
    }

    class FileMenu extends JMenu {
        private JMenuItem menuItemNew;
        private JMenuItem menuItemOpen;
        private ReopenMenu reopenMenu;
        private JMenuItem menuItemSave;
        private JMenuItem menuItemSaveAs;
        private JMenuItem menuItemSaveWithCompile;
        private JMenuItem menuItemSaveMeta;
        private JMenuItem menuItemSaveAll;
        private JMenuItem menuItemClose;
        private JMenuItem menuItemExit;

        public FileMenu (String sLabel, char mnemonic, String sReopenLanel, char reopenMnemonic) {
            super(sLabel);
            setMnemonic(mnemonic);

            if (theActionManager.getNewAction() != null)
                menuItemNew = add(theActionManager.getNewAction());

            if (theActionManager.getOpenAction() != null)
                menuItemOpen = add(theActionManager.getOpenAction());

            if (theCockpit.isCustomizing() == false) {
                reopenMenu = new ReopenMenu(sReopenLanel, reopenMnemonic, theCockpit.mruList);
                add(reopenMenu);
            }

            if (theActionManager.getSaveAction() != null)
                menuItemSave = add(theActionManager.getSaveAction());

            if (theActionManager.getSaveAsAction() != null)
                menuItemSaveAs = add(theActionManager.getSaveAsAction());

            if (theActionManager.getSaveWithCompileAction() != null)
                menuItemSaveWithCompile = add(theActionManager.getSaveWithCompileAction());

            if (theActionManager.getSaveMetadataAction() != null) {
                menuItemSaveMeta = add(theActionManager.getSaveMetadataAction());
                menuItemSaveMeta.setEnabled(theCockpit.isCanSaveMetadata());
            }

            if (theActionManager.getSaveAllAction() != null)
                menuItemSaveAll = add(theActionManager.getSaveAllAction());

            if (theActionManager.getCloseAction() != null)
                menuItemClose = add(theActionManager.getCloseAction());

            if (theActionManager.getExitAction() != null) {
                addSeparator();
                menuItemExit = add(theActionManager.getExitAction());
            }
        }

        public JMenuItem getMenuItemNew () {
            return menuItemNew;
        }

        public JMenuItem getMenuItemOpen () {
            return menuItemOpen;
        }

        public ReopenMenu getReopenMenu () {
            return reopenMenu;
        }

        public JMenuItem getMenuItemSave () {
            return menuItemSave;
        }

        public JMenuItem getMenuItemSaveAs () {
            return menuItemSaveAs;
        }

        public JMenuItem getMenuItemSaveWithCompile () {
            return menuItemSaveWithCompile;
        }

        public JMenuItem getMenuItemSaveMeta () {
            return menuItemSaveMeta;
        }

        public JMenuItem getMenuItemSaveAll () {
            return menuItemSaveAll;
        }

        public JMenuItem getMenuItemClose () {
            return menuItemClose;
        }

        public JMenuItem getMenuItemExit () {
            return menuItemExit;
        }

        class ReopenMenu extends MruMenu {

            public ReopenMenu (String s, char mnemonic, MruList mruList) {
                super(s, mruList);
                setMnemonic(mnemonic);
            }

            public void actionPerformed (MruMenuEvent e) {
                DesignProject newProject = null;
                try {
                    newProject = theCockpit.loadProject(e.sFilePath, e.sFileName, theCockpit, MetaProject.FROM_XML_DOCUMENT);
                } catch (HammerException e1) {
                }
                if (newProject != null) {
                    SelectProjectAction actionProject = new SelectProjectAction(newProject, theCockpit);
//            // Add to the window menu.
                    JMenuItem menuitemProject = new JMenuItem(actionProject);
                    theWindowMenu.add(menuitemProject);
                    actionProject.actionPerformed(new ActionEvent(theCockpit, 0, actionProject.theDesignProject.theMetaProject.sName));
                    newProject.theMetaProject.setProjectChangedState(false);
                }
            }
        }

    }

    class EditMenu extends JMenu {
        private JMenuItem menuItemCut;
        private JMenuItem menuItemCopy;
        private JMenuItem menuItemPaste;
        private JMenuItem menuItemUndo;
        private JMenuItem menuItemRedo;

        public EditMenu (String sLabel, char mnemonic) {
            super(sLabel);
            setMnemonic(mnemonic);

            if (theActionManager.getCutAction() != null)
                menuItemCut = add(theActionManager.getCutAction());

            if (theActionManager.getCopyAction() != null)
                menuItemCopy = add(theActionManager.getCopyAction());

            if (theActionManager.getPasteAction() != null)
                menuItemPaste = add(theActionManager.getPasteAction());

            if (theActionManager.getUndoAction() != null)
                menuItemUndo = add(theActionManager.getUndoAction());

            if (theActionManager.getRedoAction() != null)
                menuItemRedo = add(theActionManager.getRedoAction());
        }

        public JMenuItem getMenuItemCut () {
            return menuItemCut;
        }

        public JMenuItem getMenuItemCopy () {
            return menuItemCopy;
        }

        public JMenuItem getMenuItemPaste () {
            return menuItemPaste;
        }

        public JMenuItem getMenuItemUndo () {
            return menuItemUndo;
        }

        public JMenuItem getMenuItemRedo () {
            return menuItemRedo;
        }
    }

    class ToolsMenu extends JMenu {
        private JMenuItem menuItemCompile;
        private JMenuItem menuItemRun;
        private JMenuItem menuItemProjectEdit;
        private JMenuItem menuItemImporter;
        private JMenuItem menuItemFontChooser;
        private JMenuItem menuItemForegroundColorChooser;
        private JMenuItem menuItemBackgroundColorChooser;
        private JMenuItem menuItemDatabaseSelect;
        private JMenuItem menuItemDuplicateObjectNames;

        public ToolsMenu (String sLabel, char mnemonic) {
            super(sLabel);
            setMnemonic(mnemonic);

            if (theActionManager.getCompileAction() != null)
                menuItemCompile = add(theActionManager.getCompileAction());

            if (theActionManager.getRunAction() != null)
                menuItemRun = add(theActionManager.getRunAction());

            if (theActionManager.getProjectPreferencesAction() != null)
                menuItemProjectEdit = add(theActionManager.getProjectPreferencesAction());

            if (theActionManager.getImporterAction() != null)
                menuItemImporter = add(theActionManager.getImporterAction());

            if (theActionManager.getFontChooserAction() != null)
                menuItemFontChooser = add(theActionManager.getFontChooserAction());

            if (theActionManager.getForegroundColorChooserAction() != null)
                menuItemForegroundColorChooser = add(theActionManager.getForegroundColorChooserAction());

            if (theActionManager.getBackgroundColorChooserAction() != null)
                menuItemBackgroundColorChooser = add(theActionManager.getBackgroundColorChooserAction());

            if (theActionManager.getDatabaseSelectionAction() != null)
                menuItemDatabaseSelect = add(theActionManager.getDatabaseSelectionAction());

            if (theActionManager.getDuplicateObjectNamesAction() != null)
                menuItemDuplicateObjectNames = add(theActionManager.getDuplicateObjectNamesAction());
        }

        public JMenuItem getMenuItemCompile () {
            return menuItemCompile;
        }

        public JMenuItem getMenuItemRun () {
            return menuItemRun;
        }

        public JMenuItem getMenuItemProjectEdit () {
            return menuItemProjectEdit;
        }

        public JMenuItem getMenuItemImporter () {
            return menuItemImporter;
        }

        public JMenuItem getMenuItemFontChooser () {
            return menuItemFontChooser;
        }

        public JMenuItem getMenuItemForegroundColorChooser () {
            return menuItemForegroundColorChooser;
        }

        public JMenuItem getMenuItemBackgroundColorChooser () {
            return menuItemBackgroundColorChooser;
        }

        public JMenuItem getMenuItemDatabaseSelect () {
            return menuItemDatabaseSelect;
        }

        public JMenuItem getMenuItemDuplicateObjectNames () {
            return menuItemDuplicateObjectNames;
        }
    }

    class WindowMenu extends JMenu {

        public WindowMenu (String sLabel, char mnemonic) {
            super(sLabel);
            setMnemonic(mnemonic);
        }

        public void addProjectItem (SelectProjectAction projectAction) {
            JMenuItem menuItemProject = new JMenuItem(projectAction);
            theWindowMenu.add(menuItemProject);
        }
    }

    class LanguageMenu extends JMenu {
        private JMenuItem menuItemDeutsch;
        private JMenuItem menuItemFrench;
        private JMenuItem menuItemItalian;
        private JMenuItem menuItemEnglish;

        public LanguageMenu (String sLabel, char mnemonic) {
            super(sLabel);
            setMnemonic(mnemonic);

            if (theActionManager.getLanguageDeutschAction() != null)
                menuItemDeutsch = add(theActionManager.getLanguageDeutschAction());

            if (theActionManager.getLanguageFrancaisAction() != null)
                menuItemFrench = add(theActionManager.getLanguageFrancaisAction());

            if (theActionManager.getLanguageItalianAction() != null)
                menuItemItalian = add(theActionManager.getLanguageItalianAction());

            if (theActionManager.getLanguageEnglishAction() != null)
                menuItemEnglish = add(theActionManager.getLanguageEnglishAction());
        }

        public JMenuItem getMenuItemDeutsch () {
            return menuItemDeutsch;
        }

        public JMenuItem getMenuItemFrench () {
            return menuItemFrench;
        }

        public JMenuItem getMenuItemItalian () {
            return menuItemItalian;
        }

        public JMenuItem getMenuItemEnglish () {
            return menuItemEnglish;
        }
    }

    class HelpMenu extends JMenu {
        private JMenuItem menuItemAbout;

        public HelpMenu (String sLabel, char mnemonic) {
            super(sLabel);
            setMnemonic(mnemonic);

            if (theActionManager.getAboutAction() != null)
                menuItemAbout = add(theActionManager.getAboutAction());

        }

        public JMenuItem getMenuItemAbout () {
            return menuItemAbout;
        }
    }


}
