/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.MetaObject;

import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

/**
 * Created by IntelliJ IDEA.
 * User: Mario
 * Date: April 6th, 2005
 * To change this template use Options | File Templates.
 */
public class IDEMethodComboItemListener implements ItemListener  {
    IDEMethodComboBox theMethodCombo = null;
    public String sMethodNameSelected = null;
    MetaObject theSavedObject = null;

    public IDEMethodComboItemListener(IDEMethodComboBox objMethodCombo) {
        theMethodCombo = objMethodCombo;
    }

    public void itemStateChanged(ItemEvent e)  {
//        theSavedObject.theDesignProject.setProjectChangedState(true);
        if (theSavedObject == null)
            theSavedObject = theMethodCombo.theLastObjectLoaded;
        else {  // If the object is changing, prepare to save the method code.
            if (theSavedObject != theMethodCombo.theLastObjectLoaded) {
                theSavedObject = theMethodCombo.theLastObjectLoaded;
                String sMethodName = (String) theMethodCombo.getSelectedItem();
                if ((sMethodNameSelected != null) && (!sMethodNameSelected.equals(sMethodName))) {
                    if (theMethodCombo.getTheSourceEditor().getText().trim().length() != 0) {
                        theMethodCombo.save(sMethodNameSelected);
                    }
                }
            } else {
                IIDESourceEditor theEditor = theMethodCombo.getTheSourceEditor();

                // Don't allow complete erasures.
                if (sMethodNameSelected != null) {
                    if (theEditor.getText().trim().length() != 0) {
                        theMethodCombo.save(sMethodNameSelected, theEditor.getText());
                    }
                }
            }
        }
        theMethodCombo.showCurrentMethod();
        sMethodNameSelected = (String) theMethodCombo.getSelectedItem();
    }

}
