/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JADialog;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.ActionEvent;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: Aug 16, 2003
 * Time: 9:03:59 PM
 * To change this template use Options | File Templates.
 */



public class IDEMultiSelectAlignmentDialog extends JADialog {
    protected JAPanel JAPanel1 = new JAPanel();
    protected ButtonGroup grpHorz = new ButtonGroup();
    protected IDEMultiSelectDialogRadioButton btnHorzNoChange = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_HORZ_NO_CHANGE);
    protected IDEMultiSelectDialogRadioButton btnHorzLeftSides = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_HORZ_LEFT);
    protected IDEMultiSelectDialogRadioButton btnHorzCenters = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_HORZ_CENTERS);
    protected IDEMultiSelectDialogRadioButton btnHorzRightSides = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_HORZ_RIGHT);
    protected IDEMultiSelectDialogRadioButton btnHorzSpaceEqually = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_HORZ_EQUAL);
    protected IDEMultiSelectDialogRadioButton btnHorzCenterInWindow = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_HORZ_CENTER_IN_WINDOW);
    protected ButtonGroup grpVert = new ButtonGroup();
    protected IDEMultiSelectDialogRadioButton btnVertNoChange = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_VERT_NO_CHANGE);
    protected IDEMultiSelectDialogRadioButton btnVertTops = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_VERT_TOP);
    protected IDEMultiSelectDialogRadioButton btnVertCenters = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_VERT_CENTERS);
    protected IDEMultiSelectDialogRadioButton btnVertBottoms = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_VERT_BOTTOM);
    protected IDEMultiSelectDialogRadioButton btnVertSpaceEqually = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_VERT_EQUAL);
    protected IDEMultiSelectDialogRadioButton btnVertCenterInWindow = new IDEMultiSelectDialogRadioButton(IDEMultiSelectCommandProcessor.ALIGN_VERT_CENTER_IN_WINDOW);
    JAButton btnOk = new JAButton("OK");
    JAButton btnCancel = new JAButton("Cancel");
    SuperDesignCockpit theCockpit;
    protected JPanel pnlVert = new JPanel();
    protected JPanel pnlHorz = new JPanel();
    public IDEMultiSelectAlignmentDialog(SuperDesignCockpit theCockpit) {
        super(theCockpit, "Multiselect Alignment", true, false);
        this.theCockpit = theCockpit;
        initializeInterface();
    }
    public void initializeInterface() {
      TitledBorder pnlHorzBorder;
      TitledBorder pnlVertBorder;

      pnlHorzBorder = new TitledBorder("Horizontal");
      pnlVertBorder = new TitledBorder("Vertical");

      //  Get the content pane of the frame.
      AnchoringLayoutManager layoutManager = new AnchoringLayoutManager();
      AnchoringLayoutManager layoutManagerX = new AnchoringLayoutManager();
      AnchoringLayoutManager layoutManagerY = new AnchoringLayoutManager();

      pnlHorz.setLocation(new java.awt.Point(8,8));
      pnlHorz.setSize(new java.awt.Dimension(150, 164));
      pnlVert.setLocation(new java.awt.Point(160, 8));
      pnlVert.setSize(new java.awt.Dimension(150, 164));
      pnlHorz.setLayout(layoutManagerX);
      pnlVert.setLayout(layoutManagerY);
      pnlVert.setBorder(pnlVertBorder);
      pnlHorz.setBorder(pnlHorzBorder);

      Container container = getContentPane();
      container.setLayout(layoutManager);
      container.add(pnlHorz, "pnlHorz");
      container.add(pnlVert, "pnlVert");
      layoutManager.setAnchoring(pnlHorz, false, false, false, false);
      layoutManager.setAnchoring(pnlVert, false, false, false, false);

      setLocation(new java.awt.Point(32,72));
      setSize(new java.awt.Dimension(324,268));
      //  Add the control container to the content pane.
      //  Add the control grpHorz to the content pane.
      btnHorzNoChange.setLocation(new java.awt.Point(8,16));
      btnHorzNoChange.setSize(new java.awt.Dimension(112,24));
      btnHorzNoChange.setText("No change");
      //  Add the control btnHorzNoChange to the Group.
      grpHorz.add(btnHorzNoChange);
      //  Add the control btnHorzNoChange to the content pane.
      pnlHorz.add(btnHorzNoChange, "btnHorzNoChange");
      layoutManagerX.setAnchoring(btnHorzNoChange, false, false, false, false);
      btnHorzLeftSides.setLocation(new java.awt.Point(8,40));
      btnHorzLeftSides.setSize(new java.awt.Dimension(112,24));
      btnHorzLeftSides.setText("Left sides");
      //  Add the control btnHorzLeftSides to the Group.
      grpHorz.add(btnHorzLeftSides);
      //  Add the control btnHorzLeftSides to the content pane.
      pnlHorz.add(btnHorzLeftSides, "btnHorzLeftSides");
      layoutManagerX.setAnchoring(btnHorzLeftSides, false, false, false, false);
      btnHorzCenters.setLocation(new java.awt.Point(8,64));
      btnHorzCenters.setSize(new java.awt.Dimension(112,24));
      btnHorzCenters.setText("Centers");
      //  Add the control btnHorzCenters to the Group.
      grpHorz.add(btnHorzCenters);
      //  Add the control btnHorzCenters to the content pane.
      pnlHorz.add(btnHorzCenters, "btnHorzCenters");
      layoutManagerX.setAnchoring(btnHorzCenters, false, false, false, false);
      btnHorzRightSides.setLocation(new java.awt.Point(8,88));
      btnHorzRightSides.setSize(new java.awt.Dimension(112,24));
      btnHorzRightSides.setText("Right sides");
      //  Add the control btnHorzRightSides to the Group.
      grpHorz.add(btnHorzRightSides);
      //  Add the control btnHorzRightSides to the content pane.
      pnlHorz.add(btnHorzRightSides, "btnHorzRightSides");
      layoutManagerX.setAnchoring(btnHorzRightSides, false, false, false, false);
      btnHorzSpaceEqually.setLocation(new java.awt.Point(8,112));
      btnHorzSpaceEqually.setSize(new java.awt.Dimension(112,24));
      btnHorzSpaceEqually.setText("Space equally");
      //  Add the control btnHorzSpaceEqually to the Group.
      grpHorz.add(btnHorzSpaceEqually);
      //  Add the control btnHorzSpaceEqually to the content pane.
      pnlHorz.add(btnHorzSpaceEqually, "btnHorzSpaceEqually");
      layoutManagerX.setAnchoring(btnHorzSpaceEqually, false, false, false, false);
      btnHorzCenterInWindow.setLocation(new java.awt.Point(8,136));
      btnHorzCenterInWindow.setSize(new java.awt.Dimension(112,24));
      btnHorzCenterInWindow.setText("Center in window");
      //  Add the control btnHorzCenterInWindow to the Group.
      grpHorz.add(btnHorzCenterInWindow);
      //  Add the control btnHorzCenterInWindow to the content pane.
      pnlHorz.add(btnHorzCenterInWindow, "btnHorzCenterInWindow");
      layoutManagerX.setAnchoring(btnHorzCenterInWindow, false, false, false, false);

      btnVertNoChange.setLocation(new java.awt.Point(8,16));
      btnVertNoChange.setSize(new java.awt.Dimension(112,24));
      btnVertNoChange.setText("No change");
      //  Add the control btnVertNoChange to the Group.
      grpVert.add(btnVertNoChange);
      //  Add the control btnVertNoChange to the content pane.
      pnlVert.add(btnVertNoChange, "btnVertNoChange");
      layoutManagerY.setAnchoring(btnVertNoChange, false, false, false, false);
      btnVertTops.setLocation(new java.awt.Point(8,40));
      btnVertTops.setSize(new java.awt.Dimension(112,24));
      btnVertTops.setText("Tops");
      //  Add the control btnVertTops to the Group.
      grpVert.add(btnVertTops);
      //  Add the control btnVertTops to the content pane.
      pnlVert.add(btnVertTops, "btnVertTops");
      layoutManagerY.setAnchoring(btnVertTops, false, false, false, false);
      btnVertCenters.setLocation(new java.awt.Point(8,64));
      btnVertCenters.setSize(new java.awt.Dimension(112,24));
      btnVertCenters.setText("Centers");
      //  Add the control btnVertCenters to the Group.
      grpVert.add(btnVertCenters);
      //  Add the control btnVertCenters to the content pane.
      pnlVert.add(btnVertCenters, "btnVertCenters");
      layoutManagerY.setAnchoring(btnVertCenters, false, false, false, false);
      btnVertBottoms.setLocation(new java.awt.Point(8,88));
      btnVertBottoms.setSize(new java.awt.Dimension(112,24));
      btnVertBottoms.setText("Bottoms");
      //  Add the control btnVertBottoms to the Group.
      grpVert.add(btnVertBottoms);
      //  Add the control btnVertBottoms to the content pane.
      pnlVert.add(btnVertBottoms, "btnVertBottoms");
      layoutManagerY.setAnchoring(btnVertBottoms, false, false, false, false);
      btnVertSpaceEqually.setLocation(new java.awt.Point(8,112));
      btnVertSpaceEqually.setSize(new java.awt.Dimension(112,24));
      btnVertSpaceEqually.setText("Space equally");
      //  Add the control btnVertSpaceEqually to the Group.
      grpVert.add(btnVertSpaceEqually);
      //  Add the control btnVertSpaceEqually to the content pane.
      pnlVert.add(btnVertSpaceEqually, "btnVertSpaceEqually");
      layoutManagerY.setAnchoring(btnVertSpaceEqually, false, false, false, false);
      btnVertCenterInWindow.setLocation(new java.awt.Point(8,136));
      btnVertCenterInWindow.setSize(new java.awt.Dimension(112,24));
      btnVertCenterInWindow.setText("Center in window");
      //  Add the control btnVertCenterInWindow to the Group.
      grpVert.add(btnVertCenterInWindow);
      //  Add the control btnVertCenterInWindow to the content pane.
      pnlVert.add(btnVertCenterInWindow, "btnVertCenterInWindow");
      layoutManagerY.setAnchoring(btnVertCenterInWindow, false, false, false, false);

      btnOk.setLocation(new java.awt.Point(50,186));
      btnOk.setSize(new java.awt.Dimension(80,22));
      btnOk.addActionListener(new OKButtonAction(this));
      //  Add the control btnOk to the content pane.
      container.add(btnOk, "btnOk");
      layoutManager.setAnchoring(btnOk, false, false, false, false);
      btnCancel.setLocation(new java.awt.Point(196,186));
      btnCancel.setSize(new java.awt.Dimension(80,22));
      btnCancel.addActionListener(new CancelButtonAction(this));
      //  Add the control JAButton2 to the content pane.
      container.add(btnCancel, "btnCancel");
      layoutManager.setAnchoring(btnCancel, false, false, false, false);
      btnHorzNoChange.setSelected(true);
      btnVertNoChange.setSelected(true);
      setLocationRelativeTo(null);
      // Show the main window
      show(null);
    }  // End of the initializeInterface method.

    class OKButtonAction extends AbstractAction {
        IDEMultiSelectAlignmentDialog theEditor = null;

        public OKButtonAction(IDEMultiSelectAlignmentDialog theEditor) {
            super("OK");
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theEditor.removeAll();
            theEditor.hide();
            theEditor = null;
            int Command = IDEMultiSelectCommandProcessor.NOP;
            Command += btnHorzNoChange.getCommand();
            Command += btnHorzLeftSides.getCommand();
            Command += btnHorzCenters.getCommand();
            Command += btnHorzRightSides.getCommand();
            Command += btnHorzSpaceEqually.getCommand();
            Command += btnHorzCenterInWindow.getCommand();
            Command += btnVertNoChange.getCommand();
            Command += btnVertTops.getCommand();
            Command += btnVertCenters.getCommand();
            Command += btnVertBottoms.getCommand();
            Command += btnVertSpaceEqually.getCommand();
            Command += btnVertCenterInWindow.getCommand();
            IDEMultiSelectCommandProcessor theProcessor = new IDEMultiSelectCommandProcessor(theCockpit, Command);
            theProcessor.doCommand();
        }
    }

    class CancelButtonAction extends AbstractAction {
        IDEMultiSelectAlignmentDialog theEditor = null;

        public CancelButtonAction(IDEMultiSelectAlignmentDialog theEditor) {
            super("Cancel");
            this.theEditor = theEditor;
        }

        public void actionPerformed(ActionEvent evt) {
            theEditor.removeAll();
            theEditor.hide();
            theEditor = null;
        }
    }
}
