/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.JAToolBar;
import ch.abacus.lib.ui.JAComboBox;
import ch.abacus.lib.ui.renderer.common.HammerLanguagePresentation;

import javax.swing.*;
import javax.swing.event.ListDataListener;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

/**
 * User: Stuart Booth
 * Date: Jul 26, 2004
 * Time: 11:04:22 PM
 */
public class IDEToolBar extends JAToolBar {
    private final SuperDesignCockpit theCockpit;
    private final IDEActionManager theActionManager;

    private JButton newButton;
    private JButton openButton;
    private JButton saveButton;
    private JButton saveWithCompileButton;
    private JButton saveAllButton;
    private JButton cutButton;
    private JButton copyButton;
    private JButton pasteButton;
    private JButton fontButton;
    private JButton fgColorButton;
    private JButton bgColorButton;
    private JButton dbSelectButton;
    private JButton compileButton;
    private JButton runButton;
    private JButton projectEditButton;
    private JButton importerButton;
    private JButton pointModeButton;
    private JAComboBox languageComboBox;

    public IDEToolBar (SuperDesignCockpit theCockpit, IDEActionManager theActionManager) {
        this.theCockpit = theCockpit;
        this.theActionManager = theActionManager;

        setFocusable(false);
        setRollover(true);

        setBorder(null);
        setFloatable(false);

        Color colToolbar = UIManager.getColor("ToolBar.background");
        if (colToolbar == null) colToolbar = this.getBackground();
        setBackground(colToolbar);

        initInterface(colToolbar);
    }

    void initInterface (Color color) {
        if (theActionManager.getNewAction() != null) {
            newButton = add(theActionManager.getNewAction());
            newButton.setBackground(color);
        }

        if (theActionManager.getOpenAction() != null) {
            openButton = add(theActionManager.getOpenAction());
            openButton.setBackground(color);
        }

        if (theActionManager.getSaveAction() != null) {
            saveButton = add(theActionManager.getSaveAction());
            saveButton.setBackground(color);
        }

        if (theActionManager.getSaveWithCompileAction() != null) {
            saveWithCompileButton = add(theActionManager.getSaveWithCompileAction());
            saveWithCompileButton.setBackground(color);
        }

        if (theActionManager.getSaveAllAction() != null) {
            saveAllButton = add(theActionManager.getSaveAllAction());
            saveAllButton.setBackground(color);
        }

        addSeparator();

        if (theActionManager.getCutAction() != null) {
            cutButton = add(theActionManager.getCutAction());
            cutButton.setBackground(color);
        }

        if (theActionManager.getCopyAction() != null) {
            copyButton = add(theActionManager.getCopyAction());
            copyButton.setBackground(color);
        }

        if (theActionManager.getPasteAction() != null) {
            pasteButton = add(theActionManager.getPasteAction());
            pasteButton.setBackground(color);
        }

        addSeparator();

        if (theActionManager.getFontChooserAction() != null) {
            fontButton = add(theActionManager.getFontChooserAction());
            fontButton.setBackground(color);
        }

        if (theActionManager.getForegroundColorChooserAction() != null) {
            fgColorButton = add(theActionManager.getForegroundColorChooserAction());
            fgColorButton.setBackground(color);
        }

        if (theActionManager.getBackgroundColorChooserAction() != null) {
            bgColorButton = add(theActionManager.getBackgroundColorChooserAction());
            bgColorButton.setBackground(color);
        }

        if (theActionManager.getDatabaseSelectionAction() != null) {
            dbSelectButton = add(theActionManager.getDatabaseSelectionAction());
            dbSelectButton.setBackground(color);
        }

        addSeparator();

        if (theActionManager.getCompileAction() != null) {
            compileButton = add(theActionManager.getCompileAction());
            compileButton.setBackground(color);
        }

        if (theActionManager.getRunAction() != null) {
            runButton = add(theActionManager.getRunAction());
            runButton.setBackground(color);
        }

        addSeparator();

        if (theActionManager.getProjectPreferencesAction() != null) {
            projectEditButton = add(theActionManager.getProjectPreferencesAction());
            projectEditButton.setBackground(color);
        }

        if (theActionManager.getImporterAction() != null) {
            importerButton = add(theActionManager.getImporterAction());
            importerButton.setBackground(color);
        }

        if (theActionManager.getPointModeAction() != null) {
            pointModeButton = add(theActionManager.getPointModeAction());
            pointModeButton.setBackground(color);
        }

        addSeparator();

        // Add a combobox for the language...
        languageComboBox = createLanguageComboBox();
        add(languageComboBox);
    }

    public void addSeparator() {
        if (! (getComponentAtIndex(getComponentCount() -1) instanceof JSeparator))
            super.addSeparator();
    }

    private JAComboBox createLanguageComboBox () {
        String sGerman = theActionManager.getLanguageDeutschAction().getLabel();
        String sFrench = theActionManager.getLanguageFrancaisAction().getLabel();
        String sItalian = theActionManager.getLanguageItalianAction().getLabel();
        String sEnglish = theActionManager.getLanguageEnglishAction().getLabel();

        JAComboBox combo = new JAComboBox(new Object[]{sGerman, sFrench, sItalian, sEnglish});
        combo.setToolTipText(theCockpit.theLanguageManager.getMessage("LanguageComboBox.tooltip", "Set Language"));

        combo.setMaximumSize(combo.getPreferredSize());

        combo.addActionListener(new ActionListener() {
            public void actionPerformed (ActionEvent e) {
                int iSelectedItem = (languageComboBox.getSelectedIndex());
                switch (iSelectedItem) {
                    case HammerLanguagePresentation.DEUTSCH:
                        theCockpit.theActionManager.getLanguageDeutschAction().actionPerformed(new ActionEvent(this, 0, null));
                        break;
                    case HammerLanguagePresentation.FRANCAIS:
                        theCockpit.theActionManager.getLanguageFrancaisAction().actionPerformed(new ActionEvent(this, 0, null));
                        break;
                    case HammerLanguagePresentation.ITALIAN:
                        theCockpit.theActionManager.getLanguageItalianAction().actionPerformed(new ActionEvent(this, 0, null));
                        break;
                    case HammerLanguagePresentation.ENGLISH:
                        theCockpit.theActionManager.getLanguageEnglishAction().actionPerformed(new ActionEvent(this, 0, null));
                        break;
                }
            }
        });
        return combo;
    }

    void setPointModeButtonEnabledState (boolean bEnabled) {
        pointModeButton.setEnabled(bEnabled);
    }

    void setLangauge (int iLanguage) {
        languageComboBox.setSelectedIndex(iLanguage);
    }
}
