/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.renderer.common.HammerJarAccess;

import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: Jun 18, 2003
 * Time: 7:47:36 PM
 * To change this template use Options | File Templates.
 */


public class JarContentsTree extends JTree {
    DefaultTreeModel theModel;
    JarContentsTreeNode baseNode;
    JarContentsFilter theFilter;
    String sJarName;

    public JarContentsTree(String sJarName, JarContentsFilter theFilter) {
        super();
        this.sJarName = sJarName;
        this.theFilter = theFilter;
        baseNode = new JarContentsTreeNode("Jar Projects");
        theModel = new DefaultTreeModel(baseNode, true);
        this.setModel(theModel);
    }

    public boolean load() {
        HashMap theMap = new HashMap();
        try {
            // open the jar
            JarFile jarf = new JarFile(sJarName);
            // get all jar entries that match the filter.
            Enumeration allentries = jarf.entries();
            while (allentries.hasMoreElements()) {
                JarEntry entry = (JarEntry) allentries.nextElement();
                String sTestName = entry.getName();
                if (theFilter.checkFile(sTestName)) {
                    HammerJarAccess theAccess = new HammerJarAccess(jarf, entry);
                    JarContentsTreeJarAccess theLink = new JarContentsTreeJarAccess(theAccess, null, sTestName);
                    theMap.put(sTestName, theLink);
                }
            }
        } catch (IOException e1) {
            return false;
        }
        // sort them.
        TreeMap theMatchingEntries = new TreeMap(theMap);
        // create the nodes.
        Iterator theIterator = theMatchingEntries.values().iterator();
        while (theIterator.hasNext()) {
            JarContentsTreeJarAccess objStored = (JarContentsTreeJarAccess) theIterator.next();
            createNodes(objStored);
        }
        repaint();
        return true;
    }

    private JarContentsTreeNode createNode(DefaultMutableTreeNode theNode, JarContentsTreeJarAccess theAccess, String sKey) {
        boolean bAllowsChildren = true;
        JarContentsTreeNode theNewNode = new JarContentsTreeNode(theAccess, bAllowsChildren, sKey);
        this.theModel.insertNodeInto(theNewNode, theNode, theNode.getChildCount());
        return theNewNode;
    }

    private JarContentsTreeNode createNode(DefaultMutableTreeNode theNode, String sKey) {
        JarContentsTreeNode theNewNode = new JarContentsTreeNode(sKey);
        this.theModel.insertNodeInto(theNewNode, theNode, theNode.getChildCount());
        return theNewNode;
    }

    private JarContentsTreeNode findNode(DefaultMutableTreeNode theParent, String sKey) {
        if (theParent.getChildCount() <= 0)
            return null;
        JarContentsTreeNode theChild = (JarContentsTreeNode) theModel.getChild(theParent, 0);
        while (theChild != null) {
            String sCompareKey = (String) theChild.getUserObject();
            if (sCompareKey.equals(sKey))
                return theChild;
            theChild = (JarContentsTreeNode) theChild.getNextSibling();
        }
        return null;
    }

    private void createNodes(JarContentsTreeJarAccess nodeInformation) {
        String sKey = nodeInformation.sKey;
        int iIndex = sKey.indexOf("/");
        DefaultMutableTreeNode theNode = baseNode;
        while (iIndex != -1) {
            String sSegment = sKey.substring(0, iIndex);
            JarContentsTreeNode theNewNode = findNode(theNode, sSegment);
            if (theNewNode == null)
                theNode = createNode(theNode, sSegment);
            else
                theNode = theNewNode;
            sKey = sKey.substring(iIndex + 1);
            iIndex = sKey.indexOf("/");
        }
        if (sKey.length() > 0) {
            DefaultMutableTreeNode theNewNode = findNode(theNode, sKey);
            if (theNewNode == null) {
                createNode(theNode, nodeInformation, sKey);
            }
        }
    }


}
