/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import java.text.MessageFormat;
import java.util.*;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Sep 26, 2004
 * Time: 11:20:58 AM
 */
public class LanguageManager {
    private final SuperDesignCockpit theCockpit;
    private HashMap theKeys = null; // this will hold the keys from all bundles
    private ResourceBundle theFrameComponentsBundle = null;
    private ResourceBundle theActionsBundle = null;
    private ResourceBundle theDialogsBundle = null;
    private ResourceBundle theErrorsBundle = null;


    public LanguageManager (SuperDesignCockpit superDesignCockpit) {
        theCockpit = superDesignCockpit;

        if (theCockpit.isCustomizing()) {
            String sLanguageId = null;
            Locale locale = null;

            theKeys = new HashMap();

            if (theCockpit.theGlobalInterface != null) {
                sLanguageId = theCockpit.theGlobalInterface.getLanguage().getISOCode();
                locale = new Locale(sLanguageId);
            }

            if (sLanguageId == null) {
                locale = Locale.getDefault();
            }

            try {
                theActionsBundle = ResourceBundle.getBundle(theCockpit.getCustomizerLanguagePath() + "actions", locale);
                Enumeration keys = theActionsBundle.getKeys();
                while (keys.hasMoreElements()) {
                    String sKey = (String)keys.nextElement();
                    String sValue = theActionsBundle.getString(sKey);
                    theKeys.put(sKey, sValue);
                }
            } catch (MissingResourceException e) {
                theCockpit.theLogFile.doLogEntry("Missing Language File", "Cannot find 'actions.properties', which is required to apply language translations");
            }

            try {
                theFrameComponentsBundle = ResourceBundle.getBundle(theCockpit.getCustomizerLanguagePath() + "frameComponents", locale);
                Enumeration keys = theFrameComponentsBundle.getKeys();
                while (keys.hasMoreElements()) {
                    String sKey = (String)keys.nextElement();
                    String sValue = theFrameComponentsBundle.getString(sKey);
                    theKeys.put(sKey, sValue);
                }
            } catch (MissingResourceException e) {
                theCockpit.theLogFile.doLogEntry("Missing Language File", "Cannot find 'frameComponents.properties', which is required to apply language translations");
            }

            try {
                theDialogsBundle = ResourceBundle.getBundle(theCockpit.getCustomizerLanguagePath() + "dialogs", locale);
                Enumeration keys = theDialogsBundle.getKeys();
                while (keys.hasMoreElements()) {
                    String sKey = (String)keys.nextElement();
                    String sValue = theDialogsBundle.getString(sKey);
                    theKeys.put(sKey, sValue);
                }
            } catch (MissingResourceException e) {
                theCockpit.theLogFile.doLogEntry("Missing Language File", "Cannot find 'dialogs.properties', which is required to apply language translations");
            }

            try {
                theErrorsBundle = ResourceBundle.getBundle(theCockpit.getCustomizerLanguagePath() + "errors", locale);
                Enumeration keys = theErrorsBundle.getKeys();
                while (keys.hasMoreElements()) {
                    String sKey = (String)keys.nextElement();
                    String sValue = theErrorsBundle.getString(sKey);
                    theKeys.put(sKey, sValue);
                }
            } catch (MissingResourceException e) {
                theCockpit.theLogFile.doLogEntry("Missing Language File", "Cannot find 'errors.properties', which is required to apply language translations");
            }
        }
    }

    public String expandMessage (String sLanguageKey, String sDefaultMessage, String arg1) {
        Object[] arguments = {arg1};

        return expandMessage(sLanguageKey, sDefaultMessage, arguments);
    }

    public String expandMessage (String sLanguageKey, String sDefaultMessage, String arg1, String arg2) {
        Object[] arguments = {arg1, arg2};

        return expandMessage(sLanguageKey, sDefaultMessage, arguments);
    }

    public String expandMessage (String sLanguageKey, String sDefaultMessage, String arg1, String arg2, String arg3) {
        Object[] arguments = {arg1, arg2, arg3};

        return expandMessage(sLanguageKey, sDefaultMessage, arguments);
    }

    public String expandMessage (String sLanguageKey, String sDefaultMessage, Object[] arguments) {
        String sExpandedMessage = null;
        String sMessage = getMessage(sLanguageKey, sDefaultMessage);

        try {
            sExpandedMessage = MessageFormat.format(sMessage, arguments);
        } catch (IllegalArgumentException e)  {
            // Write log message!
            theCockpit.theLogFile.doLogEntry("Could not format language message", "LanguageKey = " +sLanguageKey + " DefaultMessage = " +sDefaultMessage + " Message = " +sMessage);

            return sDefaultMessage;
        }

        return sExpandedMessage;
    }

    public String getMessage (String sLanguageKey, String sDefaultMessage) {
        if (theKeys == null)
            return sDefaultMessage;

        String sMessage = (String)(theKeys.get(sLanguageKey));
        if (sMessage != null)
            return sMessage;
        else
            return sDefaultMessage;
    }

    public ResourceBundle getFrameComponentsBundle () {
        return theFrameComponentsBundle;
    }

    public ResourceBundle getActionsBundle () {
        return theActionsBundle;
    }

    public ResourceBundle getDialogsBundle () {
        return theDialogsBundle;
    }

    public ResourceBundle getErrorsBundle () {
        return theErrorsBundle;
    }
}
