/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  MruMenuEvent.java
 *
 * Creator:
 * 29.12.2003 15:33:54 vegh
 *
 * Maintainer:
 * 29.12.2003 15:33:54 vegh
 *
 * Last Modification:
 * $Id: MruMenuEvent.java,v 1.1 2004/06/16 08:54:07 vegh Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.designcockpit.ide;

import java.awt.event.ActionEvent;

public class MruMenuEvent extends ActionEvent {
    String sFileName;
    String sFilePath;
    /**
     * Constructs an <code>ActionEvent</code> object.
     * <p>Note that passing in an invalid <code>id</code> results in
     * unspecified behavior.
     *
     * @param source  the object that originated the event
     * @param id      an integer that identifies the event
     * @param command a string that may specify a command (possibly one
     *                of several) associated with the event
     * @param sFileName the file name of the selected file (no path)
     * @param sFilePath the fully-qualified path of the selected file
     */
    public MruMenuEvent(Object source, int id, String command, String sFileName, String sFilePath) {
        super(source, id, command);
        this.sFileName = sFileName;
        this.sFilePath = sFilePath;
    }
}