/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import java.io.File;

/**
 * User: Stuart Booth
 * Date: Jul 27, 2004
 * Time: 10:58:11 AM
 */
class ProjFileFilter extends javax.swing.filechooser.FileFilter {
    private SuperDesignCockpit cockpit;

    public ProjFileFilter (SuperDesignCockpit cockpit) {
        this.cockpit = cockpit;
    }

    public boolean accept (File file) {
        if (file.isDirectory())
            return true;
        String sFileName = file.getName();
        int iDotIndex = sFileName.lastIndexOf('.');
        if (iDotIndex > 0 && iDotIndex < sFileName.length() - 1) {
            String sExt = sFileName.substring(iDotIndex + 1).toLowerCase();
            if( cockpit.getOpenSourceState() == true && (sExt.equals("proj")) )
                return true;
            if (cockpit.getOpenSourceState() == false &&  (sExt.equals("proj") || sExt.equals("proz")) /*|| sExt.equals("jar")*/)
                return true;
        }
        return false;
    }

    public String getDescription () {
        if (cockpit.getOpenSourceState() == true)
            return "Abacus Project Files (*.proj)";
        else
            return "Abacus Project Files (*.proj) and Compressed Project Files (*.proz)"; // or Jars (*.jar)";
    }
}
