/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.abaRenderer.AbaRenderer;
import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.lib.ui.validation.ValidationStaticMethods;
import ch.abacus.lib.util.GlobalInterface;

import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Properties;


/* To run this program:
/*
/*  // switch to the working directory.
/*  //d:
/*  //cd d:\\abajava\\java\\ch\\abacus\\lib\\util\\ide
/*  // Execute java or javaw
/*  //D:\\JBuilder6\\j2sdk1.4.0\\bin\\javaw -classpath "C:\Documents and Settings\Administrator\jbproject\ide\Class;D:\JBuilder6\jakarta-tomcat-3.2.3\lib\servlet.jar;D:\abajava\java\jcert.jar;D:\abajava\java\jnet.jar;D:\JBuilder6\lib\jdom.jar;D:\JBuilder6\lib\xerces.jar;D:\abajava\java\cf.jar;D:\abajava\java\cutils.jar;D:\abajava\java\cbeans.jar;D:\JBuilder6\j2sdk1.4.0\demo\jfc\Java2D\Java2Demo.jar;D:\JBuilder6\j2sdk1.4.0\demo\plugin\jfc\Java2D\Java2Demo.jar;D:\JBuilder6\j2sdk1.4.0\jre\lib\charsets.jar;D:\JBuilder6\j2sdk1.4.0\jre\lib\ext\dnsns.jar;D:\JBuilder6\j2sdk1.4.0\jre\lib\ext\ldapsec.jar;D:\JBuilder6\j2sdk1.4.0\jre\lib\ext\localedata.jar;D:\JBuilder6\j2sdk1.4.0\jre\lib\ext\sunjce_provider.jar;D:\JBuilder6\j2sdk1.4.0\jre\lib\jaws.jar;D:\JBuilder6\j2sdk1.4.0\jre\lib\jce.jar;D:\JBuilder6\j2sdk1.4.0\jre\lib\jsse.jar;D:\JBuilder6\j2sdk1.4.0\jre\lib\rt.jar;D:\JBuilder6\j2sdk1.4.0\jre\lib\sunrsasign.jar;D:\JBuilder6\j2sdk1.4.0\lib\dt.jar;D:\JBuilder6\j2sdk1.4.0\lib\htmlconverter.jar;D:\JBuilder6\j2sdk1.4.0\lib\tools.jar"  ch.abacus.designcockpit.ide.SuperDesignCockpit
/**/


public class SuperDesignCockpit extends JAFrame implements AbaMetaDataUser {
    Dimension theLastSize = null;
    IDEComponentPalettePane theComponentPalettePane;
    //IDEMethodList theMethodList = null;
    ObjectTreeViewPane theObjectTreeViewPane;
    //PropertyTable thePropertyTable;
    boolean bInitialized = false;
    IDEImportManager importManager = new IDEImportManager();
    IDESourceViewer theSourceViewer = null;
    public IDEViewDisplayer theViewDisplayer;
    //IDEStatusBar theStatusPanel = new IDEStatusBar(this);
    UIFactoryCodeJumper theCodeJumper = null;
    SizeboxSet theSizeboxes = new SizeboxSet();
    Sizeboxes theFrameSizeboxes = null;
    HammerLogFileAccess theLogFile = null;
    public HammerFileManager theFileManager = new HammerFileManager(this);
    public String sBaseDir = "";
    public String sUserHome = "";
    public GlobalInterface theGlobalInterface = null;
    public HammerConfigurationManager theConfigurationManager = null;
    public HammerClassLoader theClassLoader = null;
    public PrintStream oldErr = null;
    public IDEClipboardController theClipboardController = new IDEClipboardController(this);
    // List major revisions here.
    // Version 0.  Revision 1. Sub Revision 0. Build 1.  4/6/2002.
    // Version 0.  Revision 1. Sub Revision 1. Build 1.  4/13/2002.
    // Version 0.  Revision 1. Sub Revision 2. Build 1.  4/18/2002.
    // Version 0.  Revision 1. Sub Revision 5. Build 1.  5/31/2002.
    // Version 0.  Revision 1. Sub Revision 6. Build 1.  2/28/2003.
    // Version 0.  Revision 2. Sub Revision 0. Build 1.  4/4/2003.
    // Version 0.  Revision 3. Sub Revision 0. Build 1.  5/1/2003.
    // Version 0.  Revision 4. Sub Revision 0. Build 1.  7/2/2003.
    // Version 0.  Revision 4. Sub Revision 4. Build 1.  10/7/2003
    // Version 0.  Revision 4. Sub Revision 5. Build 1.  11/22/2003
    // Version 0.  Revision 4. Sub Revision 9. Build 1.  2/20/2004

    static final int iVersionNumber = 0;
    static final int iRevisionNumber = 4;
    static final int iSubRevisionNumber = 9;
    static final int iBuildNumber = 1;

    private boolean bMouseSelectState = true;

    private static final int DIVIDER_SIZE = 12;


    public Container theContainer;
    public Properties props = System.getProperties();
    String sCurrentDirectory = props.getProperty("user.home");
    String sOutputDirectory = null;
    String sCodeGenerationDocument = null;
    public JAScrollPane theControlPalettePane;
    public JAScrollPane theMethodListScrollPane;
    public JAScrollPane thePropertyTableScrollPane;
    public JAScrollPane theViewDisplayerScrollPane;
    public JAScrollPane theSourceViewerScrollPane;

    //#ALEX, Small UI mod
    //public JAPanel theMenuPanel = null;

    public JAPanel theDesignPanel = null;
    static String theProjectName = null;
    String theStartupProjectPath = null;
    private boolean bAllowDragging = true;
    public MetadataDispenser theMetadataDispenser;

    public IDECustomizer theCustomizer = null;
    public FramePlacement theFramePlacement = new FramePlacement(this);

    // Set this flag when run from a program that is not connected
    // to the abacus menu.  It means the program does not have
    // a global interface, but is not standalone.
    //
    // If set, this means that we do not perform a system exit.
    public boolean bStartedFromExternalProgram = false;
    private boolean bCanSaveMetadata        = false;
    private boolean bGuru                   = false;
    private boolean bNova                   = false;
    private boolean bOpenSource             = false;
    private boolean bUseJaninoCompiler      = false;
    private boolean bPathClasspath          = false;

    private IDEToolBar theToolBar;
    private IDEMenuBar theMenuBar;
    private boolean bDropletsState;
    private Component lastFocussedComponent; // used by the menu to store the component that had the focus prior to displaying the menu
    private boolean bMetadataDirty          = false;
    // NewComboBox
    private JAPanel   jHeaderPanel ;
    private JALabel   jHeaderLabel ;
    private IDEMethodComboBox jHeaderComboBox;
    private String metadataClasspath = null;
    private IDEPropertyInspectorController idePropertyInspectorController;

    public String getCustomizerLanguagePath () {
        return theCustomizerLanguagePath;
    }

    private String theCustomizerLanguagePath; // stores the path to find the Customizer's language files


    public String getSystemMetadataDocumentName () {
        return SystemMetadataDocumentName;
    }

    public void setSystemMetadataDocumentName (String SystemMetadataDocumentName) {
        this.SystemMetadataDocumentName = SystemMetadataDocumentName;
    }

    public String getSystemConfigurationPathName () {
        return SystemConfigurationPathName;
    }

    public void setSystemConfigurationPathName (String systemConfigurationPathName) {
        SystemConfigurationPathName = systemConfigurationPathName;
    }

    public String getSystemConfigurationDocumentName () {
        return SystemConfigurationDocumentName;
    }

    public void setSystemConfigurationDocumentName (String systemConfigurationDocumentName) {
        SystemConfigurationDocumentName = systemConfigurationDocumentName;
    }

    public boolean getGuruState () {
        return bGuru;
    }

    public boolean getNovaState () {
        return bNova;
    }

    //MHC
    public boolean getOpenSourceState () {
        return bOpenSource;
    }

    public boolean getDropletsState() {
        return this.bDropletsState;
    }

    public boolean isJaninoCompilerWanted() {
        return bUseJaninoCompiler;
    }

    public void showObject (MetaObject theObject) {
        theViewDisplayer.create(theObject);
    }

    public void tellProgress (String s) {
        if (theSourceViewer != null) {
            theSourceViewer.theMessagesEditor.append(s + "\n");
            theSourceViewer.update();
            if(bOpenSource==true)
                theSourceViewer.setSelectedIndex(1);
        }
    }

    public boolean isbMetadataDirty() {
        return bMetadataDirty;
    }

    public void setbMetadataDirty(boolean bMetadataDirty) {
        this.bMetadataDirty = bMetadataDirty;
    }

    public Component getLastFocussedComponent() {
        return lastFocussedComponent;
    }

    /**
     * Stores the component that had the focus prior to the menu being displayed (and thus changing the focus).<p>
     * This is used when a method needs to determine what the focus is during an action being performed.<p>
     * If the action had been intitiated via a menu, then the focus will no longer be on the "correct" component<p>
     * @param lastFocussedComponent - the component that had the focus prior to the menu being displayed
     */
    public void setLastFocussedComponent(Component lastFocussedComponent) {
        this.lastFocussedComponent = lastFocussedComponent;
        //System.out.println("LFC = " +lastFocussedComponent);
    }

    public String SystemConfigurationPathName;
    public String SystemConfigurationDocumentName;
    public String SystemMetadataDocumentName;

    IDEActionManager theActionManager = null;

    LanguageManager theLanguageManager = null;
    IDEStatusBar theStatusPanel = null;

    CodeJumperAction codeJumperAction = null;

    static int STRIPPED = 1;
    static int JAVABUILDER = 2;
    int theProgramMode = SuperDesignCockpit.STRIPPED;
    String theSeparator = "";

    DesignProject theFirstDesignProject = null;
    DesignProject theLastDesignProject = null;
    DesignProject theCurrentDesignProject = null;

    public DesignCockpitPreferences thePreferences = null;

    HammerLNF objDesignLookAndFeel = null;
    Class[] dataBaseClasses;
    String theDataBasePath = "";
    String sImageDirectory = "";

    JSplitPane paneOne, paneTwo, paneThree; // splitters for resizing windows
    JSplitPane  paneRight;
    public IDEObjectPopupMenu theLastPopupMenu = null;

    public Icon formatIcon;
    public Icon addIcon;
    public Icon prjIcon;
    public Icon codeJumperIcon;
    public Icon saveAllIcon;
    public Icon exitIcon;
    public Icon helpIcon;
    public Icon helperIcon;
    public Icon cutIcon;
    public Icon deleteIcon;
    public Icon folderCubeIcon;
    public Icon CubeIcon;
    public Icon componentIcon;
    public Icon componentFolderIcon;

    public Icon impClassNameSetIcon;
    public Icon impIdDataSetIcon;
    public Icon impMemberDataSetIcon;
    public Icon impMethodSetIcon;
    public Icon impPropertySetIcon;
    public Icon impCodeGenSetIcon;

    MruList mruList;

    public void setMouseSelectState (boolean bState) {
        if (isCustomizing() == false) {
            bMouseSelectState = bState;
            if (bState)
                theToolBar.setPointModeButtonEnabledState(false);
            else
                theToolBar.setPointModeButtonEnabledState(true);
        }
    }

    public boolean getMouseSelectState () {
        return bMouseSelectState;
    }

    public LanguageManager getLanguageManager() {
        return theLanguageManager;
    }

    public DesignProject getDesignProject () {
        return theCurrentDesignProject;
    }

    public DesignProject getFirstDesignProject () {
        return theFirstDesignProject;
    }

    public DesignProject getLastDesignProject () {
        return theLastDesignProject;
    }


    public String getNewProjectName () {
        int iCountNewProjects = 0;
        DesignProject testProject = theFirstDesignProject;
        while (testProject != null) {
            if (testProject.theMetaProject.getName().startsWith("New Project"))
                iCountNewProjects++;
            testProject = testProject.theNextDesignProject;
        }
        if (iCountNewProjects == 0)
            return "New Project";
        else
            return "New Project (" + iCountNewProjects + ")";
    }

    public void setComponentSizes (Dimension dim) {
        bInitialized = false;
        theStatusPanel.setPreferredSize(new Dimension(dim.width, 20));

        setSize(thePreferences.getFrameWidth(), thePreferences.getFrameHeight());
        setLocation(thePreferences.getFrameLeft(), thePreferences.getFrameTop());
        if (thePreferences.isFrameMaximized())
            setExtendedState(getExtendedState() | Frame.MAXIMIZED_BOTH);

        // Set the minimum sizes...
//        Dimension minSize = new Dimension(100, 100);
//        theObjectTreeViewPane.setMinimumSize(minSize);
//        theComponentPalettePane.setMinimumSize(minSize);
//        theViewDisplayerScrollPane.setMinimumSize(minSize);
//        thePropertyTableScrollPane.setMinimumSize(minSize);
//        if (theProgramMode == SuperDesignCockpit.JAVABUILDER) {
//            theSourceViewerScrollPane.setMinimumSize(minSize);
//            theMethodListScrollPane.setMinimumSize(minSize);
//        }

        bInitialized = true;
    }


    public SuperDesignCockpit (String sPreferences,
                               GlobalInterface theGlobalInterface,
                               String SystemConfigurationPathName,
                               String SystemConfigurationDocumentName,
                               String SystemMetadataDocumentName) throws HammerException {
        super(false);
        setSystemConfigurationPathName(SystemConfigurationPathName);
        setSystemConfigurationDocumentName(SystemConfigurationDocumentName);
        setSystemMetadataDocumentName(SystemMetadataDocumentName);
        init(sPreferences, theGlobalInterface);

    }

    public SuperDesignCockpit (String sPreferences,
                               GlobalInterface theGlobalInterface) throws HammerException {
        super(false);
        setSystemConfigurationDocumentName("hammer-configuration.xml");
        setSystemMetadataDocumentName("metadata.meta");
        init(sPreferences, theGlobalInterface);
    }

    public SuperDesignCockpit (boolean bEnableValidation) {
        super(bEnableValidation);
    }

    public SuperDesignCockpit (String sPreferences,
                               GlobalInterface theGlobalInterface,
                               String SystemConfigurationPathName,
                               String SystemConfigurationDocumentName,
                               String SystemMetadataDocumentName,
                               String sproject) throws HammerException {
        super(false);
        setSystemConfigurationPathName(SystemConfigurationPathName);
        setSystemConfigurationDocumentName(SystemConfigurationDocumentName);
        setSystemMetadataDocumentName(SystemMetadataDocumentName);
        theStartupProjectPath = sproject;
        init(sPreferences, theGlobalInterface);
    }

    void init (String sPreferences, GlobalInterface theGlobalInterface) throws HammerException {
        this.theGlobalInterface = theGlobalInterface;
        ValidationStaticMethods.setValidationEnabled(false);

        oldErr = System.err;
        theSeparator = props.getProperty("path.separator");

        // Changing to setup class loader before configuration file so config file can be found.
        // Note: Config file must be in path before the config class paths are added.
        setupClassLoader();
        if (getSystemConfigurationPathName() != null)
            theConfigurationManager = new HammerConfigurationManager(sBaseDir, sUserHome, theClassLoader, getSystemConfigurationPathName() + getSystemConfigurationDocumentName());
        else
            theConfigurationManager = new HammerConfigurationManager(sBaseDir, sUserHome, theClassLoader, getSystemConfigurationDocumentName());

        int iProgramMode = getProgramMode();

        // guru state turns on some experimental optimizing code.
        bGuru = theConfigurationManager.checkConfigurationSetting("Guru");

        // nova state turns on extended proz file support.
        bNova = theConfigurationManager.checkConfigurationSetting("Nova");

        // OpenSource state saves/reads into/from a singe Jar that contains the Proj and compiled classes.
        bOpenSource = theConfigurationManager.checkConfigurationSetting("OpenSource");

        bUseJaninoCompiler = theConfigurationManager.checkConfigurationSetting("UseJaninoCompiler");

        if (iProgramMode == SuperDesignCockpit.JAVABUILDER)
            setTitle("Abacus Module Design Cockpit");
        else if(bOpenSource)
            setTitle("Abacus GUI Builder");
        else
            setTitle("Abacus Design Cockpit");
        theProgramMode = iProgramMode;

        if (isCustomizing() == false)
            mruList = new MruList(12, true); // create the MRU list of 12 files with automatic mnemonics



        theLogFile = new HammerLogFileAccess(this);
        theLogFile.bExtendedLogging = true;
        theLogFile.bConsoleLogging = true;

        theDataBasePath = theConfigurationManager.getConfigurationVariable("DataBasePath");
        sImageDirectory = theConfigurationManager.getConfigurationVariable("ImagePath");
        if (sImageDirectory == null)
            sImageDirectory = "";
        else {
            if ((sImageDirectory.endsWith("/") == false) && (sImageDirectory.endsWith("\\") == false))
                sImageDirectory = sImageDirectory + "/";  // find in jars.
        }

        theCustomizerLanguagePath = theConfigurationManager.getConfigurationVariable("CustomizerLanguageFiles");
        if (theCustomizerLanguagePath == null)
            theCustomizerLanguagePath = "";
        else {
            if ( (theCustomizerLanguagePath.endsWith("/") == false) )
                theCustomizerLanguagePath = theCustomizerLanguagePath + "/";
        }

        boolean bConsoleLogging = theConfigurationManager.checkConfigurationSetting("ConsoleLogging");
        boolean bLogging = false;

        if (bConsoleLogging) {
            theLogFile.setConsoleLogging(true);
            bLogging = theConfigurationManager.checkConfigurationSetting("RedirectErr");
            if (bLogging)
                System.setErr(theLogFile.theLogConsoleStream);
            bLogging = theConfigurationManager.checkConfigurationSetting("RedirectOut");
            if (bLogging)
                System.setOut(theLogFile.theLogConsoleStream);
        }

        bLogging = theConfigurationManager.checkConfigurationSetting("FileLogging");
        // Redirect err & out to file log if they are not already set to console.
        if (bLogging) {
            theLogFile.setFileLogging(true);
            if (bConsoleLogging == false) {
                bLogging = theConfigurationManager.checkConfigurationSetting("RedirectErr");
                if (bLogging)
                    System.setErr(theLogFile.theLogConsoleStream);
                bLogging = theConfigurationManager.checkConfigurationSetting("RedirectOut");
                if (bLogging)
                    System.setOut(theLogFile.theLogConsoleStream);
            }
        }


        // Extended logging are entries that are not just system.err and system.out.

        bLogging = theConfigurationManager.checkConfigurationSetting("ExtendedLogging");

        if (bLogging)
            theLogFile.setExtendedLogging(true);

        bLogging = theConfigurationManager.checkConfigurationSetting("NLSLogging");
        if (bLogging)
            theLogFile.setNLSLogging(true);

        bLogging = theConfigurationManager.checkConfigurationSetting("DedicatedLogging");
        if (bLogging)
            theLogFile.setDedicatedConsole(true);

        bLogging = theConfigurationManager.checkConfigurationSetting("DebuggingLogging");
        if (bLogging)
            theLogFile.setDebuggingLogging(true);

        bLogging = theConfigurationManager.checkConfigurationSetting("ClassLoaderLogging");
        if (bLogging)
            theLogFile.setClassLoaderLogging(true);

        bLogging = theConfigurationManager.checkConfigurationSetting("CustomizerLogging");
        if (bLogging) {
            theLogFile.setCustomizerLogging(true);
            if (isCustomizing())
                theCustomizer.setCustomizerLogging(true);
        }


// force debug to screen
//        theLogFile.setConsoleLogging(true);
//        theLogFile.setClassLoaderLogging(true);
//        theLogFile.setExtendedLogging(true);

        bLogging = theConfigurationManager.checkConfigurationSetting("CacheManagerLogging");
        if (bLogging)
            theLogFile.setCacheManagerLogging(true);

                // Handle preferences.
        if (sPreferences == null)
            thePreferences = new DesignCockpitPreferences(iProgramMode, this);
        else
            thePreferences = new DesignCockpitPreferences(iProgramMode, this, sPreferences);

        String sPlaf = theConfigurationManager.getConfigurationVariable("PLAF", "ch.abacus.lib.ui.plaf.AbacusLookAndFeel");
        try {
            new HammerLNF(this, sPlaf);
        } catch (Exception e) {
        }
        if (thePreferences.sWorkingDirectory != null)
            setCurrentDirectory(thePreferences.sWorkingDirectory);

        theConfigurationManager.loadNLSDocuments();
        metadataClasspath=this.thePreferences.getAdditionalClasspath();

        // This allows the IDE to load the JAR imported with the IDEImporter/
        // this option will ON in the OS but in Abacus DC the JAR must be included manually
        bPathClasspath = theConfigurationManager.checkConfigurationSetting("PatchClasspath");

        if(bPathClasspath)
        {
            ClassPathHacker classPathPatcher = new ClassPathHacker();
            try
            {
                classPathPatcher.addFile(metadataClasspath);
            }
            catch(Exception e)
            {
                // Let the exception go
            }
        }
        setupClassLoader();

        // Langage support...
        theLanguageManager = new LanguageManager(this);

//        if (theDataBasePath != null) {
//            dataBaseClasses = theClassLoader.getClassesFromPath(theDataBasePath);
//        }

        // if we cannot get the metadata dispenser, we cannot run.
        theMetadataDispenser = new MetadataDispenser(this, theGlobalInterface, MetaObject.DESIGN_MODE);


        SelectProjectAction actionProject = null;
        DesignProject theDesignProject = null;

            try {
                if (isCustomizing() == false) // Open empty project and load it.
                {
                    if ( theStartupProjectPath!=null )
                        theDesignProject = loadProject(theStartupProjectPath, theProjectName, this, MetaProject.UNDEFINED_INPUT_TYPE);
                    else
                        theDesignProject = loadProject((String) null, theProjectName, this, MetaProject.UNDEFINED_INPUT_TYPE);
                }
                else {// this will force a call to the Customizer to load from a Stream
                    String sName = theCustomizer.getProzName ();
                    theDesignProject = loadProject(sName, sName, this, MetaProject.UNDEFINED_INPUT_TYPE);
                    theDesignProject.theMetaProject.setProjectDirectory(theCustomizer.getProjectDirectory());
                }
            } catch (HammerException e1) {
                // let the error go through here, we deal with new project elsewhere
            }
            if (theDesignProject != null) {
                theDesignProject.setCurrentLanguage(HammerLanguagePresentation.DEFAULT);
                actionProject = new SelectProjectAction(theDesignProject, this);
                actionProject.actionPerformed(new ActionEvent(this, 0, actionProject.theDesignProject.theMetaProject.getName()));
                theDesignProject.theMetaProject.setProjectChangedState(false);
            }

        // This is how the design cockpit layout works.
        //
        // theContainer is on the outside.  It uses border layout.
        // Inside are:
        //    theMenuPanel - consisting of the menu & toolbar
        //    theDesignPanel - consisting of all the design windows.
        //    theStatusBar - Just the status bar.


        theContainer = this.getContentPane();

        // Create a panel and attach it to the top of the frame.
        // This panel is for the menubar and the toolbar.

        //#ALEX, Small UI mod
        /*
        theMenuPanel = new JAPanel(false);
        theMenuPanel.setLayout(new GridLayout(2, 1));
        */

        // Now do the same for the design panel.  Layout is NULL.
        theDesignPanel = new JAPanel(null, true);

        theComponentPalettePane = new IDEComponentPalettePane(this);
        theObjectTreeViewPane = new ObjectTreeViewPane(this);

        idePropertyInspectorController = new IDEPropertyInspectorController(this);
        JComponent propertyInspector = idePropertyInspectorController.getEmbeddedPropertyInspector();

        theViewDisplayer = new IDEViewDisplayer(this);
        thePropertyTableScrollPane = new JAScrollPane(propertyInspector);
        //#ALEX, Small UI mod
        thePropertyTableScrollPane.getViewport().setBackground(Color.WHITE);

        if(bOpenSource)
            thePropertyTableScrollPane.setBorder(BorderFactory.createMatteBorder ( 1,1,1,1, Color.GRAY  ));
        else
            thePropertyTableScrollPane.setBorder(null);

        theViewDisplayerScrollPane = new JAScrollPane(theViewDisplayer);

        //JALabel propPanelTitle = new JALabel("thePropertyTableScrollPane");

        //#ALEX, Small UI mod
        theViewDisplayerScrollPane.setBackground(Color.WHITE);
        theViewDisplayer.setBackground ( Color.WHITE );
        theViewDisplayerScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray),
                BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        //thePropertyTableScrollPane.setColumnHeaderView(propPanelTitle);

        paneOne = new JSplitPane(JSplitPane.VERTICAL_SPLIT, true,
                theObjectTreeViewPane,
                theComponentPalettePane);
        paneOne.setDividerLocation(thePreferences.getSplitColumnOne());
        //System.out.println("setDividerLoaction");

        //#ALEX, Small UI mod
        paneOne.setOneTouchExpandable(false);

        paneOne.setDividerSize(DIVIDER_SIZE);
        paneOne.setBorder(null);

        paneRight = null;
        // MHC moved split pane defs from if block


        // Create the subwindows.
        IDEMethodListModel theMethodListModel = new IDEMethodListModel();

        theSourceViewer = new IDESourceViewer(this);
        theSourceViewer.setBorder(null);
        theSourceViewer.setBackground(Color.WHITE);

        // Some interactions between windows require them to exchange object handles.
        theSourceViewer.theCodeEditor.setBorder(null);
        // Component windows will automatically resize given available space.
        // Use the whole screen by default.

        theSourceViewerScrollPane = new JAScrollPane(theSourceViewer);

        JALabel sourceLabel=new JALabel(theLanguageManager.getMessage("EventsPane.label", "Events"));
        sourceLabel.setBorder ( BorderFactory.createMatteBorder ( 0,0,1,0, Color.GRAY  ));
        JALabel methodLabel=new JALabel(theLanguageManager.getMessage("MessagesPane.label", "Messages"));
        methodLabel.setBorder ( BorderFactory.createMatteBorder ( 0,0,1,0, Color.GRAY  ));
        JALabel propertyLabel=new JALabel("Properties"); // this doesn't seem to be used!!
        propertyLabel.setBorder ( BorderFactory.createMatteBorder ( 1,0,1,0, IDETitleBar.colGroupBorder  ));
        propertyLabel.setBackground(IDETitleBar.colGroupFill);
        propertyLabel.setOpaque(true);

        //  New Panel Code
        jHeaderPanel = new JAPanel();
        jHeaderLabel = new JALabel();

        jHeaderPanel.setLayout(new GridLayout(1,2));
        jHeaderPanel.add(jHeaderLabel);
        if (iProgramMode == SuperDesignCockpit.JAVABUILDER)
        {
            IDEMethodComboModel theMethodComboModel = new IDEMethodComboModel();
            jHeaderLabel.setText("Event and Object Code");
            jHeaderComboBox = new IDEMethodComboBox(theMethodComboModel, this);
            jHeaderComboBox.setTheSourceEditor(theSourceViewer.theCodeEditor);
            jHeaderPanel.add(jHeaderComboBox);
        }
        //  End Panel Code

        //theSourceViewerScrollPane.setColumnHeaderView(methodLabel);
        theSourceViewerScrollPane.setColumnHeaderView(jHeaderPanel);
        thePropertyTableScrollPane.setColumnHeaderView(propertyLabel);

        paneTwo = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true,
                theViewDisplayerScrollPane,
                thePropertyTableScrollPane);

        paneThree = new JSplitPane(JSplitPane.VERTICAL_SPLIT, true,
                paneTwo,
                theSourceViewerScrollPane);

        paneTwo.setDividerLocation(thePreferences.getSplitColumnTwo());
        paneThree.setDividerLocation(thePreferences.getSplitColumnThree());
        // Pane left is not really used by open source
        // But we will leave it for compatability with the Abacus version.
        // Later on when scripting is added then abacus rev will be the same. Open Source.
        paneRight = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true, paneOne , paneThree);
        //#ALEX, Small UI mod
        paneTwo.setOneTouchExpandable(false);

        paneTwo.setDividerSize(DIVIDER_SIZE);
        paneTwo.setBorder(null);

        //#ALEX, Small UI mod
        paneThree.setOneTouchExpandable(false);
        paneThree.setDividerSize(DIVIDER_SIZE);
        paneThree.setBorder(null);

        //#ALEX, Small UI mod
        paneRight.setOneTouchExpandable(false);
        paneRight.setDividerSize(DIVIDER_SIZE);

        //#ALEX, Small UI mod
 //paneLeft.setOneTouchExpandable(false);
 //paneLeft.setDividerSize(DIVIDER_SIZE);
 //paneLeft.setBorder(null);

        //Actions...
        theActionManager = new IDEActionManager(this);

        // Menus...
        theMenuBar = new IDEMenuBar(this, theActionManager);

        // Toolbar
        theToolBar = new IDEToolBar(this, theActionManager);

        // Statusbar
        theStatusPanel = new IDEStatusBar(this, theLanguageManager);

        // icons use hammer image icon factory.
        HammerImageIconFactory theIconFactory = new HammerImageIconFactory(theClassLoader);

        //#MHC, Minor UI mod
        Color SpiltPanesColor = theToolBar.getBackground();
        theToolBar.setBorder(null);
        paneOne.setBackground(SpiltPanesColor);
        if (theProgramMode == SuperDesignCockpit.JAVABUILDER) {
            paneTwo.setBackground(SpiltPanesColor);
            paneThree.setBackground(SpiltPanesColor);
        }
 //       paneLeft.setBackground(SpiltPanesColor);
        paneRight.setBackground(SpiltPanesColor);

        //#ALEX, Small UI mod
        this.setIconImage(theIconFactory.getHammerImage(sImageDirectory + "glp_standard.png"));

        formatIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "glp_fmt.png");
        addIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "glp_add.png");
        codeJumperIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "glp_number.png");
        helpIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "glp_help.png");
        helperIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "glp_gear.png");
        deleteIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "glp_delete.png");
        cutIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "glp_cut.png");

        folderCubeIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "folder_cubes.png");
        CubeIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "cube_blue.png");
        componentIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "component.png");
        componentFolderIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "component.png");


        impClassNameSetIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "id_card.png");
        impMemberDataSetIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "box_white.png");
        impMethodSetIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "gear.png");
        impPropertySetIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "cube_molecule.png");
        impCodeGenSetIcon = theIconFactory.getHammerImageIcon(sImageDirectory + "text_code.png");

        if(bOpenSource==true)
            codeJumperAction = new CodeJumperAction("Line Finder", codeJumperIcon, this);

        // Now we can init the popup menu for objs.
        theViewDisplayer.initPopupMenu(this);
        theObjectTreeViewPane.initPopupMenu(this);

        // Now format the layouts.
        //#ALEX, Small UI mod
        /*
          theMenuPanel.add(menuBar);
          theMenuPanel.add(toolBar);
          getContentPane().add(theMenuPanel, BorderLayout.NORTH);
        */
        setJMenuBar(theMenuBar);
        getContentPane().add(theToolBar, BorderLayout.NORTH);
        //JAScrollPane centerPane = new JAScrollPane(paneRight);
        //centerPane.setBorder(null);
        //getContentPane().add(centerPane, BorderLayout.CENTER);
        getContentPane().add(paneRight, BorderLayout.CENTER);
        getContentPane().add(theStatusPanel, BorderLayout.SOUTH);

        // Done with layout.
        // Add the resizer.
        addComponentListener(theFramePlacement);
        addWindowStateListener(theFramePlacement);

        // Create action for this project.
        if (theDesignProject != null) {
            actionProject.actionPerformed(new ActionEvent(this, 0, actionProject.theDesignProject.theMetaProject.getName()));
            theDesignProject.theMetaProject.setProjectChangedState(false);
            // Add to the window menu.
            theMenuBar.addProjectItem(actionProject);
        }

        // set initial language...
        theToolBar.setLangauge(0);

        //sizeScreen();
        Dimension dimension = getSize();
        setComponentSizes(dimension);
        theObjectTreeViewPane.theTree.setFolderIcons();
        theComponentPalettePane.theTree.setFolderIcons();
        bInitialized = true;
        if (isCustomizing()) {
            theCustomizer.doEnumProjectMetaObjects(theDesignProject.theMetaProject);
        }


    }

    private void setupClassLoader () {
        String[] sPaths = null;
        if (theConfigurationManager != null)
            sPaths = theConfigurationManager.getConfigurationVariableSet("ClassPath");

        String sClassLoaderPath = null;
        String sShortClassPath = null;
        String sAuxiliaryPath = null;
        String sBaseClassPath = System.getProperty("java.class.path");
        String sUserHome = System.getProperty("user.home");

        if (sPaths != null) {
            for (int iAuxPath = 0; iAuxPath < sPaths.length; iAuxPath++) {
                if (iAuxPath > 0)
                    sAuxiliaryPath = sAuxiliaryPath + theSeparator + sPaths[iAuxPath];
                else
                    sAuxiliaryPath = sPaths[iAuxPath];
            }
        }
        // If an aux class path is defined in the config file use it to look for classes.
        // Long class path is always used to find files.
        sClassLoaderPath = "." + theSeparator;
        if (sUserHome != null)
            sClassLoaderPath = sClassLoaderPath + theSeparator + sUserHome;
        if (sAuxiliaryPath != null)
            sClassLoaderPath = sClassLoaderPath + theSeparator + sAuxiliaryPath;
        sShortClassPath = sClassLoaderPath;
        if (sBaseClassPath != null)
            sClassLoaderPath = sClassLoaderPath + theSeparator + sBaseClassPath;
        if(metadataClasspath!=null)
            sClassLoaderPath = sClassLoaderPath+ theSeparator +  metadataClasspath ;
        if (sAuxiliaryPath == null)
            sShortClassPath = sClassLoaderPath;
        // Set up the final paths of the class loader.
        if (theClassLoader != null)
            theClassLoader.setPaths(sClassLoaderPath, sShortClassPath);
        else
            theClassLoader = new HammerClassLoader(this, sClassLoaderPath, sShortClassPath);
        Thread.currentThread().setContextClassLoader(theClassLoader.getLoader());
    }

    public String getCurrentDirectory () {
        return sCurrentDirectory;
    }

    public void setCurrentDirectory (String sNewDirectory) {
        sCurrentDirectory = sNewDirectory;
    }

    public HammerLogFileAccess getLogFile () {
        return this.theLogFile;
    }

    public void updateStatus (int iDotPos, int iMarkPos) {
        theStatusPanel.setEditorStatus(iDotPos, 0, 0);
    }

    public Class[] getDataBaseClasses () {
        return dataBaseClasses;
    }

    public MetadataDispenser getMetadataDispenser () {
        return theMetadataDispenser;
    }

    public void addDesignProject (DesignProject theNewDesignProject) {
        // Check if it is there first.
        DesignProject testProj = this.theFirstDesignProject;
        while (testProj != null) {
            if (testProj.equals(theNewDesignProject))
                return;
            testProj = testProj.theNextDesignProject;
        }
        if (theFirstDesignProject == null) {
            theFirstDesignProject = theNewDesignProject;
        } else {
            theLastDesignProject.theNextDesignProject = theNewDesignProject;
            theNewDesignProject.thePreviousDesignProject = theLastDesignProject;
        }
        theLastDesignProject = theNewDesignProject;
    }

    public boolean setCurrentDesignProject (DesignProject theDesignProject) {
        DesignProject testDesignProject = theFirstDesignProject;
        while ((testDesignProject != null) && (testDesignProject.equals(theDesignProject) == false))
            testDesignProject = testDesignProject.theNextDesignProject;
        if (testDesignProject == null)
            return false;
        else
            theCurrentDesignProject = theDesignProject;
        this.theProjectName = theCurrentDesignProject.theMetaProject.getName();
        return true;
    }

    public boolean removeDesignProject (DesignProject theDesignProject) {
        DesignProject testDesignProject = theFirstDesignProject;
        while ((testDesignProject != null) && (testDesignProject.equals(theDesignProject) == false))
            testDesignProject = testDesignProject.theNextDesignProject;
        if (testDesignProject == null)
            return false;
        else {
            if (theDesignProject.equals(theFirstDesignProject))
                theFirstDesignProject = theDesignProject.theNextDesignProject;
            else
                theDesignProject.thePreviousDesignProject.theNextDesignProject = theDesignProject.theNextDesignProject;
            if (theDesignProject.equals(theLastDesignProject))
                theLastDesignProject = theDesignProject.thePreviousDesignProject;
            else
                theDesignProject.theNextDesignProject.thePreviousDesignProject = theDesignProject.thePreviousDesignProject;
            if (theDesignProject.equals(theCurrentDesignProject))
                setCurrentDesignProject(theLastDesignProject);
        }
        return true;
    }

    public MetaProjectHeader getProgramMetadata () throws HammerException {
        DesignProject theDesignProject = getDesignProject();
        if ((theDesignProject == null) || (theDesignProject.theMetaProject.theProgramData == null)) {
            theProjectName = getNewProjectName();
            if (theDesignProject == null) {
                MetaProject theMetaProject = new MetaProject(AbaMetaDataUser.DESIGN_MODE, theGlobalInterface, theClassLoader, getMetadataDispenser());
                theDesignProject = new DesignProject(theMetaProject);
                addDesignProject(theDesignProject);
                setCurrentDesignProject(theDesignProject);
            }
            theDesignProject.theMetaProject.theProgramData = new MetaProjectHeader(makePreferences(thePreferences));
            theDesignProject.theMetaProject.theProgramData.sProjectName =
                    theProjectName.substring(theProjectName.lastIndexOf(props.getProperty("file.separator")) + 1);
            theDesignProject.theMetaProject.theProgramData.bAbalet = true;
            theDesignProject.theMetaProject.theProgramData.sCodeGenerationDocument = getSystemConfigurationPathName() + getSystemMetadataDocumentName();
        }
        return theDesignProject.theMetaProject.theProgramData;
    }

    public void ResetCockpit () {
        if (theCurrentDesignProject != null) {
            removeDesignProject(theCurrentDesignProject);
            try {
                MetaProject theMetaProject = new MetaProject(AbaMetaDataUser.DESIGN_MODE, theGlobalInterface, theClassLoader, getMetadataDispenser());
                DesignProject theDesignProject = new DesignProject(theMetaProject);
                addDesignProject(theDesignProject);
                setCurrentDesignProject(theDesignProject);
            } catch (HammerException e1) {
                // This shouldn't be a problem.
            }
        }
    }

    public DesignProject loadProject (String sFileName, String sProjectName, SuperDesignCockpit objDesignCockpit, int iInputType) throws HammerException {
        MetaProject objMetaProject = new MetaProject(AbaMetaDataUser.DESIGN_MODE, theGlobalInterface, theClassLoader, getMetadataDispenser());
        objMetaProject.setMetaDataUser(objDesignCockpit);
        boolean bTest = false;
        String SystemDocumentPath;

        if (getSystemConfigurationPathName() != null)
            SystemDocumentPath = this.getSystemConfigurationPathName() + this.getSystemMetadataDocumentName();
        else
            SystemDocumentPath = this.getSystemMetadataDocumentName();
        if (SystemDocumentPath == null)
            SystemDocumentPath = "metadata.meta";
        if (this.isbMetadataDirty()==true)
        {
            // Reset the metadata
            objMetaProject.resetMetadata();
        }

        bTest = objMetaProject.loadMeta(SystemDocumentPath);

        if(bTest)
        {
            String repositoryPath = null;
            repositoryPath = this.thePreferences.getRepositPath();
            if(repositoryPath==null)
              repositoryPath = this.theConfigurationManager.getConfigurationVariable("RepositoryPath");
            else
            {
              repositoryPath = repositoryPath + ";" + this.theConfigurationManager.getConfigurationVariable("RepositoryPath");
            }

            if(repositoryPath!=null && repositoryPath.length()>0)
              objMetaProject.loadCustomMeta(SystemDocumentPath,repositoryPath);
            else // If not custom metadata to load make it signals it loaded....
             theMetadataDispenser.theMetadataDocument.setCustomMetadataComplete(true);
        }
        if (bTest) {
            if (isCustomizing() == false) {
                if (objMetaProject.getMetadataDispenser().theMetadataDocument.mode == HammerInputStream.FROM_FILE)
                    setCanSaveMetadata(true);
                else
                    setCanSaveMetadata(false);
            } else
                setCanSaveMetadata(false);

            if (sFileName != null) {  // Not "NEW" option.  Need to load.  NOTE: this was theProjectName, but changed for Customizer's usage
                objMetaProject.setInputType(iInputType);

                if (isCustomizing() == false) {
                    bTest = objMetaProject.load(sFileName);
                    mruList.fileOpened(sFileName); // we must inform the MRU that a file has been opened, so it can remove it from the menu
                } else {
                    InputStream is = theCustomizer.getLoadProjectIntputStream();
                    if (is != null) {
                        boolean bCustomizerProjectLoaded = objMetaProject.loadResource(theCustomizer.getProzName (), is, true);
                        theCustomizer.projectLoaded(objMetaProject, bCustomizerProjectLoaded);
                    }
                }
                if (theSourceViewer != null) {
                    if (bTest == true)
                        theSourceViewer.theMessagesEditor.setText("Project Loaded!\n");
                    else
                        theSourceViewer.theMessagesEditor.setText("Project Load Failed\n");
                }
            } else {
                objMetaProject.setInputType(MetaProject.FROM_XML_DOCUMENT);
                if (theSourceViewer != null)
                    theSourceViewer.theMessagesEditor.setText("New Project\n");
            }
        }
        if (objMetaProject != null) {
            if (objMetaProject.theProgramData == null) {
                objMetaProject.theProgramData = new MetaProjectHeader(makePreferences(thePreferences));
                // copy the author to the project header, if one is set...
                if (objMetaProject.sAuthor != "") // copy the author to the project header, if one is set...
                    objMetaProject.theProgramData.sAuthor = objMetaProject.sAuthor;  // SWB
            }
            theProjectName = objMetaProject.sName;
            if ((theProjectName == null) || (theProjectName.trim().length() == 0)) {
                objMetaProject.sName = getNewProjectName();
                theProjectName = getNewProjectName();
            }
            objMetaProject.getNLS().Load();
            DesignProject theDesignProject = new DesignProject(objMetaProject);

            return theDesignProject;
        }
        return null;
    }

    public void setCanSaveMetadata (boolean b) {
        bCanSaveMetadata = b;

        // Enable the associated menu item accordingly...
        if (theActionManager != null && theActionManager.getSaveMetadataAction() != null)
            theActionManager.getSaveMetadataAction().setEnabled(b);
    }

    public boolean isCanSaveMetadata() {
        return bCanSaveMetadata;
    }

    DesignProject loadProject (HammerJarAccess theJarAccess, String sProjectName, SuperDesignCockpit objDesignCockpit, int iInputType) throws HammerException {
        MetaProject objMetaProject = new MetaProject(AbaMetaDataUser.DESIGN_MODE, theGlobalInterface, theClassLoader, getMetadataDispenser());
        objMetaProject.setMetaDataUser(objDesignCockpit);
        boolean bTest = false;
        String SystemDocumentPath = this.getSystemConfigurationPathName() + this.getSystemMetadataDocumentName();
        if (SystemDocumentPath == null)
            SystemDocumentPath = "metadata.meta";
        bTest = objMetaProject.loadMeta(SystemDocumentPath);

        if (bTest) {
            if (objMetaProject.getMetadataDispenser().theMetadataDocument.mode == HammerInputStream.FROM_FILE)
                setCanSaveMetadata(true);
            else
                setCanSaveMetadata(false);
            if (theProjectName != null) {  // Not "NEW" option.  Need to load.
                objMetaProject.setInputType(iInputType);
                bTest = objMetaProject.load(theJarAccess);
            }
        } else
            throw new HammerException(HammerException.NO_METADATA_AVAILABLE, "LoadProject cannot load metadata.meta");
        if (objMetaProject != null) {
            if (objMetaProject.theProgramData == null) {
                objMetaProject.theProgramData = new MetaProjectHeader(makePreferences(thePreferences));
                // copy the author to the project header, if one is set...
                if (objMetaProject.sAuthor != "")
                    objMetaProject.theProgramData.sAuthor = objMetaProject.sAuthor;  // SWB
            }
            theProjectName = objMetaProject.sName;
            if ((theProjectName == null) || (theProjectName.trim().length() == 0)) {
                objMetaProject.sName = getNewProjectName();
                theProjectName = getNewProjectName();
            }
            objMetaProject.getNLS().Load();
            DesignProject objDesignProject = new DesignProject(objMetaProject);
            return objDesignProject;
        }
        return null;
    }

    protected void FrameSelection (MetaObject theObject, boolean bResetViewDisplayer) {
        if (theViewDisplayer == null) // this can happen when Customizing, as there is no initial blank project
            return;

        theCurrentDesignProject.setSelectedContainer(theObject);
        if (bResetViewDisplayer) {
            if ((theObject != null) && (theObject.isAbalet() || theObject.isFrame())) {
                theViewDisplayer.removeAll();
                theFrameSizeboxes = null;
            }
            if (theObject != null) {
                theObject.iMode = MetaObject.DESIGN_MODE;
                if (theObject.theVisualObject == null)
                    theObject.create();
                    //theObject.generateVisualProperties();
                // walk up to the first frame or tabbed pane.
                    //theObject = theObject.getViewDisplayerContainer(false);
                if ((theObject.isAbalet()) || (theObject.isFrame())) {
                    theViewDisplayer.setLayout(null);  // Always null in design mode.
                    theObject.setLocation(0, 0);
                    if (theObject.theVisualObject instanceof DesignPanel) {  // glue design panels
                        DesignPanel theDesignPanel = (DesignPanel) theObject.theVisualObject;
                        theDesignPanel.theDesignCockpit = this;
                        theDesignPanel.theMetaObject = theObject;
                    }
                    if (theObject.theVisualObject instanceof DesignSplitPane) {
                        DesignSplitPane theDesignSplitter = (DesignSplitPane) theObject.theVisualObject;
                        theDesignSplitter.theDesignCockpit = this;
                        theDesignSplitter.theMetaObject = theObject;
                    }

                    theObject.theMouseListener = new IDEViewDisplayerComponentMouseListener(theObject, theObject, this, theObject.theVisualObject);
                    theObject.theVisualObject.addMouseListener((IDEViewDisplayerComponentMouseListener) theObject.theMouseListener);

                    theViewDisplayer.add(theObject.theVisualObject);
                }
                if (theObject.theVisualObject instanceof DesignTabbedPane) {
                    DesignTabbedPane thePane = (DesignTabbedPane) theObject.theVisualObject;
                    thePane.theDesignCockpit = this;
                    thePane.theMetaObject = theObject;
                }
                theViewDisplayer.addObjects(theObject);
            }
        }
        // Select the frame of the view displayer.
        theCurrentDesignProject.setSelectedFrame(theObject);
        if ((theObject != null) && (theObject.isAbalet() || theObject.isFrame()))
            theFrameSizeboxes = new Sizeboxes(theObject, thePreferences.iSizeBoxWidth, thePreferences.iSizeBoxHeight, this);
        if (theViewDisplayer != null)
            theViewDisplayer.updateUI();
    }

    protected void SelectContainer (MetaObject theObject, boolean bResetFrame) {
        // Check if container is already selected.
        if (theCurrentDesignProject == null)
            return;
        MetaObject theSelectedContainer = theCurrentDesignProject.getSelectedContainer();
        if (theObject != null) {
            if (theObject.equals(theSelectedContainer))
                return;
            // Select the frame or tabbed pane that the view displayer will display.
            if (theObject.isAbalet() || theObject.isFrame())
                FrameSelection(theObject, bResetFrame);
        }
    }


//  protected void SelectContainer(MetaObject theObject, boolean bResetFrame) {
//      // Check if container is already selected.
//      if ((theObject != null) && (theObject==theCurrentDesignProject.getSelectedContainer()))
//          return;
//      // Select the frame or tabbed pane that the view displayer will display.
//      if ((theObject!=null) && ((theObject.isAbalet()) || (theObject.isFrame())))
////      if (theObject!=null) //&& ((theObject.isAbalet()) || (theObject.isFrame())))
//          FrameSelection(theObject, bResetFrame);
////      if (theObject.theVisualObject != null)
////          theObject.theVisualObject.transferFocus();
//  }

    protected void SelectContainer (MetaObject theObject) {
        SelectContainer(theObject, true);
    }

    protected void setSelectedObject (MetaObject theObject) {
        theCurrentDesignProject.setLastObjectSelected(theObject);
        theCurrentDesignProject.setSelectedObject(theObject);
    }

    public MetaObject getSelectedObject () {
        if (theCurrentDesignProject == null)
            return null;
        return theCurrentDesignProject.getSelectedObject();
    }

    public MetaObject getSelectedFrame () {
        if (theCurrentDesignProject == null)
            return null;
//      return (theCurrentDesignProject.theSelectedFrame!=null) ?
//            theCurrentDesignProject.theSelectedFrame : theCurrentDesignProject.theTopObject;
        return theCurrentDesignProject.getSelectedFrame();
    }

    public MetaObject getSelectedContainer () {
        if (theCurrentDesignProject == null)
            return null;
        return (theCurrentDesignProject.getSelectedContainer() != null) ?
                theCurrentDesignProject.getSelectedContainer() :
                theCurrentDesignProject.getFirstObject();
    }

    public void deselectObject (MetaObject theObject) {
        theSizeboxes.kill(theObject);
        theCurrentDesignProject.deselectObject(theObject);
    }

    public void deselectObjects () {
        theSizeboxes.kill();
        theCurrentDesignProject.deselectObjects();
    }

    HashMap makePreferences (DesignCockpitPreferences prefs) {
        HashMap thePreferences = new HashMap(5);
        thePreferences.put("Author", prefs.sAuthor);
        thePreferences.put("LNF", prefs.sLookAndFeelName);
        thePreferences.put("MetadataDocument", prefs.sCodeGenerationDocument);
        thePreferences.put("Workspace", prefs.sWorkingDirectory);
        thePreferences.put("Transient", prefs.sTransientDirectory);
        return thePreferences;
    }

    public void SetDesignProject (DesignProject objDesignProject) {
        if (objDesignProject.equals(theCurrentDesignProject) == false) {
            addDesignProject(objDesignProject);
            setCurrentDesignProject(objDesignProject);
        }
        SetupDisplay(objDesignProject);
    }

    protected void SelectObject (MetaObject theObject, boolean bMultiSelect) {
        if ((theCurrentDesignProject.getSelectedObject() != null) &&
                (theCurrentDesignProject.getSelectedObject().equals(theObject)))
            return;

        if (idePropertyInspectorController != null)
            idePropertyInspectorController.editingCanceled();

        if (bMultiSelect == false)
            theCurrentDesignProject.deselectObjects();

        // Sizeboxes need to be attached before object is brought forward.
        if ((theSizeboxes != null) && (bMultiSelect == false)) {
            MetaObject lastObject = getDesignProject().getSelectedObject();
            if (lastObject != null)
                theSizeboxes.kill(lastObject);
        }
        if ((theObject != null) && (theObject.theVisualObject != null)) {
            if (theObject.isAbalet() || theObject.isFrame()) {
                if (theFrameSizeboxes == null)
                    theFrameSizeboxes = new Sizeboxes(theObject, thePreferences.iSizeBoxWidth, thePreferences.iSizeBoxHeight, this);
            } else {
                if ((theObject.theParentObject != null) && (theObject.theParentObject.isScrollPane()))
                    theObject = theObject.theParentObject;
                if (!theObject.isHorzSplit() && !theObject.isVertSplit()) {
                    if (theObject.isTabPage())
                        theSizeboxes.add(theObject.theParentObject, thePreferences.iSizeBoxWidth, thePreferences.iSizeBoxHeight, this);
                    else
                        theSizeboxes.add(theObject, thePreferences.iSizeBoxWidth, thePreferences.iSizeBoxHeight, this);
                }
            }
        }

        // bring the object forward.
        setSelectedObject(theObject);
        if (theStatusPanel != null)
            theStatusPanel.setSelectedObject(theObject);
        if (theObject == null) {
            if (idePropertyInspectorController != null)
                idePropertyInspectorController.resetContents();
            if (theSizeboxes != null)
                theSizeboxes.kill();  // remove all
            return;
        }
        // Find the design object in the objecttreeview.
        ObjectTreeViewNode thePlaceToSelect = theObject.getTreeNode();
        // Select the object in the treeview.
        if (thePlaceToSelect != null) {
            TreePath testPath = theObjectTreeViewPane.theTree.getSelectionPath();
            TreePath path = new TreePath(thePlaceToSelect.getPath());
            if ((testPath == null) || (!testPath.equals(path))) {
                theObjectTreeViewPane.theTree.scrollPathToVisible(path);
                theObjectTreeViewPane.theTree.expandPath(path);
                theObjectTreeViewPane.theTree.setSelectionPath(path);
            }
        }

        // Select the object in the view displayer.
        // Reset the property list.
        // Reset the method list.

        if (idePropertyInspectorController == null) return;
        MetaClass theMetaClass = getDesignProject().findClass(theCurrentDesignProject.getSelectedObject().theClass.getMetadata().sClassName);
        if (theMetaClass != null) {
            if (theProgramMode == SuperDesignCockpit.JAVABUILDER)
            {
                jHeaderComboBox.Load(theMetaClass);
            }
            getPropertyInspectorController().refreshPropertyInspector();
        }
    }

    protected void ResetDisplay () {
        if (theComponentPalettePane != null)
            theComponentPalettePane.resetContents();
        if (theObjectTreeViewPane != null)
            theObjectTreeViewPane.clear();
        if (theViewDisplayer != null)
            theViewDisplayer.resetContents();
        if (idePropertyInspectorController != null)
            idePropertyInspectorController.resetContents();
        if (theProgramMode == SuperDesignCockpit.JAVABUILDER) {
            if (theSourceViewer != null)
                theSourceViewer.setCodeText("");
        }
    }

    protected boolean SetupDisplay (DesignProject theProject) {
        // Fill the control palette with options.
        try {
            getDesignProject().theMetaProject.theProgramData = getProgramMetadata();
        } catch (HammerException e1) {
            return false;
        }
        if (theStatusPanel != null)
            theStatusPanel.setProjectStatus(theProject.theMetaProject.sName);
        if (theComponentPalettePane != null) {
            theComponentPalettePane.resetContents();
            boolean bTest = theComponentPalettePane.load(theProject.theMetaProject.getFirstClass(), null);
            if (bTest == true) {
                if (isCustomizing() == false) {
                    // open the first two branches to see the component groups...
                    theComponentPalettePane.theTree.expandRow(0);
                    theComponentPalettePane.theTree.expandRow(1);
                }

                // Fill the object tree with all objects.  The main object is always present.
                if (theProject.getFirstObject() != null) {
                    bTest = theObjectTreeViewPane.load(theProject.getFirstObject(), null);
                    if (bTest == true) {
                        // Select the last selected object (or the main object if none selected)
                        MetaObject theLastSelectedObject = theProject.getLastObjectSelected();
                        if (theLastSelectedObject == null)
                            theLastSelectedObject = theProject.getFirstObject();
                        // Make sure there is an object to access.
                        if (theLastSelectedObject == null)
                            theLastSelectedObject = theProject.getFirstObject();
                    }
                }
            }
            return bTest;
        }
        return false;
    }


    public void editorAction (String theActionName, ActionEvent evt) {

        Object theActiveEditor = theSourceViewer.getActiveEditor();
        Class clsActiveEditor = theActiveEditor.getClass();
        Class[] clsParams = new Class[1];
        clsParams[0] = (new String()).getClass();
        try {
            Method m = clsActiveEditor.getMethod("getActionByName", clsParams);
            Object[] objParams = new Object[1];
            objParams[0] = theActionName;
            Object obj = m.invoke(theActiveEditor, objParams);
            if ((obj != null) && (obj instanceof Action)) {
                Action action = (Action) obj;
                action.actionPerformed(evt);
            }
        } catch (InvocationTargetException e1) {
            System.out.println("Invocation error");
        } catch (NoSuchMethodException e2) {
            System.out.println("No such method error");
        } catch (IllegalAccessException e3) {
            System.out.println("Illegal Access error");
        }
    }

    class CodeJumperAction extends AbstractAction {
        SuperDesignCockpit theDesignCockpit = null;

        public CodeJumperAction (String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed (ActionEvent evt) {
            new CodeJumperTester(theDesignCockpit);
        }
    }

    boolean SaveProject (boolean bCompileClass) {
        IDEProgressIndicator progressIndicator = null;
        MetaProjectHeader theProgram = null;
        try {
            theProgram = getProgramMetadata();
        } catch (HammerException e1) {
            return false;
        }

        String oldProjectName = theProjectName;
        String sSeparator = props.getProperty("file.separator");
        if ((getDesignProject() == null) || (getDesignProject().getFirstObject() == null))
            return false;
        theProgram.theMainObject = getDesignProject().getFirstObject();
        // Name the mainclass.
        theProgram.sMainClass = "";
        // Make sure we have a filename.
        String sDirectoryName = getCurrentDirectory();
        if (isCustomizing()) theProjectName = theCustomizer.getProzName ();
        if ((theProjectName == null) || (theProjectName.startsWith("New Project"))) {
            JFileChooser theFileChooser = new JFileChooser(getCurrentDirectory());
            theFileChooser.addChoosableFileFilter(new ProjFileFilter(this));
            theFileChooser.setFileView(new ProjFileView(this));
            int iOptionSelected = theFileChooser.showSaveDialog(getContentPane());
            if (iOptionSelected == JFileChooser.APPROVE_OPTION) {
                File file = theFileChooser.getSelectedFile();
                try {
                    String sFullPath = file.getCanonicalPath();
                    int iSeparator = sFullPath.lastIndexOf(sSeparator);
                    if (iSeparator != -1) {
                        sDirectoryName = sFullPath.substring(0, iSeparator + 1);
                        setCurrentDirectory(sDirectoryName);
                        getDesignProject().setProjectDirectory(sDirectoryName);
                    }
                    theProjectName = file.getName();
                    if(theProjectName.lastIndexOf(".")==-1) // 20040615, acg, Append ext if none exists.
                    {
                        if(bOpenSource)
                            theProjectName = theProjectName + ".proj";
                        else
                            theProjectName = theProjectName + ".proz";
                    }
                    theStatusPanel.setProjectStatus(theProjectName);
                    // Set the input type to be an xml document since we are not saving into a jar.
                    getDesignProject().setInputType(MetaProject.FROM_XML_DOCUMENT);
                } catch (java.io.IOException e1) {
                }
            } else {
                if (theSourceViewer != null) {
                    theSourceViewer.showMessageEditor();
                    theSourceViewer.theMessagesEditor.append("Save Canceled.");
                }
                return false;
            }
        } else
            sDirectoryName = getDesignProject().getProjectDirectory();

        if (theSourceViewer != null) {
            theSourceViewer.showMessageEditor();
            theSourceViewer.setMessagesText("Saving. Please Wait...\n");
            theSourceViewer.update(); //paintImmediately(0, 0, theSourceViewer.getWidth(), theSourceViewer.getWidth());
        } else {
            progressIndicator = new IDEProgressIndicator(this, "Save Project");
            progressIndicator.displayMessage("Saving. Please Wait...");
            progressIndicator.show(null);
        }

        // Save nls documents.
        getDesignProject().theMetaProject.getNLS().writeAllChangedNlsDocuments();
        // Create the document generator.
        String sProjectName =
                theProjectName.substring(theProjectName.lastIndexOf(props.getProperty("file.separator")) + 1);
        // Replace window menu with correct name.
        Component[] theProjectWindowMenuItems = theMenuBar.getWindowMenu().getMenuComponents();
        for (int i = 0; i < theProjectWindowMenuItems.length; i++) {
            if (theProjectWindowMenuItems[i] instanceof JMenuItem) {
                JMenuItem theMenuItem = (JMenuItem) theProjectWindowMenuItems[i];
                if (theMenuItem.getText().equals(oldProjectName)) {
                    theMenuItem.setText(sProjectName);
                    break;
                }
            }
        }

        getDesignProject().theMetaProject.sName = sProjectName;
        getDesignProject().theMetaProject.theProgramData.sWorkspace = sDirectoryName;
        ProjectDocument theDocumentGenerator = new ProjectDocument(this, sDirectoryName + sSeparator +
                sProjectName, getDesignProject().theMetaProject);
        // 2005/07/27, acg, Add any new class paths added through Importer, etc.
        String sNewPath = thePreferences.getAdditionalClasspath();
        String sOldpath = getDesignProject().theMetaProject.theProgramData.getClassPath();
        if ( sNewPath!=null && (sOldpath==null || sOldpath.toLowerCase().indexOf(sNewPath.toLowerCase())==-1) )
            getDesignProject().theMetaProject.theProgramData.AddClassPath(sNewPath);

        // Generate the output document.
        try {
            boolean bSavedOk = theDocumentGenerator.save(theProgram, bCompileClass);
            if (theSourceViewer != null) {
                if (bSavedOk == true)
                    theSourceViewer.theMessagesEditor.append("Program Saved!\n");
                else
                    theSourceViewer.theMessagesEditor.append("Program Save Failed\n");
            } else { // need to use messageboxes...
                if (bSavedOk == false) { // there was an error, so display the message in a message box...
                    progressIndicator.hide();
                    JOptionPane pane = new JOptionPane("Program Save Failed", JOptionPane.ERROR_MESSAGE);
                    JDialog theDialog = pane.createDialog(this, "Error Saving");
                    theDialog.show();
                    return false;
                }
            }

            setTitle("Abacus Design Cockpit - " + sProjectName);
        } catch (HammerException e0) {
            ExceptionWriter writerTemp = new ExceptionWriter(this);
            PrintWriter pwTemp = new PrintWriter(writerTemp);
            pwTemp.println("Hammer Exception: " + e0.getMessage());
            e0.printStackTrace(pwTemp);
            if (theSourceViewer != null)
                theSourceViewer.setMessagesText(writerTemp.getBuffer());
            else {
                JOptionPane pane = new JOptionPane(writerTemp.getBuffer(), JOptionPane.INFORMATION_MESSAGE);
                JDialog theDialog = pane.createDialog(theContainer, "Action Taken");
                theDialog.show();
            }
        } catch (Exception e1) {
            ExceptionWriter writerTemp = new ExceptionWriter(this);
            PrintWriter pwTemp = new PrintWriter(writerTemp);
            e1.printStackTrace(pwTemp);
            if (theSourceViewer != null)
                theSourceViewer.setMessagesText(writerTemp.getBuffer());
            else {
                JOptionPane pane = new JOptionPane(writerTemp.getBuffer(), JOptionPane.INFORMATION_MESSAGE);
                JDialog theDialog = pane.createDialog(theContainer, "Action Taken");
                theDialog.show();
            }
        } catch (Throwable e2) {
            ExceptionWriter writerTemp = new ExceptionWriter(this);
            PrintWriter pwTemp = new PrintWriter(writerTemp);
            e2.printStackTrace(pwTemp);
            if (theSourceViewer != null)
                theSourceViewer.setMessagesText(writerTemp.getBuffer());
            else {
                DisplayMessage displayMessage = new DisplayMessage(this, "Error During Save");
                displayMessage.showMessage(writerTemp.getBuffer());
            }

        }
        // The errors can be found using the code jumper.
//        if (theSourceViewer != null)
//            theSourceViewer.showMessageEditor();
        if (theSourceViewer == null)
            progressIndicator.hide();
        return true;
    }

    // Implement AbaMetaDataUser interface.

    public int getMode () {
        return AbaMetaDataUser.DESIGN_MODE;
    }

    public void setMode (int iMode) {
        // do nothing.
    }

    public HammerFileManager getFileManager () {
        return this.theFileManager;
    }

    public void setFileManager (HammerFileManager theFileManager) {
        this.theFileManager = theFileManager;
    }

    public HammerConfigurationManager getConfigurationManager () {
        return this.theConfigurationManager;
    }

    public void setConfigurationManager (HammerConfigurationManager theConfigurationManager) {
        this.theConfigurationManager = theConfigurationManager;
    }

    public HammerClassLoader getClassLoader () {
        return this.theClassLoader;
    }

    public void setClassLoader (HammerClassLoader theClassLoader) {
        this.theClassLoader = theClassLoader;
    }

    public Properties getProps () {
        return props;
    }

    public String getUserHome () {
        return this.sUserHome;
    }

    public String getBaseDir () {
        return this.sBaseDir;
    }

    public int getVersionNumber () {
        return iVersionNumber;
    }

    public int getRevisionNumber () {
        return iRevisionNumber;
    }

    public int getSubRevisionNumber () {
        return iSubRevisionNumber;
    }

    public int getBuildNumber () {
        return iBuildNumber;
    }

    public MetaObject Pasting (MetaObject theTargetObject, MetaObject thePastedObject, MetaProject theDesignProject, boolean bPreserveObjectNames) {
        // Fix up name if necessary - not to match another object.
        getDesignProject().theMetaProject.setProjectChangedState(true);
        String sObjectName = thePastedObject.getName();
        if (theTargetObject.theDesignProject.findObject(sObjectName) != null) {
            sObjectName = theDesignProject.getNewObjectName(thePastedObject.theClass.getMetadata().sClassName);
            //thePastedObject.setPropertyValue("Text", 0, 0, sObjectName, true);
        }
        thePastedObject.setName(sObjectName);
        MetaObject theNewObject = thePastedObject.Clone(new MetaCloneMode(MetaCloneMode.shallowCopyWithCode), null, bPreserveObjectNames);
        if (theNewObject != null) {
            // Set the property values and all metadata to the current project (allows copies to and from projects)
            // Assigns this project to the property values of the object.
            theNewObject.attachToProject(getDesignProject().theMetaProject);
            theTargetObject.addObject(theNewObject);  // object is added here.
            boolean bCreated = theNewObject.create();
            if (bCreated) {
                // Tell the ObjectTreeView to add it.
                boolean bTest = theViewDisplayer.testObject(theNewObject);
                if (bTest == true) {
                    // Add object to tree view pane.
                    theObjectTreeViewPane.addObjects(theNewObject);
                    // Show objects on view displayer
                    theViewDisplayer.displayObjects(theNewObject);
                    return theNewObject;
                } else {
                    theNewObject.DeleteObject(theDesignProject, this);
                    return null;
                }
            }
        }
        return null;
    }

    // Paste the object as a child of this object.
    public MetaObject PasteChildObject (MetaObject theTargetObject, MetaObject thePastedObject, MetaProject theDesignProject, boolean bPreserveObjectNames) {
        MetaObject theNewObject = Pasting(theTargetObject, thePastedObject, theDesignProject, bPreserveObjectNames);

        thePastedObject = thePastedObject.getFirstChild();
        while ((theNewObject != null) && (thePastedObject != null)) {
            if (PasteChildObject(theNewObject, thePastedObject, theDesignProject, bPreserveObjectNames) == null)
                return null;
            thePastedObject = thePastedObject.getNextObject();
        }
        return theNewObject;
    }

    public MetaObject PasteObject (MetaObject theTargetObject, MetaObject thePastedObject, MetaProject theDesignProject,
                                   Integer X, Integer Y, Integer Actual_X, Integer Actual_Y, int iClipboardElement,
                                   boolean bPreserveObjectNames) {
        MetaObject theNewObject = PasteChildObject(theTargetObject, thePastedObject, theTargetObject.theDesignProject, bPreserveObjectNames);
        if (theNewObject != null) {
            Point ptLocation = theClipboardController.getOriginClipboardObject(theTargetObject, iClipboardElement,
                    new Point(X.intValue(), Y.intValue()), new Point(Actual_X.intValue(), Actual_Y.intValue()));
            Dimension dimSize = theNewObject.getSize();
            resizeAction(theNewObject, ptLocation.x, ptLocation.y, dimSize.width, dimSize.height, MetaObject.RESIZE_CONTEXT_FROM_PASTE, true, true);
            theNewObject.doProperties();
            return theNewObject;
        } else
            return null;
    }

    public MetaObject PasteObject (MetaObject theTargetObject, MetaObject thePastedObject, MetaProject theDesignProject, boolean bPreserveObjectNames) {
        MetaObject theNewObject = PasteChildObject(theTargetObject, thePastedObject, theTargetObject.theDesignProject, bPreserveObjectNames);
        if (theNewObject != null) {
            SelectObject(theNewObject, false);
            theNewObject.doProperties();
            return theNewObject;
        } else
            return null;
    }

    void doDragging (MetaObject theMetaObject,
                     JComponent comp, Point ptViewDisplayerOrigin, Point ptObjectOrigin,
                     Point ptInObject, int left, int top) {

        Point ptObjectLocation = comp.getLocation();
        theMetaObject.theDesignProject.setProjectChangedState(true);

        int iGridX = thePreferences.iViewDisplayerGridX;
        int iGridY = thePreferences.iViewDisplayerGridY;
        // Ok, now move it over the grid.
        theMetaObject.iXLocation = (int) ptObjectLocation.getX() + left;
        theMetaObject.iYLocation = (int) ptObjectLocation.getY() + top;
        if (comp.equals(theMetaObject.theVisualObject)) {
            if (thePreferences.bSnapToGrid) { // Normalize using alignment settings of View Displayer
                if (iGridX != 0) {
                    int iXMargin = theMetaObject.iXLocation % iGridX;
                    int iXFactor = theMetaObject.iXLocation / iGridX;
                    if (iXMargin < iGridX / 2)
                        theMetaObject.iXLocation = iXFactor * iGridX;
                    else
                        theMetaObject.iXLocation = (iXFactor + 1) * iGridX;
                }
                if (iGridY != 0) {
                    int iYMargin = theMetaObject.iYLocation % iGridY;
                    int iYFactor = theMetaObject.iYLocation / iGridY;
                    if (iYMargin < iGridY / 2)
                        theMetaObject.iYLocation = iYFactor * iGridY;
                    else
                        theMetaObject.iYLocation = (iYFactor + 1) * iGridY;
                }
            }
//          theDesignCockpit.theLogFile.doLogEntry("MetaObject", "In Dragging: " + theName + "Grid xy:(" + iGridX+"," + iGridY+") X="+iXLocation+", Y="+iYLocation);
            // Set location.
            theMetaObject.setPropertyValue("Location.Left", 0, 0, theMetaObject.iXLocation, true);
            theMetaObject.setPropertyValue("Location.Top", 0, 1, theMetaObject.iYLocation, true);
            if (theMetaObject.isScrollPane()) {
                if (theMetaObject.theFirstChild != null) {
                    theMetaObject.theFirstChild.setPropertyValue("Location.Left", 0, 0, 0, true);
                    theMetaObject.theFirstChild.setPropertyValue("Location.Top", 0, 1, 0, true);
                    theMetaObject.theFirstChild.setPropertyValue("Size.Width", 0, 0, theMetaObject.getPropertyValue("Size.Width", 0), true);
                    theMetaObject.theFirstChild.setPropertyValue("Size.Height", 0, 1, theMetaObject.getPropertyValue("Size.Height", 0), true);
                    theMetaObject.theFirstChild.theVisualObject.setLocation(theMetaObject.iXLocation, theMetaObject.iYLocation);
                    theMetaObject.theFirstChild.theVisualObject.setSize(theMetaObject.dimSize);
                }
            }

            if ((theMetaObject.theParentObject.theClass.getMetadata().containerType.getContainerType() == MetaContainerType.CONTAINER_SCROLLPANE) ||
                    (theMetaObject.theParentObject.theClass.getMetadata().containerType.getContainerType() == MetaContainerType.CONTAINER_TABBEDPANE)) {
                theMetaObject.theVisualObject.setLocation(0, 0);
                theMetaObject.dimSize = theMetaObject.theParentObject.theVisualObject.getSize();
                theMetaObject.theParentObject.theVisualObject.setLocation(theMetaObject.iXLocation, theMetaObject.iYLocation);
                theSizeboxes.relocate(theMetaObject, theMetaObject.theParentObject.iXLocation,
                        theMetaObject.theParentObject.iYLocation,
                        (int) theMetaObject.dimSize.getWidth(),
                        (int) theMetaObject.dimSize.getHeight(), false);
            } else {
                if ((!theMetaObject.isAbalet()) && (!theMetaObject.isFrame()))
                    theMetaObject.theVisualObject.setLocation(theMetaObject.iXLocation, theMetaObject.iYLocation);
                if ((theMetaObject.isAbalet() != true) && (theMetaObject.isFrame() != true))
                    theSizeboxes.update(theMetaObject, theMetaObject.iXLocation, theMetaObject.iYLocation,
                            (int) theMetaObject.dimSize.getWidth(), (int) theMetaObject.dimSize.getHeight());
            }
            getPropertyInspectorController().refreshPropertyInspector();
        }
//      bAnchoringOff = false;
    }

    void dragAction (MetaObject theMetaObject, MouseEvent evt, Point ptViewDisplayerOrigin, Point ptObjectOrigin, Point ptInObject) {
        if ((ptInObject == null) || (theMetaObject.ptDrag == null) || (ptViewDisplayerOrigin == null))
            return;
        JComponent comp = (JComponent) evt.getSource();
        int left = (int) (ptInObject.getX() - theMetaObject.ptDrag.getX());
        int top = (int) (ptInObject.getY() - theMetaObject.ptDrag.getY());
        if (comp.equals(theMetaObject.theVisualObject) || theMetaObject.isCompositeComponent() ) {
            // Tab page needs to redirect drag to tabbed pane
            // Make sure that tabbed panes always move if the tab page gets the drag.
            if (theMetaObject.isTabPage() || (theMetaObject.theParentObject.theClass.getMetadata().containerType.getContainerType() == MetaContainerType.CONTAINER_SCROLLPANE)) {
                theMetaObject.theParentObject.ptDrag = theMetaObject.ptDrag;
                doDragging(theMetaObject.theParentObject, theMetaObject.theParentObject.theVisualObject, ptViewDisplayerOrigin, ptObjectOrigin,
                        ptInObject, left, top);
                theMetaObject.setPropertyValue("Location.Left", 0, 0, 0, true);
                theMetaObject.setPropertyValue("Location.Top", 0, 1, 0, true);
                theMetaObject.theVisualObject.setLocation(0, 0);
            } else {
                getDesignProject().dragSelected(theMetaObject, ptViewDisplayerOrigin,
                        ptObjectOrigin, ptInObject, left, top);
            }
        }
    }

    void setBounds (MetaObject theMetaObject, int x, int y, int cx, int cy) {
        resizeAction(theMetaObject, x, y, cx, cy, MetaObject.RESIZE_CONTEXT_FROM_LAYOUT, true, true);
    }
    // microsize microloc loadtbl


    void resizeAction (MetaObject theMetaObject, int iNewXLocation, int iNewYLocation,
                       int iNewXSize, int iNewYSize, int resizeContext,
                       boolean bResizeHorizontal, boolean bResizeVertical) {
//                      boolean bGrid, boolean bSizeboxResize,
//                      boolean bLoadPropertyTable) {
//        boolean bGrid = false;
//        boolean bSizeboxResize = false;
        boolean bLoadPropertyTable = false;

        if (thePreferences.bSnapToGrid) {
            int iLocationGridX = thePreferences.iViewDisplayerGridX;
            int iLocationGridY = thePreferences.iViewDisplayerGridY;
            int iSizeGridX = thePreferences.iViewDisplayerGridX;
            int iSizeGridY = thePreferences.iViewDisplayerGridY;
            // Only size microadjust allows location to be not on grid.
            if ((resizeContext == MetaObject.RESIZE_CONTEXT_SIZEBOX_RESIZED) ||
                    (resizeContext == MetaObject.RESIZE_CONTEXT_SIZEBOX_RESIZING) ||
                    (resizeContext == MetaObject.RESIZE_CONTEXT_SIZEBOX_RESIZED) ||
                    (resizeContext == MetaObject.RESIZE_CONTEXT_FROM_LAYOUT)) {
                iLocationGridX = 0;
                iLocationGridY = 0;
            }
            if (iLocationGridX != 0) {
                int iXMargin = iNewXLocation % iLocationGridX;
                int iXFactor = iNewXLocation / iLocationGridX;
                if (iXMargin < iLocationGridX / 2)
                    iNewXLocation = iXFactor * iLocationGridX;
                else
                    iNewXLocation = (iXFactor + 1) * iLocationGridX;
                bLoadPropertyTable = true;
            }
            if (iLocationGridY != 0) {
                int iYMargin = iNewYLocation % iLocationGridY;
                int iYFactor = iNewYLocation / iLocationGridY;
                if (iYMargin < iLocationGridY / 2)
                    iNewYLocation = iYFactor * iLocationGridY;
                else
                    iNewYLocation = (iYFactor + 1) * iLocationGridY;
                 bLoadPropertyTable = true;
            }
            // Size can microadjust unless we are finished with sizebox (then it snaps)
            if (resizeContext != MetaObject.RESIZE_CONTEXT_SIZEBOX_RESIZED) {
                iSizeGridX = 0;
                iSizeGridY = 0;
            }
            if (bResizeHorizontal && iSizeGridX != 0) {
                int iXMargin = iNewXSize % iSizeGridX;
                int iXFactor = iNewXSize / iSizeGridX;
                if (iXMargin < iSizeGridX / 2)
                    iNewXSize = iXFactor * iSizeGridX;
                else
                    iNewXSize = (iXFactor + 1) * iSizeGridX;
                bLoadPropertyTable = true;
            }
            if (bResizeVertical && iSizeGridY != 0) {
                int iYMargin = iNewYSize % iSizeGridY;
                int iYFactor = iNewYSize / iSizeGridY;
                if (iYMargin < iSizeGridY / 2)
                    iNewYSize = iYFactor * iSizeGridY;
                else
                    iNewYSize = (iYFactor + 1) * iSizeGridY;
                bLoadPropertyTable = true;
            }
        }

        //#ALEX: I have no idea why this might be null but I am getting NPE otherwise...
        if ( theMetaObject != null ){
          theMetaObject.setLocation(iNewXLocation, iNewYLocation);
          theMetaObject.setSize(iNewXSize, iNewYSize);
        }



        //#ALEX
        //Resize the Viewdisplayer so Scrollbars appear when neccessray
        // 20040615, acg, check for null. Exception here causes problems on close project.
        MetaObject selectedFrame = this.getSelectedFrame();
        if ( selectedFrame!=null ) {
            Dimension frameSize = selectedFrame.getSize();
            if (!theViewDisplayer.getPreferredSize().equals(frameSize)) {
                theViewDisplayer.setPreferredSize(frameSize);
                theViewDisplayerScrollPane.validate();
            }
        }

        if (bLoadPropertyTable)
            getPropertyInspectorController().refreshPropertyInspector();
    }

    public void processMenus(MetaObject theMetaObject)
    {
        if (theMetaObject.theParentObject.theVisualObject instanceof JMenuBar) {
            JMenuBar theMenuBar = (JMenuBar) theMetaObject.theParentObject.theVisualObject;

            int index = theMenuBar.getComponentIndex(theMetaObject.theVisualObject);
            JMenu jm = (JMenu) theMetaObject.theVisualObject;

            if(index==-1)
                theMenuBar.add(theMetaObject.theVisualObject);
            else
                theMenuBar.add(theMetaObject.theVisualObject,index);
        }
    }

    public void processMenuItems(MetaObject theMetaObject)
    {
        if (theMetaObject.theParentObject.theVisualObject instanceof JMenu) {
            JMenu theMenu = (JMenu) theMetaObject.theParentObject.theVisualObject;
            JMenuItem jm = (JMenuItem) theMetaObject.theVisualObject;
            theMenu.add(theMetaObject.theVisualObject);
        }
    }

    public void processMenuSeparators(MetaObject theMetaObject)
    {
        if (theMetaObject.theParentObject.theVisualObject instanceof JMenu) {
            JMenu theMenu = (JMenu) theMetaObject.theParentObject.theVisualObject;
            JSeparator jm = (JSeparator) theMetaObject.theVisualObject;
            theMenu.add(theMetaObject.theVisualObject);
        }
    }

    public void processTabPages (MetaObject theMetaObject) {
        if (theMetaObject.theParentObject.theVisualObject instanceof DesignTabbedPane) {
            DesignTabbedPane theTabbedPane = (DesignTabbedPane) theMetaObject.theParentObject.theVisualObject;
            int iIndex = theTabbedPane.indexOfComponent(theMetaObject.theVisualObject);
            if (iIndex == -1) {
                theTabbedPane.addTab("tab", theMetaObject.theVisualObject);
            } //else { // SWB: this code commented-out so that a loaded project will display the first page, not last
                //int iTestIndex = theTabbedPane.getSelectedIndex();
                //if (iTestIndex != iIndex)
                //    theTabbedPane.setSelectedIndex(iIndex);
            //}
        } else if (theMetaObject.theParentObject.theVisualObject instanceof JTabbedPane) {
            JTabbedPane theTabbedPane = (JTabbedPane) theMetaObject.theParentObject.theVisualObject;
            int iIndex = theTabbedPane.indexOfComponent(theMetaObject.theVisualObject);
            if (iIndex == -1) {
                iIndex = theMetaObject.theParentObject.getChildIndex(theMetaObject);
                MetaPropertyValueEx theTabTitle = theMetaObject.theParentObject.getPropertyValue("TabTitle", iIndex);
                if (theTabTitle == null)
                    theTabbedPane.addTab("tab", theMetaObject.theVisualObject);
                else
                    theTabbedPane.addTab(theTabTitle.getStringValue(), theMetaObject.theVisualObject);
            } //else { // SWB: as above
            //    int iTestIndex = theTabbedPane.getSelectedIndex();
            //    if (iTestIndex != iIndex)
            //        theTabbedPane.setSelectedIndex(iIndex);
            //}
        }
    }

    public void processPlacement (MetaObject theObject) {
        // Design Mode.
        Container theContainer = null;
        if (theObject.theParentObject.theVisualObject != null)
            theContainer = theObject.theParentObject.theVisualObject;
        else
            theContainer = theObject.theParentObject.theVisualFrame.getContentPane();
        // Components placed in Split panes first because they are special.
        if (theObject.theParentObject.isHorzSplit()) {
            if (theObject.theParentObject.getFirstChild().equals(theObject))
                ((JSplitPane) theContainer).setLeftComponent(theObject.theVisualObject);
            else {
                ((JSplitPane) theContainer).setRightComponent(theObject.theVisualObject);
                int iDividerLocation = 0;
                MetaPropertyValueEx theDividerLocation = theObject.theParentObject.getPropertyValue("DividerLocation", 0);
                if (theDividerLocation != null)
                    iDividerLocation = ((Integer) theDividerLocation.getNativeValue()).intValue();
                ((JSplitPane) theContainer).resetToPreferredSizes();
                ((JSplitPane) theContainer).setDividerLocation(iDividerLocation);
            }
            return;
        }
        if (theObject.theParentObject.isVertSplit()) {
            if (theObject.theParentObject.getFirstChild().equals(theObject))
                ((JSplitPane) theContainer).setTopComponent(theObject.theVisualObject);
            else {
                ((JSplitPane) theContainer).setBottomComponent(theObject.theVisualObject);
                int iDividerLocation = 0;
                MetaPropertyValueEx theDividerLocation = theObject.theParentObject.getPropertyValue("DividerLocation", 0);
                if (theDividerLocation != null)
                    iDividerLocation = ((Integer) theDividerLocation.getNativeValue()).intValue();
                ((JSplitPane) theContainer).resetToPreferredSizes();
                ((JSplitPane) theContainer).setDividerLocation(iDividerLocation);
            }
            return;
        }
        // Fix for radio buttons.
        if (theObject.theVisualObject instanceof AbstractButton) {
            if (theObject.theParentObject.isGroup()) {
                ButtonGroup theGroup = theObject.theParentObject.getButtonGroup();
                if (theGroup != null)
                    theGroup.add((AbstractButton) theObject.theVisualObject);
            }
        }

        if (theObject.theParentObject.isJToolBar() && bOpenSource==true) {
            JToolBar theToolBar = (JToolBar) theObject.theParentObject.theVisualObject;

            int index = theToolBar.getComponentIndex(theObject.theVisualObject);

            theToolBar.setFloatable(false);
            if(index==-1)
                theToolBar.add((AbstractButton)theObject.theVisualObject);
            else
                theToolBar.add((AbstractButton)theObject.theVisualObject,index);
         }

        // Now do layered placement.
        if (theObject.theParentObject.theLayoutManager instanceof DesignAnchoringLayoutManager) {
            DesignAnchoringLayoutManager theParentLayout =
                    (DesignAnchoringLayoutManager) theObject.theParentObject.theLayoutManager;
            // Need to remove children before adding.
            if ((theObject.theVisualObject instanceof JLayeredPane) || (theObject.theVisualObject instanceof JPanel) || (theObject.theVisualObject instanceof DesignPanel)){
               // For Composite components . Unfortunately we have a few inside the abalib
                if (theObject.isCompositeComponent()==false)
                {
                  theObject.theVisualObject.removeAll();
                }
            }

            String sComponentName = theParentLayout.getName(theObject.theVisualObject);
            if (theContainer instanceof JLayeredPane) {
                JLayeredPane thePane = (JLayeredPane) theContainer;
                thePane.add(theObject.theVisualObject, theObject.getName(), JLayeredPane.DEFAULT_LAYER.intValue());
            } else {
                theContainer.add(theObject.theVisualObject, theObject.getName());
            }
            if (sComponentName != null)
                theParentLayout.addLayoutComponent(sComponentName, theObject.theVisualObject);
            theParentLayout.setAnchoring(theObject.theVisualObject, theObject,
                    theObject.getAnchorLeft(), theObject.getAnchorRight(),
                    theObject.getAnchorTop(), theObject.getAnchorBottom());
            if ((theObject.isAbalet() != true) && (theObject.isFrame() != true))
                theSizeboxes.update(theObject, theObject.iXLocation, theObject.iYLocation,
                        (int) theObject.dimSize.getWidth(), (int) theObject.dimSize.getHeight());
        } else {  // Renderer called from within Design Cockpit.
            // Now do auto embed.
            theObject.theScrollPane = null;
            AnchoringLayoutManager theParentLayout = (AnchoringLayoutManager) theObject.theParentObject.theLayoutManager;
            if (theParentLayout != null) {
                if (theObject.bAutoEmbed) {
                    theObject.theScrollPane = new JAScrollPane(theObject.theVisualObject);   // change JScrollPane to JAScrollPane (lauchenauer)
                    theObject.theScrollPane.setSize(theObject.dimSize);
                    theObject.theVisualObject.setSize(theObject.dimSize);
                    theObject.theScrollPane.setLocation(theObject.iXLocation, theObject.iYLocation);
                    String sComponentName = theParentLayout.getName(theObject.theScrollPane);
                    theContainer.add(theObject.theScrollPane, theObject.getName());
                    if (sComponentName != null)
                        theParentLayout.addLayoutComponent(sComponentName, theObject.theScrollPane);
                    theParentLayout.setAnchoring(theObject.theScrollPane,
                            theObject.getAnchorLeft(), theObject.getAnchorRight(),
                            theObject.getAnchorTop(), theObject.getAnchorBottom());
                } else {
                    String sComponentName = theParentLayout.getName(theObject.theVisualObject);
                    theContainer.add(theObject.theVisualObject, theObject.getName());
                    if (sComponentName != null)
                        theParentLayout.addLayoutComponent(sComponentName, theObject.theVisualObject);
                    theParentLayout.setAnchoring(theObject.theVisualObject,
                            theObject.getAnchorLeft(), theObject.getAnchorRight(),
                            theObject.getAnchorTop(), theObject.getAnchorBottom());
                }
            }
        }
    }

    public void processCreateLayout (MetaObject theObject) {
        DesignAnchoringLayoutManager theAnchoringLayoutManager = new DesignAnchoringLayoutManager(theObject, this);
        theObject.theLayoutManager = theAnchoringLayoutManager;
        if (theObject.theVisualFrame != null)
            theObject.theVisualFrame.getContentPane().setLayout(theAnchoringLayoutManager);
        else
            theObject.theVisualObject.setLayout(theAnchoringLayoutManager);
    }

    public void processDoFrameSizeboxes (MetaObject theObject) {
        if (theObject.theDesignProject != null) {
            Dimension theSize = theObject.getSize();
            if (theFrameSizeboxes != null)
                theFrameSizeboxes.update(0, 0, (int) theSize.getWidth(),
                        (int) theSize.getHeight());
        }
    }

    public void doNewVisualObject (MetaObject theObject) {
        if (theObject.theFabricatedObject instanceof JComponent)
            theObject.theVisualObject = (JComponent) theObject.theFabricatedObject;
        else if (theObject.theFabricatedObject instanceof JFrame)
            theObject.theVisualFrame = (JFrame) theObject.theFabricatedObject;
        if (theObject.theDesignProject.iMode == AbaMetaDataUser.DESIGN_MODE) {
            //SuperDesignCockpit theDesignCockpit = (SuperDesignCockpit)theObject.theDesignProject.getMetaDataUser();
            if (theObject.theFabricatedObject instanceof DesignPanel) {
                DesignPanel theDesignPanel = (DesignPanel) theObject.theFabricatedObject;
                theDesignPanel.theDesignCockpit = this;
                theDesignPanel.theMetaObject = theObject;
            }
            if (theObject.theFabricatedObject instanceof DesignTabbedPane) {
                DesignTabbedPane theDesignTabbedPane = (DesignTabbedPane) theObject.theFabricatedObject;
                theDesignTabbedPane.initalizeTabbedPane(this, theObject);
            }
            if (theObject.theFabricatedObject instanceof DesignSplitPane) {
                DesignSplitPane theDesignSplitter = (DesignSplitPane) theObject.theFabricatedObject;
                theDesignSplitter.theDesignCockpit = this;
                theDesignSplitter.theMetaObject = theObject;
            }
        }

    }

    public void updateDisplayLayer (MetaObject theObject, int iLayer) {
        String sName = ((DesignAnchoringLayoutManager) theObject.theParentObject.theLayoutManager).getName(theObject.theVisualObject);
        // Only set up layers for things that can be added to an anchoring layout manager like
        // controls in tab pages, panels, frames and panels in tab pages and panels and frames.
        // Objects in scrollpanes and tab pages in tabbed panes are skipped.
        if (sName != null) {
            DesignProject theDesignProject = getDesignProject();
            ((JLayeredPane) theObject.theParentObject.theVisualObject).setLayer(theObject.theVisualObject, iLayer);
            ((DesignAnchoringLayoutManager) theObject.theParentObject.theLayoutManager).addLayoutComponent(sName, theObject.theVisualObject);
            ((DesignAnchoringLayoutManager) theObject.theParentObject.theLayoutManager).setAnchoring(theObject.theVisualObject, theObject,
                    theObject.bLeftAnchoring, theObject.bRightAnchoring,
                    theObject.bTopAnchoring, theObject.bBottomAnchoring);
            if ((theDesignProject != null) && (theDesignProject.theMetaProject.iMode == AbaMetaDataUser.DESIGN_MODE)) {
                if (theDesignProject.theSelectedObjects.contains(theObject)) { // Am I selected?
                    // must be in design mode
                    if ((theObject.isAbalet() != true) && (theObject.isFrame() != true))
                        theSizeboxes.update(theObject, theObject.iXLocation, theObject.iYLocation,
                                (int) theObject.dimSize.getWidth(), (int) theObject.dimSize.getHeight());
                }
            }
        }

    }

    public void propertyEditedRepaint (MetaObject theObject) {
        theViewDisplayer.repaint();
    }

    public void processDeleteObject (MetaObject theObject) {
        // Remove from the object tree
        theObjectTreeViewPane.removeObject(theObject);
        // Redisplay the view displayer.
        MetaObject theSelectedContainer = getSelectedContainer();
        if (theSelectedContainer != null) {
            if (theSelectedContainer.equals(theObject)) {
                theSelectedContainer = theSelectedContainer.getVisualContainerObject(true);
                SelectContainer(null);
                SelectContainer(theSelectedContainer);
            }
            if (theObject.isTabPage()) {
                if (theObject.theParentObject.theVisualObject instanceof DesignTabbedPane) {
                    DesignTabbedPane theTabbedPane = (DesignTabbedPane) theObject.theParentObject.theVisualObject;
                    int iIndex = theTabbedPane.indexOfComponent(theObject.theVisualObject);
                    if (iIndex != -1)
                        theTabbedPane.removeTabAt(iIndex);
                } else {
                    if (theObject.theParentObject.theVisualObject != null)
                        theObject.theParentObject.theVisualObject.remove(theObject.theVisualObject);
                }
            } else if (theObject.theParentObject != null) {
                if (theObject.theParentObject.theVisualObject != null)
                    theObject.theParentObject.theVisualObject.remove(theObject.theVisualObject);
            }
//              theDesignCockpit.SelectObject(theSelectedContainer, true);
        }

    }

    public boolean getAttachedToDesigner () {
        return true;
    }

    public void processProjectChangedState(boolean bState) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    public void processObjectNameChanged (MetaObject theObject) {
        String sName = theObject.getName();
        String sOldName = null;
        //  Update the object tree view.
        if (theObject.getTreeNode() != null) {
            sOldName = (String) theObject.getTreeNode().getUserObject();
            theObject.getTreeNode().setUserObject(sName);
        }
        if ((theObject.theDesignProject != null) && ((sOldName == null) || (sOldName.equals(sName) == false))) {
            // Tree view is updated because the name might have changed.
            theObjectTreeViewPane.theTree.repaint();
            MetaObject selectedContainer = getSelectedContainer();
            MetaObject selectedObject = getSelectedObject();
            if (selectedObject != null) {
                if (selectedObject.equals(theObject))
                    theStatusPanel.setSelectedObject(theObject);
            }
            // This is the only way to not have the labels truncated to ...
            theObjectTreeViewPane.theTree.updateUI();
        }

    }

    public void runProject () {
        getDesignProject().theMetaProject.getNLS().writeAllChangedNlsDocuments();
        // set up renderer for running.
        if ((getDesignProject().theMetaProject.sName == null) ||
                ((getDesignProject().theMetaProject.sName.equals(getNewProjectName())) &&
                (getDesignProject().theMetaProject.getProjectChangedState() == false))) {
            JFileChooser theFileChooser = new JFileChooser(getCurrentDirectory());
            theFileChooser.addChoosableFileFilter(new ProjFileFilter(this));
            theFileChooser.setFileView(new ProjFileView(this));
            int iOptionSelected = theFileChooser.showOpenDialog(getContentPane());
            String sFullPath = null;
            if (iOptionSelected == JFileChooser.APPROVE_OPTION) {
                File file = theFileChooser.getSelectedFile();
                try {
                    sFullPath = file.getCanonicalPath();
                    String sSeparator = props.getProperty("file.separator");
                    int iSeparator = sFullPath.lastIndexOf(sSeparator);
                    if (iSeparator != -1) {
                        String sDirectoryName = sFullPath.substring(0, iSeparator + 1);
                        setCurrentDirectory(sDirectoryName);
                    }
                } catch (java.io.IOException e1) {
                }
            }
            if (sFullPath != null) {
                AbaRenderer theRenderer = null;
                try {
                    theRenderer = new AbaRenderer(sFullPath, true, theGlobalInterface);
                } catch (HammerException e1) {
                }
                if (theRenderer != null) {
                    try {
                        theRenderer.load();
                        theRenderer.setLanguage(getDesignProject().theMetaProject.getCurrentLanguage().theLanguage);
                        theRenderer.renderInterface();
                    } catch (HammerException e1) {
                    }
                }

            }
        } else {
            ch.abacus.lib.ui.renderer.abaRenderer.AbaRenderer theRenderer = null;
            try {
                theRenderer = new ch.abacus.lib.ui.renderer.abaRenderer.AbaRenderer(getDesignProject().theMetaProject, true, theGlobalInterface);
            } catch (HammerException e1) {
            }
            if (theRenderer != null) {
                theRenderer.setLanguage(getDesignProject().theMetaProject.getCurrentLanguage().theLanguage);
                theRenderer.renderInterface();
            }
        }
//          String sJavaPath = theDesignCockpit.props.getProperty("sun.boot.library.path");
//          String sJavaClassPath = theDesignCockpit.props.getProperty("java.class.path");
//          String sPathSeparator = theDesignCockpit.props.getProperty("path.separator");
//          String sFileSeparator = theDesignCockpit.props.getProperty("file.separator");
//          String sJavaRuntimeName = "javaw";
//          sJavaClassPath = theDesignCockpit.getDesignProject().theProgramData.sOutputDirectory +
//                           sPathSeparator +
//                           sJavaClassPath;
//          String sProgram = theDesignCockpit.getDesignProject().theProgramData.sMainClass + "." +
//                            theDesignCockpit.getDesignProject().theProgramData.sMainClass;
//          String sCommandLine = sJavaPath+sFileSeparator+sJavaRuntimeName + " -classpath \"" +
//                                sJavaClassPath + "\" " + sProgram;
//          try {
//              java.lang.Runtime.getRuntime().exec(sCommandLine);
//          }
//          catch (java.io.IOException e1) {
//              JOptionPane pane = new JOptionPane("Unable to execute " + sCommandLine,
//                                                  JOptionPane.ERROR_MESSAGE);
//              JDialog dialog = pane.createDialog(theDesignCockpit, "Cannot Execute Program");
//              dialog.show();
//              ExceptionWriter writerTemp = new ExceptionWriter();
//              PrintWriter pwTemp = new PrintWriter(writerTemp);
//              e1.printStackTrace(pwTemp);
//              theDesignCockpit.theSourceViewer.setMessagesText(writerTemp.getBuffer());
//          }

    }

    public void allowDragging (boolean b) {
        bAllowDragging = b;
    }

    public boolean getAllowDragging () {
        return bAllowDragging;
    }

    // Zero params specified - global interface is null, preferences are ignored.
    // one param specified - Preference document supplied.  Global interface is null

    public static void main (String[] args) throws HammerException {

        SuperDesignCockpit theDesignCockpit;

        if (args.length >= 1) {
            theDesignCockpit = new SuperDesignCockpit(args[0], null);
        } else {
            theDesignCockpit = new SuperDesignCockpit(null, null);
        }

        // Set up program exit behavior.
        if (theDesignCockpit != null) {
            theDesignCockpit.defineInitialFrameListeners();
            theDesignCockpit.show();
        }

    }

//    public PropertyTable getPropertyTable () {
//        return thePropertyTable;
//    }

    public boolean isCustomizing () {
        return (theCustomizer != null);
    }

    public void setTitle (String title) {
        if (isCustomizing())
            title = theCustomizer.getCustomizerTitle();

        super.setTitle(title);
    }

    protected int getProgramMode () {
        boolean bJavaBuilder = theConfigurationManager.checkConfigurationSetting("JavaBuilder");
        int iProgramMode = SuperDesignCockpit.STRIPPED;
        if (bJavaBuilder)
            iProgramMode = SuperDesignCockpit.JAVABUILDER;

        return iProgramMode;
    }

    public IDEToolBar getIDEToolBar () {
        return theToolBar;
    }

    public IDEMenuBar getIDEMenuBar () {
        return theMenuBar;
    }

    protected void defineInitialFrameListeners () {
        // Set up program exit behavior.
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

        // Add window listeners to process exit logic
        addWindowListener(new IDEWindowClosedEventHandler(this));
        addWindowListener(new IDEWindowClosingEventHandler(this));
    }

    public IDEPropertyInspectorController getPropertyInspectorController() {
        return idePropertyInspectorController;
    }

    public void showHelper(MetaObject metaObject, String sPropertyName) {
        MetaPropertyDescriptor theProp = metaObject.theClass.getProperty(sPropertyName, true);
        if (theProp != null) {
            String sHelperClass = theProp.getHelperClass();
            if (sHelperClass != null && sHelperClass.length() > 0) {
                try {
                    Class helperClass = Class.forName(sHelperClass);
                    Constructor helperConstructor = helperClass.getConstructor((Class[]) null);
                    Object helper = helperConstructor.newInstance((Object[]) null);

                    Class[] paramClasses = new Class[3];
                    paramClasses[0] = MetaObject.class;
                    paramClasses[1] = String.class;
                    paramClasses[2] = SuperDesignCockpit.class;

                    Method executeMethod = helperClass.getMethod("execute", paramClasses);
                    Object[] paramValues = new Object[3];
                    paramValues[0] = metaObject;
                    paramValues[1] = sPropertyName;
                    paramValues[2] = this;
                    boolean bProjectModified = ((Boolean) executeMethod.invoke(helper, paramValues)).booleanValue();
                    if (bProjectModified)
                    {
                        getPropertyInspectorController().refreshPropertyInspector();
                        theCurrentDesignProject.theMetaProject.setProjectChangedState(true);
                    }
                } catch (ClassNotFoundException e) {
                    e.printStackTrace();
                } catch (NoSuchMethodException e) {
                    e.printStackTrace();
                } catch (InstantiationException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }

            } else if (theProp.bAllowMultipleValues) {
                //todo bring back?
//                if (m_defaultPropertyInspector.theArrayValueEditor != null)
//                    m_defaultPropertyInspector.theArrayValueEditor.close();
//                m_defaultPropertyInspector.theArrayValueEditor = new IDEArrayValueEditor(thePropertyTable.theModel.theMetaObject, sPropertyName, thePropertyTable.theDesignCockpit);
            }
        }
    }

}

