/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.ide.propertyinspector;

import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.propertyinspector.display.renderer.PropertyValueRenderer;
import ch.abacus.lib.ui.propertyinspector.display.renderer.ColorIcon;
import ch.abacus.lib.ui.renderer.common.*;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;

import javax.swing.*;
import java.awt.*;

public class ColorPropertyValueRenderer extends PropertyValueRenderer {

    protected JALabel m_label = new JALabel();
    private String m_typeConstants;
    private SuperDesignCockpit m_superDesignCockpit;

    //Color currentColor;

    public ColorPropertyValueRenderer(SuperDesignCockpit superDesignCockpit, String sTypeConstants) {
        super();
        m_superDesignCockpit = superDesignCockpit;
        m_typeConstants = sTypeConstants;
        m_label.setOpaque(true);
    }

    public JComponent getComponent() {
        return m_label;
    }

    public void setValue(Object value) {
        //System.out.println("setValue: " +value);
        Color currentColor = null;
        Icon currentIcon = null;

        if (value != null) {
            currentColor = getItemColor((String) value);
            currentIcon= new ColorIcon(currentColor);
            //System.out.println("Color " + value + " = " + currentColor);
        }

        m_label.setText(value == null ? "" : value.toString());
        m_label.setIcon(currentIcon);

    }

//    int currentRow;
//
    Color getItemColor(String avalue)
    {
        Object theResolvedValue=null;
        final MetadataDispenser metadataDispenser = m_superDesignCockpit.theMetadataDispenser;
        MetaConstantGroupCollection theConstantTableGroup =
                metadataDispenser.findConstantGroupCollection(m_typeConstants);
//todo SWB Needed?        if ( avalue==null )
//            avalue = theProperty.getDefaultValue();
        Object nv = theConstantTableGroup.get(avalue);
        try
        {
            final HammerClassCustomLoader loader = m_superDesignCockpit.getClassLoader().getLoader();
            theResolvedValue = MetaConstantGroup.resolve(nv, metadataDispenser, loader);
        }
        catch (HammerException e) { e.printStackTrace(); }

        return (Color)theResolvedValue;
    }

//    private class ColorLabel extends JALabel {
//        // Paint current color
//        public void xpaint(Graphics g)
//        {
//            boolean bDrawColor = getText() != "";
//            JButton button=new JButton();
//            Dimension dim=new Dimension( button.getFontMetrics(button.getFont()).stringWidth("...")*2, button.getFontMetrics(button.getFont()).getHeight() );
//
//            if (bDrawColor) {
//                // Border
//                g.setColor(Color.black);
//                g.fillRect(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
//
//                g.setColor(currentColor);
//                g.fillRect(1, 1, (int)dim.getWidth()-2, (int)dim.getHeight()-2);
//            }
//            FontMetrics fontMetrics = g.getFontMetrics();
//            g.setColor(m_label.getForeground());
//            g.drawString(getText(), (int)dim.getWidth()+2, fontMetrics.getAscent());
//        }
//
//    }
}
