/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import javax.swing.*;
import java.io.*;
import java.util.jar.*;
import java.util.*;
import java.nio.channels.FileLock;

public class JarModifier {
    private final File jarName;
    private HashSet existingFiles = null;
    private File tempJarName = null;

    public JarModifier(File jarName, File tempJarName) throws IOException {
        this.jarName = jarName;
        existingFiles = new HashSet();
        if (tempJarName != null)
            this.tempJarName = tempJarName;
        else {
            this.tempJarName = File.createTempFile("ADC", ".jar");  // FYI: ADC = Abacus Design Cockpit
        }

    }

    public static void main(String[] args) throws IOException {
        // Create the jarModifier file, using the first command line argument as the file name
        String jarName = args[0];
        //readFileFromJar();
        //writeSingleFileToJar();
        //writeJar(jarName, args);
        //displayJarContents(jarName, args);
        JarModifier jarModifier = new JarModifier(new File("C:\\AbaJava\\v2005_cdnew\\aba\\java\\jars\\abalib.jar"), null);

        //JarModifier jarModifier = new JarModifier(new File("C:\\TestJar\\_a.zip"));
        jarModifier.replaceFile(new File("ch/abacus/lib/ui/renderer/deploy/metadata.meta"), new File("c:\\metadata.meta"));
    }//main

    private void showFilesInJar(ArrayList files) {
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            String sFile = (String) iterator.next();
            System.out.println(sFile);
        }
    }

    private static void writeJar(String jarName, String[] args) throws IOException {
        JarOutputStream jar = new JarOutputStream(new FileOutputStream(jarName), new Manifest());
        System.out.println(jarName + " created.");
        try {
            // Allocate a buffer for reading the input files.
            byte[] buffer = new byte[1024];
            int bytesRead;
            // Loop through the file names provided on the command-line.
            for (int i = 1; i < args.length; i++) {
                String fileName = args[i]; // Get the file name.
                try {
                    FileInputStream file = new FileInputStream(fileName);
                    try {
                        // Create a jar entry and add it to the jar.
                        JarEntry entry = new JarEntry(fileName);
                        jar.putNextEntry(entry);
                        // Read the file the file and write it to the jar.
                        while ((bytesRead = file.read(buffer)) != -1) {
                            jar.write(buffer, 0, bytesRead);
                        }
                        System.out.println(entry.getName() + " added.");
                    } catch (Exception e) {
                        System.out.println(e.getMessage());
                    } finally {
                        file.close();
                    }//try
                } catch (IOException io) {
                    System.out.println(io.getMessage());
                }//try
            }//for
        } finally {
            jar.close();
            System.out.println(jarName + " closed.");
        }//try
    }

    private static void displayJarContents(String sJarName, String[] args) throws IOException {
        JarInputStream jar = new JarInputStream(new FileInputStream(sJarName));
        System.out.println(sJarName + " found.");
        JarEntry jarEntry = jar.getNextJarEntry();
        while (jarEntry != null) {
            System.out.println(jarEntry.getName());
            jarEntry = jar.getNextJarEntry();
        }
    }

    private static void writeSingleFileToJar() throws IOException {
        String jarName = "bigjar.jar";
        String fileName = "log.txt";
        JarOutputStream jar = new JarOutputStream(new FileOutputStream(jarName), new Manifest());
        System.out.println(jarName + " created.");
        try {
            // Allocate a buffer for reading the input files.
            int bytesRead;
            JarEntry entry = new JarEntry("crap/bollox/dog/log.txt");
            jar.putNextEntry(entry);
            for (int i = 0; i < 500; i++) {
                String s = ("Line " + (i + 1)) + "\r\n";
                byte[] buffer = s.getBytes();
                jar.write(buffer);
            }
        } catch (IOException io) {
            System.out.println(io.getMessage());
        } finally {
            jar.close();
            System.out.println(jarName + " closed.");
        }//try
    }

    private void readFileFromJar() throws IOException {
        String jarName = "bigjar.jar";
        String fileName = "log.txt";
        JarInputStream jar = new JarInputStream(new FileInputStream(jarName));
        System.out.println(jarName + " created.");
        String sText = "";
        try {
            // Allocate a buffer for reading the input files.
            byte[] buffer = new byte[1024];
            int bytesRead;
            JarEntry entry = jar.getNextJarEntry();
            while ((bytesRead = jar.read(buffer)) != -1) {
                sText += new String(buffer, 0, bytesRead);
            }
        } catch (IOException io) {
            System.out.println(io.getMessage());
        } finally {
            jar.close();
            System.out.println(jarName + " closed.");
            System.out.println(sText);
        }//try
    }

    private ArrayList getListOfFilesInJar(File jarName) throws IOException {
        ArrayList filesList = new ArrayList();
        JarInputStream jar = new JarInputStream(new FileInputStream(jarName));

        JarEntry jarEntry = jar.getNextJarEntry();
        while (jarEntry != null) {
            filesList.add(jarEntry.getName());
            jarEntry = jar.getNextJarEntry();
        }
        return filesList;
    }


    private void copyJarEntry(JarInputStream jarInputStream, JarOutputStream jarOutputStream, JarEntry jarEntryInput) throws IOException {
        if (shouldCopyFile(new File(jarEntryInput.getName()))) {
            //System.out.println("Copying " + jarEntryInput.getName());
            JarEntry jarEntryOutput = new JarEntry(jarEntryInput.getName());
            jarEntryOutput.setTime(jarEntryInput.getTime());
            jarOutputStream.putNextEntry(jarEntryOutput);
            byte[] buffer = new byte[1024];
            int bytesRead;
            while ((bytesRead = jarInputStream.read(buffer)) != -1) {
                jarOutputStream.write(buffer, 0, bytesRead);
            }
        }

    }

    private boolean shouldCopyFile(File file) {
//        if (file.getName().startsWith("metadata")) {
//        }
        return (existingFiles.contains(file.getPath()) == false);
    }

    /**
     * Replaces a file in the JAR with a new file. The name new file can point to any file, but when added to the JAR,
     * it will use the name of the replaced file.
     * @param fileToReplace the file to replace
     * @param newFile an existing file that will be written into the JAR using the name provided in {@code fileToReplace}
     */
    public void replaceFile(File fileToReplace, File newFile) throws IOException {
        performReplaceFileErrorChecking(newFile);

        existingFiles.clear();
        existingFiles.add(fileToReplace.getPath());

        JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarName));
        Manifest manifest = jarInputStream.getManifest();
        JarOutputStream jarOutputStream;
        if (manifest != null)
            jarOutputStream = new JarOutputStream(new FileOutputStream(tempJarName), manifest);
        else
            jarOutputStream = new JarOutputStream(new FileOutputStream(tempJarName));

        JarEntry jarEntryInput = jarInputStream.getNextJarEntry();
        while (jarEntryInput != null) {
            copyJarEntry(jarInputStream, jarOutputStream, jarEntryInput);
            jarEntryInput = jarInputStream.getNextJarEntry();
        }

        // copy in new file...
        addFile(newFile, fileToReplace.getPath(), jarOutputStream);

        jarInputStream.close();
        jarOutputStream.close();

        boolean bDeleted = jarName.delete(); // delete original jar file
        if ( bDeleted ) {
            boolean bMoved = tempJarName.renameTo(jarName); // move temp jar to the original location
            //if (bMoved == false)
                //System.out.println("Failed to move temp jar");
        } else {
            //System.out.println("Failed to delete JAR file");
        }
    }

    private void performReplaceFileErrorChecking(File newFile) throws IOException {
        // ensure the new file exists...
        if (newFile.exists() == false) {
            throw new FileNotFoundException("(" +newFile.getPath() +")");
        }

        // ensure the jar exists...
        if (jarName.exists() == false)
            throw new FileNotFoundException("(" +jarName.getPath() +")");

//        // ensure it is not read-only...
//        if (jarName.canWrite() == false) {
//            throw new IOException("The JAR is read-only");
//        }

    }

    private void addFile(File newFile, String sFilename, JarOutputStream jarOutputStream) throws IOException {
        sFilename = convertBackslashesToSlashes(sFilename);
        FileInputStream fis = new FileInputStream(newFile);
        JarEntry jarEntryOutput = new JarEntry(sFilename);
        jarOutputStream.putNextEntry(jarEntryOutput);
        byte[] buffer = new byte[1024];
        int bytesRead;
        while ((bytesRead = fis.read(buffer)) != -1) {
            jarOutputStream.write(buffer, 0, bytesRead);
        }
        fis.close();
        jarOutputStream.closeEntry();
    }

    private String convertBackslashesToSlashes (String sSource) {
        char[] c = sSource.toCharArray();
        for (int i = 0; i < c.length; i++) {
            if (c[i] == '\\')
                c[i] = '/';
        }
        return new String(c);
    }

}//JarModifier

