/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.designcockpit.metadataEditor;

import ch.abacus.lib.ui.*;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;

import javax.swing.*;
import javax.swing.BorderFactory;
import java.awt.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

/**
 * Created by IntelliJ IDEA.
 * User: Stuart
 * Date: Nov 23, 2004
 * Time: 3:13:42 PM
 */
public class ManageClassPageAttributes extends JAPanel {
    private final ManageClassDialog theDialog;
    private final MetaClass theClass;
    private JATextField classFullName;
    private JATextField classSuperclassName;
    private JATextField classSuperclassFullName;
    private DisplayClasses classDisplayClass;
    private JACheckBox classHidden;
    private JACheckBox classSkipDeclarations;
    private JACheckBox classDesignBorders;
    private JACheckBox classSkipDefaultListeners;
    private ContainerTypes classContainerType;
    private Custom classCustom;
    private ClassFactoryClasses classClassFactory;
    private DesignEditorClasses classDesignEditor;

    private JAPanel panel;
    private TreeSet theDisplayClasses = new TreeSet();
    private TreeSet theCustom = new TreeSet();
    private TreeSet theClassFactoryClasses = new TreeSet();
    private TreeSet theDesignEditorClasses = new TreeSet();

    public ManageClassPageAttributes(ManageClassDialog manageClassDialog, MetaClass theClass) {
        super(new BorderLayout());
        this.theDialog = manageClassDialog;
        this.theClass = theClass;

        createLists();

        initDisplay();
        populateDisplay();
    }

    private void initDisplay() {
        panel = new JAPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = GridBagConstraints.BOTH;
        c.insets = new Insets(5, 5, 5, 5);

        classFullName = new JATextField();
        classSuperclassName = new JATextField();
        classSuperclassFullName = new JATextField();
        classDisplayClass = new DisplayClasses();
        classHidden = new JACheckBox("Hidden");
        classSkipDeclarations = new JACheckBox("Skip Declarations");
        classDesignBorders = new JACheckBox("Design Borders");
        classSkipDefaultListeners = new JACheckBox("Skip Default Listeners");
        classContainerType = new ContainerTypes();
        classCustom = new Custom();
        classClassFactory = new ClassFactoryClasses();
        classDesignEditor = new DesignEditorClasses();

        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0;
        c.weighty = 0;
        panel.add(new JALabel("Full Class Name"), c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1;
        panel.add(classFullName, c);

        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0;
        panel.add(new JALabel("Superclass name"), c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1;
        panel.add(classSuperclassName, c);

        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0;
        panel.add(new JALabel("Superclass Full Path"), c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1;
        panel.add(classSuperclassFullName, c);

        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0;
        panel.add(new JALabel("Display"), c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1;
        panel.add(classDisplayClass, c);

        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0;
        panel.add(classHidden, c);

        c.gridy = 5;
        panel.add(classSkipDeclarations, c);

        c.gridy = 6;
        panel.add(classDesignBorders, c);

        c.gridy = 7;
        panel.add(classSkipDefaultListeners, c);

        c.gridx = 0;
        c.gridy = 8;
        panel.add(new JALabel("Container Type"), c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1;
        panel.add(classContainerType, c);

        c.gridx = 0;
        c.gridy = 9;
        c.gridwidth = 1;
        c.weightx = 0;
        panel.add(new JALabel("Custom"), c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1;
        panel.add(classCustom, c);

        c.gridx = 0;
        c.gridy = 10;
        c.gridwidth = 1;
        c.weightx = 0;
        panel.add(new JALabel("Class factory"), c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1;
        panel.add(classClassFactory, c);

        c.gridx = 0;
        c.gridy = 11;
        c.gridwidth = 1;
        c.weightx = 0;
        panel.add(new JALabel("Design Editor"), c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1;
        panel.add(classDesignEditor, c);
        add(panel, BorderLayout.NORTH);
    }

    private void populateDisplay() {
        classFullName.setText(theClass.getMetadata().sFullClassName);
        classSuperclassName.setText(theClass.getMetadata().getSuperClassName());
        classSuperclassFullName.setText(theClass.getMetadata().getFullPathOfSuperClass());
        classDisplayClass.selectDisplayClass(theClass.getMetadata().sDisplayClass);
        classHidden.setSelected(theClass.getMetadata().bHidden);
        classSkipDeclarations.setSelected(theClass.getMetadata().bSkipDecl);
        classDesignBorders.setSelected(theClass.getMetadata().bDesignBorders);
        classSkipDefaultListeners.setSelected(theClass.getMetadata().bDefaultListeners);
        classContainerType.selectContainerType(theClass.getMetadata().containerType.getContainerTypeAsString());
        classCustom.selectCustom(theClass.getMetadata().sCustomCodeGenerationMethod);
        classClassFactory.selectFactoryClass(theClass.getMetadata().theFactoryName);
        classDesignEditor.selectDesignEditorClass(theClass.getMetadata().theDesignEditor);
    }

    void commitAttributes() {
        theClass.getMetadata().sFullClassName = classFullName.getText();
        theClass.getMetadata().setSuperClassName(classSuperclassName.getText());
        theClass.getMetadata().setFullPathOfSuperClass(classSuperclassFullName.getText());
        theClass.getMetadata().sDisplayClass = (String)classDisplayClass.getSelectedItem();
        theClass.getMetadata().bHidden = classHidden.isSelected();
        theClass.getMetadata().bSkipDecl = classSkipDeclarations.isSelected();
        theClass.getMetadata().bDesignBorders = classDesignBorders.isSelected();
        theClass.getMetadata().bDefaultListeners = classSkipDefaultListeners.isSelected();
        theClass.getMetadata().containerType.setContainerType((String)classContainerType.getSelectedItem());
        theClass.getMetadata().sCustomCodeGenerationMethod = (String)classCustom.getSelectedItem();
        theClass.getMetadata().theFactoryName = (String)classClassFactory.getSelectedItem();
        theClass.getMetadata().theDesignEditor = (String)classDesignEditor.getSelectedItem();
    }

    private void createLists() {
        ArrayList classes = new ArrayList();
        MetaClass firstClass = theDialog.theEditor.theMetadataDispenser.getFirstClass();
        enumerateClasses(firstClass, classes);
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            MetaClass metaClass = (MetaClass) iterator.next();

            String sDisplayClass = metaClass.getMetadata().sDisplayClass;
            if (sDisplayClass != null && !sDisplayClass.equals(""))
                theDisplayClasses.add(sDisplayClass);

            String sCustom = metaClass.getMetadata().sCustomCodeGenerationMethod;
            if (sCustom != null && !sCustom.equals(""))
                theCustom.add(sCustom);

            String sClassFactoryClasses = metaClass.getMetadata().theFactoryName;
            if (sClassFactoryClasses != null && !sClassFactoryClasses.equals(""))
                theClassFactoryClasses.add(sClassFactoryClasses);

            String sDesignEditorClasses = metaClass.getMetadata().theDesignEditor;
            if (sDesignEditorClasses != null && !sDesignEditorClasses.equals(""))
                theDesignEditorClasses.add(sClassFactoryClasses);

        }
    }

    void enumerateClasses(MetaClass theFirstClass, ArrayList classes) {
        MetaClass currClass = theFirstClass;
        while (currClass != null) {
            classes.add(currClass);
            if (currClass.getFirstClass() != null)
                enumerateClasses(currClass.getFirstClass(), classes);
            currClass = currClass.getNextSibling();
        }
    }


    class ContainerTypes extends JAComboBox {
        public ContainerTypes() {
            super(new String[] {"", "frame", "panel", "hsplit", "vsplit", "tabbedpane", "tabpage", "scrollingpanel", "group"});
            //setEditable(true);
        }

        public void selectContainerType(String sContainerType) {
            setSelectedItem(sContainerType);
        }
    }

    class DisplayClasses extends JAComboBox {
        public DisplayClasses() {
            super(theDisplayClasses.toArray());
            setEditable(true);
        }

        public void selectDisplayClass(String sClass) {
            setSelectedItem(sClass);
        }
    }

    class Custom extends JAComboBox {
        public Custom() {
            super(theCustom.toArray());
            setEditable(true);
        }

        public void selectCustom(String sCustom) {
            setSelectedItem(sCustom);
        }
    }

    class ClassFactoryClasses extends JAComboBox {
        public ClassFactoryClasses() {
            super(theClassFactoryClasses.toArray());
            setEditable(true);
        }

        public void selectFactoryClass(String sClass) {
            setSelectedItem(sClass);
        }
    }

    class DesignEditorClasses extends JAComboBox {
        public DesignEditorClasses() {
            super(theDesignEditorClasses.toArray());
            setEditable(true);
        }

        public void selectDesignEditorClass(String sClass) {
            setSelectedItem(sClass);
        }
    }










}
