/**
 * Title:        Comedia Beans
 * Description:  Calculator Bean
 * Copyright:    Copyright (c) 2001
 * Company:      Capella Development Group
 * @author Sergey Seroukhov
 * @version 1.0
 */

package org.comedia.beans;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

/**
 * Visual bean which presents standart windows calculator.
 * This bean can be resized to fits the draw rectangle.
 * Calculator supports mouse and keyboard interaction.
 * <p>
 * <center><img src="CCalculator.gif"></center>
 */
public class CCalculator extends JComponent implements ActionListener, KeyListener {
  Border border1;
  JPanel stubPanel = new JPanel();
  JButton sqrtButton = new JButton();
  JButton eightButton = new JButton();
  JButton cButton = new JButton();
  JButton equalButton = new JButton();
  JPanel controlPanel = new JPanel();
  JPanel memPanel = new JPanel();
  JButton addButton = new JButton();
  JButton subButton = new JButton();
  JButton fiveButton = new JButton();
  JPanel numPanel = new JPanel();
  JButton nineButton = new JButton();
  JButton sixButton = new JButton();
  JButton backspaceButton = new JButton();
  JPanel commonPanel = new JPanel();
  JButton dotButton = new JButton();
  JButton zeroButton = new JButton();
  JButton invButton = new JButton();
  JButton sevenButton = new JButton();
  JButton procButton = new JButton();
  JButton mcButton = new JButton();
  JButton mpButton = new JButton();
  JButton msButton = new JButton();
  JButton mrButton = new JButton();
  JButton mulButton = new JButton();
  JPanel buttonPanel = new JPanel();
  BorderLayout borderLayout3 = new BorderLayout();
  JPanel subctrlPanel = new JPanel();
  BorderLayout borderLayout2 = new BorderLayout();
  JButton forthButton = new JButton();
  BorderLayout borderLayout1 = new BorderLayout();
  JButton threeButton = new JButton();
  JButton twoButton = new JButton();
  JButton negButton = new JButton();
  JButton ceButton = new JButton();
  JTextField indicatorText = new JTextField();
  JButton divButton = new JButton();
  GridLayout gridLayout3 = new GridLayout();
  GridLayout gridLayout2 = new GridLayout();
  GridLayout gridLayout1 = new GridLayout();
  JButton oneButton = new JButton();
  BorderLayout borderLayout4 = new BorderLayout();
  Border border2;
  JLabel memoryLabel = new JLabel();
  BorderLayout borderLayout5 = new BorderLayout();

  /**
   * Default calculator constructor.
   */
  public CCalculator() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * Constracts User Interface of the bean.
   * Used by JBuilder designers.
   */
  private void jbInit() throws Exception {
    border2 = BorderFactory.createEmptyBorder(12,12,12,12);
    oneButton.setText("1");
    oneButton.setActionCommand("One");
    oneButton.setMargin(new Insets(0, 0, 0, 0));
    oneButton.setMinimumSize(new Dimension(0, 0));
    oneButton.setNextFocusableComponent(zeroButton);
    oneButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    oneButton.setForeground(Color.blue);
    oneButton.setMaximumSize(new Dimension(255, 255));
    gridLayout1.setVgap(5);
    gridLayout1.setHgap(5);
    gridLayout1.setColumns(1);
    gridLayout1.setRows(4);
    gridLayout2.setVgap(5);
    gridLayout2.setHgap(5);
    gridLayout2.setColumns(5);
    gridLayout2.setRows(4);
    gridLayout3.setVgap(5);
    gridLayout3.setHgap(5);
    gridLayout3.setColumns(3);
    divButton.setText("/");
    divButton.setActionCommand("Div");
    divButton.setMargin(new Insets(0, 0, 0, 0));
    divButton.setMinimumSize(new Dimension(0, 0));
    divButton.setNextFocusableComponent(mulButton);
    divButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    divButton.setForeground(Color.red);
    divButton.setMaximumSize(new Dimension(255, 255));
    indicatorText.setHorizontalAlignment(SwingConstants.RIGHT);
    indicatorText.setRequestFocusEnabled(false);
    indicatorText.setToolTipText("");
    indicatorText.setEditable(false);
    indicatorText.setText("0.");
    ceButton.setText("CE");
    ceButton.setActionCommand("CE");
    ceButton.setMargin(new Insets(0, 0, 0, 0));
    ceButton.setMinimumSize(new Dimension(0, 0));
    ceButton.setNextFocusableComponent(cButton);
    ceButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    ceButton.setForeground(Color.red);
    ceButton.setMaximumSize(new Dimension(255, 255));
    negButton.setText("+/-");
    negButton.setActionCommand("Neg");
    negButton.setMargin(new Insets(0, 0, 0, 0));
    negButton.setMinimumSize(new Dimension(0, 0));
    negButton.setNextFocusableComponent(nineButton);
    negButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    negButton.setForeground(Color.blue);
    negButton.setMaximumSize(new Dimension(255, 255));
    twoButton.setText("2");
    twoButton.setActionCommand("Two");
    twoButton.setMargin(new Insets(0, 0, 0, 0));
    twoButton.setMinimumSize(new Dimension(0, 0));
    twoButton.setNextFocusableComponent(negButton);
    twoButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    twoButton.setForeground(Color.blue);
    twoButton.setMaximumSize(new Dimension(255, 255));
    threeButton.setText("3");
    threeButton.setActionCommand("Three");
    threeButton.setMargin(new Insets(0, 0, 0, 0));
    threeButton.setMinimumSize(new Dimension(0, 0));
    threeButton.setNextFocusableComponent(dotButton);
    threeButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    threeButton.setForeground(Color.blue);
    threeButton.setMaximumSize(new Dimension(255, 255));
    borderLayout1.setVgap(11);
    forthButton.setText("4");
    forthButton.setActionCommand("Forth");
    forthButton.setMargin(new Insets(0, 0, 0, 0));
    forthButton.setMinimumSize(new Dimension(0, 0));
    forthButton.setNextFocusableComponent(oneButton);
    forthButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    forthButton.setForeground(Color.blue);
    forthButton.setMaximumSize(new Dimension(255, 255));
    borderLayout2.setVgap(11);
    borderLayout2.setHgap(11);
    subctrlPanel.setOpaque(false);
    subctrlPanel.setLayout(borderLayout3);
    borderLayout3.setVgap(12);
    borderLayout3.setHgap(12);
    buttonPanel.setOpaque(false);
    buttonPanel.setLayout(borderLayout2);
    mulButton.setText("*");
    mulButton.setActionCommand("Mul");
    mulButton.setMargin(new Insets(0, 0, 0, 0));
    mulButton.setMinimumSize(new Dimension(0, 0));
    mulButton.setNextFocusableComponent(subButton);
    mulButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    mulButton.setForeground(Color.red);
    mulButton.setMaximumSize(new Dimension(255, 255));
    mrButton.setText("MR");
    mrButton.setActionCommand("MR");
    mrButton.setMargin(new Insets(0, 0, 0, 0));
    mrButton.setPreferredSize(new Dimension(34, 25));
    mrButton.setMinimumSize(new Dimension(0, 0));
    mrButton.setNextFocusableComponent(msButton);
    mrButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    mrButton.setForeground(Color.red);
    mrButton.setMaximumSize(new Dimension(255, 255));
    msButton.setText("MS");
    msButton.setActionCommand("MS");
    msButton.setMargin(new Insets(0, 0, 0, 0));
    msButton.setPreferredSize(new Dimension(34, 25));
    msButton.setMinimumSize(new Dimension(0, 0));
    msButton.setNextFocusableComponent(mpButton);
    msButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    msButton.setForeground(Color.red);
    msButton.setMaximumSize(new Dimension(255, 255));
    mpButton.setText("M+");
    mpButton.setPreferredSize(new Dimension(34, 25));
    mpButton.setMargin(new Insets(0, 0, 0, 0));
    mpButton.setMinimumSize(new Dimension(0, 0));
    mpButton.setNextFocusableComponent(sevenButton);
    mpButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    mpButton.setForeground(Color.red);
    mpButton.setMaximumSize(new Dimension(255, 255));
    mcButton.setText("MC");
    mcButton.setActionCommand("MC");
    mcButton.setMargin(new Insets(0, 0, 0, 0));
    mcButton.setPreferredSize(new Dimension(34, 25));
    mcButton.setMinimumSize(new Dimension(0, 0));
    mcButton.setNextFocusableComponent(mrButton);
    mcButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    mcButton.setForeground(Color.red);
    mcButton.setMaximumSize(new Dimension(255, 255));
    procButton.setText("%");
    procButton.setActionCommand("Proc");
    procButton.setMargin(new Insets(0, 0, 0, 0));
    procButton.setMinimumSize(new Dimension(0, 0));
    procButton.setNextFocusableComponent(invButton);
    procButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    procButton.setForeground(Color.blue);
    procButton.setMaximumSize(new Dimension(255, 255));
    sevenButton.setText("7");
    sevenButton.setActionCommand("Seven");
    sevenButton.setMargin(new Insets(0, 0, 0, 0));
    sevenButton.setToolTipText("");
    sevenButton.setMinimumSize(new Dimension(0, 0));
    sevenButton.setNextFocusableComponent(forthButton);
    sevenButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    sevenButton.setForeground(Color.blue);
    sevenButton.setMaximumSize(new Dimension(255, 255));
    invButton.setText("1/x");
    invButton.setActionCommand("Inv");
    invButton.setMargin(new Insets(0, 0, 0, 0));
    invButton.setMinimumSize(new Dimension(0, 0));
    invButton.setNextFocusableComponent(equalButton);
    invButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    invButton.setForeground(Color.blue);
    invButton.setMaximumSize(new Dimension(255, 255));
    zeroButton.setText("0");
    zeroButton.setActionCommand("Zero");
    zeroButton.setMargin(new Insets(0, 0, 0, 0));
    zeroButton.setMinimumSize(new Dimension(0, 0));
    zeroButton.setNextFocusableComponent(eightButton);
    zeroButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    zeroButton.setForeground(Color.blue);
    zeroButton.setMaximumSize(new Dimension(255, 255));
    dotButton.setText(".");
    dotButton.setActionCommand("Dot");
    dotButton.setMargin(new Insets(0, 0, 0, 0));
    dotButton.setMinimumSize(new Dimension(0, 0));
    dotButton.setNextFocusableComponent(divButton);
    dotButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    dotButton.setForeground(Color.blue);
    dotButton.setMaximumSize(new Dimension(255, 255));
    commonPanel.setDoubleBuffered(true);
    border1 = BorderFactory.createEmptyBorder(12,12,12,12);
    commonPanel.setBorder(border1);
    commonPanel.setLayout(borderLayout1);
    backspaceButton.setText("Backspace");
    backspaceButton.setActionCommand("Backspace");
    backspaceButton.setMargin(new Insets(0, 0, 0, 0));
    backspaceButton.setMinimumSize(new Dimension(0, 0));
    backspaceButton.setNextFocusableComponent(ceButton);
    backspaceButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    backspaceButton.setForeground(Color.red);
    backspaceButton.setMaximumSize(new Dimension(255, 255));
    sixButton.setText("6");
    sixButton.setActionCommand("Six");
    sixButton.setMargin(new Insets(0, 0, 0, 0));
    sixButton.setMinimumSize(new Dimension(0, 0));
    sixButton.setNextFocusableComponent(threeButton);
    sixButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    sixButton.setForeground(Color.blue);
    sixButton.setMaximumSize(new Dimension(255, 255));
    nineButton.setText("9");
    nineButton.setActionCommand("Nine");
    nineButton.setMargin(new Insets(0, 0, 0, 0));
    nineButton.setMinimumSize(new Dimension(0, 0));
    nineButton.setNextFocusableComponent(sixButton);
    nineButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    nineButton.setForeground(Color.blue);
    nineButton.setMaximumSize(new Dimension(255, 255));
    numPanel.setOpaque(false);
    numPanel.setLayout(gridLayout2);
    fiveButton.setText("5");
    fiveButton.setActionCommand("Five");
    fiveButton.setMargin(new Insets(0, 0, 0, 0));
    fiveButton.setMinimumSize(new Dimension(0, 0));
    fiveButton.setNextFocusableComponent(twoButton);
    fiveButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    fiveButton.setForeground(Color.blue);
    fiveButton.setMaximumSize(new Dimension(255, 255));
    subButton.setText("-");
    subButton.setActionCommand("Sub");
    subButton.setMargin(new Insets(0, 0, 0, 0));
    subButton.setMinimumSize(new Dimension(0, 0));
    subButton.setNextFocusableComponent(addButton);
    subButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    subButton.setForeground(Color.red);
    subButton.setMaximumSize(new Dimension(255, 255));
    addButton.setText("+");
    addButton.setActionCommand("Add");
    addButton.setMargin(new Insets(0, 0, 0, 0));
    addButton.setMinimumSize(new Dimension(0, 0));
    addButton.setNextFocusableComponent(sqrtButton);
    addButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    addButton.setForeground(Color.red);
    addButton.setMaximumSize(new Dimension(255, 255));
    memPanel.setOpaque(false);
    memPanel.setLayout(gridLayout1);
    controlPanel.setOpaque(false);
    controlPanel.setLayout(gridLayout3);
    equalButton.setText("=");
    equalButton.setActionCommand("Equal");
    equalButton.setMargin(new Insets(0, 0, 0, 0));
    equalButton.setMinimumSize(new Dimension(0, 0));
    equalButton.setNextFocusableComponent(backspaceButton);
    equalButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    equalButton.setForeground(Color.red);
    equalButton.setMaximumSize(new Dimension(255, 255));
    cButton.setText("C");
    cButton.setMinimumSize(new Dimension(0, 0));
    cButton.setNextFocusableComponent(mcButton);
    cButton.setMargin(new Insets(0, 0, 0, 0));
    cButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    cButton.setForeground(Color.red);
    cButton.setMaximumSize(new Dimension(255, 255));
    eightButton.setText("8");
    eightButton.setActionCommand("Eight");
    eightButton.setMargin(new Insets(0, 0, 0, 0));
    eightButton.setMinimumSize(new Dimension(0, 0));
    eightButton.setNextFocusableComponent(fiveButton);
    eightButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    eightButton.setForeground(Color.blue);
    eightButton.setMaximumSize(new Dimension(255, 255));
    sqrtButton.setText("sqrt");
    sqrtButton.setActionCommand("Sqrt");
    sqrtButton.setMargin(new Insets(0, 0, 0, 0));
    sqrtButton.setMinimumSize(new Dimension(0, 0));
    sqrtButton.setNextFocusableComponent(procButton);
    sqrtButton.setFont(new java.awt.Font("SansSerif", 0, 12));
    sqrtButton.setForeground(Color.blue);
    sqrtButton.setMaximumSize(new Dimension(255, 255));
    stubPanel.setPreferredSize(new Dimension(34, 25));
    stubPanel.setLayout(borderLayout5);
    stubPanel.setMinimumSize(new Dimension(0, 0));
    stubPanel.setMaximumSize(new Dimension(255, 255));
    stubPanel.setAlignmentX((float) 0.0);
    stubPanel.setAlignmentY((float) 0.0);
    stubPanel.setBorder(BorderFactory.createLoweredBevelBorder());
    this.setLayout(borderLayout4);
    memoryLabel.setFont(new java.awt.Font("SansSerif", 0, 12));
    memoryLabel.setHorizontalAlignment(SwingConstants.CENTER);
    memoryLabel.setText(" ");
    this.setNextFocusableComponent(backspaceButton);
    commonPanel.add(indicatorText, BorderLayout.NORTH);
    commonPanel.add(buttonPanel, BorderLayout.CENTER);
    subctrlPanel.add(stubPanel, BorderLayout.WEST);
    stubPanel.add(memoryLabel, BorderLayout.CENTER);
    subctrlPanel.add(controlPanel, BorderLayout.CENTER);
    controlPanel.add(backspaceButton, null);
    controlPanel.add(ceButton, null);
    controlPanel.add(cButton, null);
    buttonPanel.add(numPanel, BorderLayout.CENTER);
    memPanel.add(mcButton, null);
    memPanel.add(mrButton, null);
    memPanel.add(msButton, null);
    memPanel.add(mpButton, null);
    buttonPanel.add(subctrlPanel, BorderLayout.NORTH);
    buttonPanel.add(memPanel, BorderLayout.WEST);
    numPanel.add(sevenButton, null);
    numPanel.add(eightButton, null);
    numPanel.add(nineButton, null);
    numPanel.add(divButton, null);
    numPanel.add(sqrtButton, null);
    numPanel.add(forthButton, null);
    numPanel.add(fiveButton, null);
    numPanel.add(sixButton, null);
    numPanel.add(mulButton, null);
    numPanel.add(procButton, null);
    numPanel.add(oneButton, null);
    numPanel.add(twoButton, null);
    numPanel.add(threeButton, null);
    numPanel.add(subButton, null);
    numPanel.add(invButton, null);
    numPanel.add(zeroButton, null);
    numPanel.add(negButton, null);
    numPanel.add(dotButton, null);
    numPanel.add(addButton, null);
    numPanel.add(equalButton, null);
    this.add(commonPanel, BorderLayout.CENTER);

    indicatorText.addKeyListener(this);
    addButtonsListener(controlPanel);
    addButtonsListener(memPanel);
    addButtonsListener(numPanel);
  }

  /**
   * Copies value from indicator to clipboard.
   */
  public void copy() {
    indicatorText.copy();
  }

  /**
   * Pastes value from clipboard to indicator.
   * If value can not be converted into double value it pastes zero instead.
   */
  public void paste() {
    if (error) return;
    try {
      indicatorText.paste();
      Double temp = new Double(indicatorText.getText());
      setValue(temp.doubleValue());
    }
    catch (Exception e) {
      setValue(0);
    }
    update = true;
  }

  /**
   * Sets an equal width to all buttons at the panel.
   * @param panel panel which contains buttons.
   * @param width the width value for buttons.
   */
  private void setButtonsWidth(Container panel, int width) {
    for (int i=0; i<panel.getComponentCount(); i++) {
      Component component = panel.getComponent(i);
      if (component instanceof JButton) {
        JButton button = (JButton) component;
        Dimension d = button.getPreferredSize();
        d.width = width;
        button.setPreferredSize(d);
      }
    }
  }

  /**
   * Sets an equal height to all buttons at the panel.
   * @param panel panel which contains buttons.
   * @param height the height value for buttons.
   */
  private void setButtonsHeight(Container panel, int height) {
    for (int i=0; i<panel.getComponentCount(); i++) {
      Component component = panel.getComponent(i);
      if (component instanceof JButton) {
        JButton button = (JButton) component;
        Dimension d = button.getPreferredSize();
        d.height = height;
        button.setPreferredSize(d);
      }
    }
  }

  /**
   * Assigns listeners to all buttons at the panel.
   * @param panel panel which contains buttons.
   */
  private void addButtonsListener(Container panel) {
    for (int i=0; i<panel.getComponentCount(); i++) {
      Component component = panel.getComponent(i);
      if (component instanceof JButton) {
        JButton button = (JButton) component;
        button.addActionListener(this);
        button.addKeyListener(this);
      }
    }
  }

  /**
   * Changes current layout of this component.
   * Equals with and heights of buttons.
   */
  public void doLayout() {
    int width = (this.getSize().width - 60) / 6;
    int height = (this.getSize().height - 75) / 5;
    // Change preffered size of me buttons
    setButtonsWidth(memPanel, width);
    setButtonsHeight(memPanel, height);
    memPanel.validate();
    // Change preffered size of num buttons
    setButtonsWidth(numPanel, width);
    setButtonsHeight(numPanel, height);
    numPanel.validate();
    // Change preffered size of control buttons
    setButtonsHeight(controlPanel, height);
    controlPanel.validate();
    // Change preffered size of stub panel
    Dimension d = stubPanel.getPreferredSize();
    d.width = width;
    d.height = height;
    stubPanel.setPreferredSize(d);
    // Do layout
    super.doLayout();
    this.repaint();
    if (first) {
      first = false;
      backspaceButton.requestFocus();
    }
  }

  final private int UNKNOWN = 0;
  final private int ADD = 1;
  final private int SUB = 2;
  final private int MUL = 3;
  final private int DIV = 4;
  final private int OTHER = 5;

  private boolean first = true;
  private boolean minus = false;
  private boolean comma = false;
  private String value = "0";
  private boolean error = false;
  private boolean stored = false;
  private double memory = 0;
  private double buffer = 0;
  private int operation = UNKNOWN;
  private boolean update = false;
  private boolean newop = true;
  private double oldvalue = 0;

  /**
   * Adds the digit to the indicator text editor.
   * @param digit new digit to the number.
   */
  private void addDigit(char digit) {
    if (digit == '0' && value.equals("0")) return;
    if (value.equals("0")) value = "";
    if (update) {
      value = "";
      minus = false;
      comma = false;
    }
    update = false;
    value += digit;
    showValue();
  }

  /**
   * Adds a dot to the current value.
   */
  private void addDot() {
    if (!comma) {
      comma = true;
      value += '.';
      showValue();
    }
  }

  /**
   * Shows current value at the indicator text editor.
   */
  private void showValue() {
    String text;
    if (minus) text = '-' + value;
    else text = value;
    if (!comma) text += '.';
    indicatorText.setText(text);
  }

  /**
   * Gets teh current indicator value.
   */
  private double getValue() {
    try {
      Double temp = new Double(indicatorText.getText());
      return temp.doubleValue();
    }
    catch (Exception e) {
      return 0;
    }
  }

  /**
   * Sets the current value at the indicator.
   * @param value the new indicator value.
   */
  private void setValue(double value) {
    if (value < 0) {
      minus = true;
      value = -value;
    }
    Double temp = new Double(value);
    this.value = temp.toString();
    if (this.value.endsWith(".0"))
      this.value = this.value.substring(0, this.value.length()-2);
    comma = (this.value.indexOf('.') >= 0);
    showValue();
  }

  /**
   * Calculates the current operation.
   * @param operator specify the arifmetic operation.
   * @param value the second operand value.
   */
  private void performOperation(int operation, double value) {
    switch (operation) {
      case ADD:
        setValue(buffer + value);
        break;
      case SUB:
        setValue(buffer - value);
        break;
      case MUL:
        setValue(buffer * value);
        break;
      case DIV:
        if (value == 0) {
          indicatorText.setText("Can not divide by zero.");
          error = true;
        } else
          setValue(buffer / value);
        break;
      case UNKNOWN:
        return;
    }
    buffer = getValue();
    update = true;
    newop = false;
  }

  /**
   * Shows memory status at the panel.
   */
  private void showMemory() {
    if (stored) memoryLabel.setText("M");
    else memoryLabel.setText(" ");
  }

  /**
   * Performs actions from user interface.
   * @param e description of the action.
   */
  public void actionPerformed(ActionEvent e) {
    String cmd = e.getActionCommand();
    if (error && !cmd.equals("C") && !cmd.equals("CE"))
      return;

    if (cmd.equals("Zero")) addDigit('0');
    else if (cmd.equals("One")) addDigit('1');
    else if (cmd.equals("Two")) addDigit('2');
    else if (cmd.equals("Three")) addDigit('3');
    else if (cmd.equals("Forth")) addDigit('4');
    else if (cmd.equals("Five")) addDigit('5');
    else if (cmd.equals("Six")) addDigit('6');
    else if (cmd.equals("Seven")) addDigit('7');
    else if (cmd.equals("Eight")) addDigit('8');
    else if (cmd.equals("Nine")) addDigit('9');
    else if (cmd.equals("Dot")) addDot();
    else if (cmd.equals("Neg")) {
      minus = !minus;
      showValue();
    } else if (cmd.equals("Inv")) {
      double value = getValue();
      if (value == 0) {
        indicatorText.setText("Can not divide by zero.");
        error = true;
      } else
        setValue(1/value);
      update = true;
    } else if (cmd.equals("Sqrt")) {
      double value = getValue();
      if (value < 0) {
        indicatorText.setText("Invalid input for function.");
        error = true;
      } else
        setValue(Math.sqrt(value));
      update = true;
    } else if (cmd.equals("Backspace") && !update) {
      value = value.substring(0, value.length()-1);
      if (value.length() == 0) {
        value = "0";
        minus = false;
      }
      comma = (value.indexOf('.') >= 0);
      showValue();
    } else if (cmd.equals("C")) {
      error = false;
      memory = 0;
      buffer = 0;
      stored = false;
      operation = UNKNOWN;
      setValue(0);
      update = false;
      minus = false;
      comma = false;
      newop = true;
      showMemory();
    } else if (cmd.equals("CE")) {
      error = false;
      buffer = 0;
      operation = UNKNOWN;
      setValue(0);
      update = false;
      minus = false;
      comma = false;
      newop = true;
    } else if (cmd.equals("Add")) {
      if (newop) performOperation(operation, getValue());
      buffer = getValue();
      operation = ADD;
      update = true;
      newop = true;
    } else if (cmd.equals("Sub")) {
      if (newop) performOperation(operation, getValue());
      buffer = getValue();
      operation = SUB;
      update = true;
      newop = true;
    } else if (cmd.equals("Mul")) {
      if (newop) performOperation(operation, getValue());
      buffer = getValue();
      operation = MUL;
      update = true;
      newop = true;
    } else if (cmd.equals("Div")) {
      if (newop) performOperation(operation, getValue());
      buffer = getValue();
      operation = DIV;
      update = true;
      newop = true;
    } else if (cmd.equals("Equal")) {
      if (newop) oldvalue = getValue();
      performOperation(operation, oldvalue);
    } else if (cmd.equals("MS")) {
      stored = true;
      memory = getValue();
      showMemory();
      update = true;
    } else if (cmd.equals("M+")) {
      stored = true;
      memory += getValue();
      showMemory();
      update = true;
    } else if (cmd.equals("MC")) {
      stored = false;
      memory = 0;
      showMemory();
    } else if (cmd.equals("MR")) {
      if (!stored) setValue(0);
      else setValue(memory);
      update = true;
    }
  }

  /**
   * Performs char typed event.
   * @param e the event description.
   */
  public void keyTyped(KeyEvent e) {
    char key = e.getKeyChar();
    final int delay = 100;
    if (key == '0') {
      zeroButton.requestFocus();
      zeroButton.doClick(delay);
    } else if (key == '1') {
      oneButton.requestFocus();
      oneButton.doClick(delay);
    } else if (key == '2') {
      twoButton.requestFocus();
      twoButton.doClick(delay);
    } else if (key == '3') {
      threeButton.requestFocus();
      threeButton.doClick(delay);
    } else if (key == '4') {
      forthButton.requestFocus();
      forthButton.doClick(delay);
    } else if (key == '5') {
      fiveButton.requestFocus();
      fiveButton.doClick(delay);
    } else if (key == '6') {
      sixButton.requestFocus();
      sixButton.doClick(delay);
    } else if (key == '7') {
      sevenButton.requestFocus();
      sevenButton.doClick(delay);
    } else if (key == '8') {
      eightButton.requestFocus();
      eightButton.doClick(delay);
    } else if (key == '9') {
      nineButton.requestFocus();
      oneButton.doClick(delay);
    } else if (key == '+') {
      addButton.requestFocus();
      addButton.doClick(delay);
    } else if (key == '-') {
      subButton.requestFocus();
      subButton.doClick(delay);
    } else if (key == '*') {
      mulButton.requestFocus();
      mulButton.doClick(delay);
    } else if (key == '/') {
      divButton.requestFocus();
      divButton.doClick(delay);
    } else if (key == '%') {
      procButton.requestFocus();
      procButton.doClick(delay);
    } else if (key == 'c' || key == 'C') {
      cButton.requestFocus();
      cButton.doClick(delay);
    } else if (key == '.' || key == ',') {
      dotButton.requestFocus();
      dotButton.doClick(delay);
    } else if (key == '\n' || key == '=') {
      equalButton.requestFocus();
      equalButton.doClick(delay);
    } else if (key == '\b') {
      backspaceButton.requestFocus();
      backspaceButton.doClick(delay);
    }
  }

  /**
   * Performs key pressed event.
   * @param e the event description.
   */
  public void keyPressed(KeyEvent e) {
  }

  /**
   * Performs button released event.
   * @param e the event description.
   */
  public void keyReleased(KeyEvent e) {
  }


  /**
   * Shows this bean in separate application frame on the screen.
   * It allows to use this bean as stand along application.
   */
  public static void main(String[] args) {
    try {
//      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
      UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
    }
    catch(Exception e) {}

    CCalculator calculator = new CCalculator();
    JFrame frame = new JFrame("Calculator");
    frame.setContentPane(calculator);
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.setSize(300, 300);
    frame.setLocation(300, 300);
    frame.show();
  }
}