/**
 * Title:        Comedia Beans
 * Copyright:    Copyright (c) 2001
 * Company:      Capella Development Group
 * @author Sergey Seroukhov
 * @version 1.0
 */

package org.comedia.text;

import org.comedia.util.scanner.*;

/**
 * Extends the CAbstractHighlighter to process Java source files.
 */
public class CJavaHighlighter extends CAbstractHighlighter {

  /**
   * Constract this class with default properties.
   */
  public CJavaHighlighter() {
    super();
    scanner = new CJavaScanner();
    scanner.setShowComment(true);
    scanner.setShowEol(true);
    scanner.setShowString(true);
    scanner.setShowKeyword(true);
    scanner.setShowType(true);
    scanner.setShowSpace(true);
  }

  /**
   * Locates a last unclosed multiline comment before specified position.
   * @param text the text to search in.
   * @param pos the last position
   * @result a position of last unclosed comment or -1 otherwise.
   */
  public int locateUnclosedComment(String text, int pos) {
    return locateUnclosedComment(text, pos, "/*", "*/");
  }

  /**
   * Check if current is a multiline comment.
   * @result <code>TRUE</code> if current token is a multiline comment
   * and <code>FALSE</code> otherwise.
   */
  public boolean isMultilineComment() {
    return scanner.getToken().startsWith("/*")
      && scanner.getTokenType() == scanner.COMMENT;
  }

}