/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * JAMenu.java  
 *
 * Creator:
 * 04.12.2003 10:48:25 Lauchenauer
 *
 * Maintainer:
 * 04.12.2003 10:48:25 Lauchenauer
 *
 * Last Modification:
 * $Id: JAMenu.java,v 1.1 2005/10/13 16:09:50 agraham Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.lib.ui;

import java.awt.Component;
import java.awt.event.FocusListener;

import javax.swing.JMenu;
import javax.swing.Action;


public class JAMenu extends JMenu {
  /**
   * Constructs a new <code>JMenu</code> with no text.
   */
  public JAMenu() {
    init();
  }

  /**
   * Constructs a new <code>JMenu</code> with the supplied string
   * as its text.
   *
   * @param s  the text for the menu label
   */
  public JAMenu(String s) {
    super(s);
    init();
  }

  /**
   * Constructs a menu whose properties are taken from the
   * <code>Action</code> supplied.
   * @param a an <code>Action</code>
   *
   * @since 1.3
   */
  public JAMenu(Action a) {
    super(a);
    init();
  }

  /**
   * Constructs a new <code>JMenu</code> with the supplied string as
   * its text and specified as a tear-off menu or not.
   *
   * @param s the text for the menu label
   * @param b can the menu be torn off (not yet implemented)
   */
  public JAMenu(String s, boolean b) {
    super(s, b);
    init();
  }

  /**
   * internal initialization of the validation events stuff
   */
  private void init() {
    //super.addFocusListener(getDispatcher());
    setFocusable(false);
  }
}