/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import java.awt.Component;
import java.awt.event.ContainerListener;
import java.awt.event.ContainerEvent;

import javax.swing.JSplitPane;

import ch.abacus.lib.ui.vorgaben.ApplicationSettingsInterface;

/**
 * this class...
 * Created on 22.08.2002
 * @author Lauchenauer
 * Copyright (c) 2001-2002 ABACUS Research AG All Rights Reserved.
 */
public class JASplitPane extends JSplitPane implements ApplicationSettingsInterface
 {
  /**
   * The setting name for the frame
   */
  protected String mSettingName;

  /**
   * Constructor for the Splitpane
   * 
   * @see javax.swing.JSplitPane#JSplitPane()
   */
  public JASplitPane() {
    super();
    init();
  }

  /**
   * Constructor for JASplitPane
   * .
   * @param newOrientation  <code>JSplitPane.HORIZONTAL_SPLIT</code> or
   *                        <code>JSplitPane.VERTICAL_SPLIT</code>
   * @exception IllegalArgumentException if <code>orientation</code>
   *    is not one of HORIZONTAL_SPLIT or VERTICAL_SPLIT.
   * 
   * @see javax.swing.JSplitPane#JSplitPane(int)
   */
  public JASplitPane(int newOrientation) {
    super(newOrientation);
    init();
  }

  /**
   * Constructor for JASplitPane.
   * 
   * @param newOrientation  <code>JSplitPane.HORIZONTAL_SPLIT</code> or
   *                        <code>JSplitPane.VERTICAL_SPLIT</code>
   * @param newContinuousLayout  a boolean, true for the components to 
   *        redraw continuously as the divider changes position, false
   *        to wait until the divider position stops changing to redraw
   * @exception IllegalArgumentException if <code>orientation</code>
   *    is not one of HORIZONTAL_SPLIT or VERTICAL_SPLIT
   * 
   * @see javax.swing.JSplitPane#JSplitPane(int, boolean)
   */
  public JASplitPane(int newOrientation, boolean newContinuousLayout) {
    super(newOrientation, newContinuousLayout);
    init();
  }

  /**
   * Constructor for JASplitPane.
   * 
   * @param newOrientation  <code>JSplitPane.HORIZONTAL_SPLIT</code> or
   * <code>JSplitPane.VERTICAL_SPLIT</code>
   * @param newLeftComponent the <code>Component</code> that will appear on the left
   *        	of a horizontally-split pane, or at the top of a
   *        	vertically-split pane
   * @param newRightComponent the <code>Component</code> that will appear on the right
   *        	of a horizontally-split pane, or at the bottom of a
   *        	vertically-split pane
   * @exception IllegalArgumentException if <code>orientation</code>
   *		is not one of: HORIZONTAL_SPLIT or VERTICAL_SPLIT
   *
   * @see javax.swing.JSplitPane#JSplitPane(int, Component, Component)
   */
  public JASplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
    super(newOrientation);
    init();
    setLeftComponent(newLeftComponent);
    setRightComponent(newRightComponent);
  }

  /**
   * Constructor for JASplitPane.
   * 
   * @param newOrientation  <code>JSplitPane.HORIZONTAL_SPLIT</code> or
   * <code>JSplitPane.VERTICAL_SPLIT</code>
   * @param newContinuousLayout  a boolean, true for the components to 
   *        redraw continuously as the divider changes position, false
   *        to wait until the divider position stops changing to redraw
   * @param newLeftComponent the <code>Component</code> that will
   *		appear on the left
   *        	of a horizontally-split pane, or at the top of a
   *        	vertically-split pane
   * @param newRightComponent the <code>Component</code> that will
   *		appear on the right
   *        	of a horizontally-split pane, or at the bottom of a
   *        	vertically-split pane
   * @exception IllegalArgumentException if <code>orientation</code>
   *		is not one of HORIZONTAL_SPLIT or VERTICAL_SPLIT
   *
   * @see javax.swing.JSplitPane#JSplitPane(int, boolean, Component, Component)
   */
  public JASplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
    super(newOrientation, newContinuousLayout);
    init();
    setLeftComponent(newLeftComponent);
    setRightComponent(newRightComponent);
  }

  protected void init()
  {
    /*
      required for the FocusTraversalPolicy associated with the Validation stuff
    */
  }

  /**
   * Returns the name used to identify the instance in the ApplicationSettings class.
   *
   * @return the Setting name of the instance of this object
   */
  public String getSettingName() {
    return mSettingName;
  }

  /**
   * Sets the name used to identify the instance in the ApplicationSettings class.
   *
   * @param newName the nwe Setting name for the instance of this object
   */
  public void setSettingName(String newName) {
    mSettingName = newName;
  }
  
//  public void setDividerLocation(int loc) {
//    System.out.println("setDividerLocation " + loc);
//    Throwable t = new Throwable();
//    t.printStackTrace(); 
//    super.setDividerLocation(loc);
//  }


}

