/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui;

import javax.swing.*;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import java.util.Hashtable;
import java.util.Vector;

public class JATree extends JTree
{
    /**
     * Constructor for JATree.
     */
    public JATree()
    {
        super();
    }

    /**
     * Constructor for JATree.
     *
     * @param value
     */
    public JATree(Object[] value)
    {
        super(value);
    }

    /**
     * Constructor for JATree.
     *
     * @param value
     */
    public JATree(Vector value)
    {
        super(value);
    }

    /**
     * Constructor for JATree.
     *
     * @param value
     */
    public JATree(Hashtable value)
    {
        super(value);
    }

    /**
     * Constructor for JATree.
     *
     * @param root
     */
    public JATree(TreeNode root)
    {
        super(root);
    }

    /**
     * Constructor for JATree.
     *
     * @param root
     * @param asksAllowsChildren
     */
    public JATree(TreeNode root, boolean asksAllowsChildren)
    {
        super(root, asksAllowsChildren);
    }

    /**
     * Constructor for JATree.
     *
     * @param newModel
     */
    public JATree(TreeModel newModel)
    {
        super(newModel);
    }

    public final void recursiveExpand(TreePath path, boolean expand)
    {
        if (expand) expandPath(path);
        TreeModel tm = getModel();
        Object parent = path.getLastPathComponent();
        for (int i = 0; i < tm.getChildCount(parent); i++)
        {
            Object o = tm.getChild(parent, i);
            if (!tm.isLeaf(o))
                recursiveExpand(path.pathByAddingChild(o), expand);
        }
        if (!expand) collapsePath(path);
    }

    public void expandAll()
    {
        recursiveExpand(new TreePath(getModel().getRoot()), true);
    }

    public void collapseAll()
    {
        recursiveExpand(new TreePath(getModel().getRoot()), false);
    }
}
