/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
2004  Abacus Research AG , St. Gallen , Switzerland .
 * All rights reserved. Terms of Use under The ABACUS RESEARCH AG PUBLIC LICENSE Version 1.0.
  THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package ch.abacus.lib.ui.layout;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class AnchoringLayoutManagerTest extends JFrame {

    JButton theFirstButton;
    JButton theSecondButton;
    JPanel theEmbeddedPanel;
    JButton theThirdButton;
    AnchoringLayoutManager mgr = new AnchoringLayoutManager();
    AnchoringLayoutManager mgrInner = new AnchoringLayoutManager();
    int oldScale = 1000;

    public AnchoringLayoutManagerTest() {

        Container theContainer = getContentPane();

        setLocation(50, 50);
        setSize(600, 600);

        theFirstButton = new JButton("Zoom");
        theFirstButton.setName("FirstButton");
        theFirstButton.setLocation(20, 100);
        theFirstButton.setSize(120, 22);

        theSecondButton = new JButton("Unzoom");
        theSecondButton.setName("SecondButton");
        theSecondButton.setLocation(20, 200);
        theSecondButton.setSize(120, 22);

        theThirdButton = new JButton("Test");
        theThirdButton.setName("ThirdButton");
        theThirdButton.setLocation(20, 100);
        theThirdButton.setSize(120, 22);

        theEmbeddedPanel = new JPanel(mgrInner);
        theEmbeddedPanel.setName("EmbeddedPanel");
        theEmbeddedPanel.setLocation(200, 100);
        theEmbeddedPanel.setSize(300, 400);
        theEmbeddedPanel.setBackground(Color.cyan);

        theContainer.setLayout(mgr);
        theContainer.add(theFirstButton, "FirstButton");
        theContainer.add(theSecondButton, "SecondButton");
        theContainer.add(theEmbeddedPanel, "EmbeddedPanel");
        theEmbeddedPanel.add(theThirdButton, "ThirdButton");
        mgr.setAnchoring(theFirstButton, false, false, false, false);
        mgr.setAnchoring(theSecondButton, false, false, false, false);
        mgr.setAnchoring(theEmbeddedPanel, false, false, false, false);
        mgrInner.setAnchoring(theThirdButton, false, false, false, false);

        theFirstButton.addActionListener(new scaleAction(1400));
        theSecondButton.addActionListener(new scaleAction(1000));
        // Now format the layouts.
        setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        show();
    }

    public static void main(String[] args) {
        new AnchoringLayoutManagerTest();
    }

    void setScale(int scale) {
        mgr.setScale(scale);
        mgrInner.setScale(scale);
        Dimension dimSize = getSize();
        if (scale != oldScale) {
            dimSize = new Dimension(dimSize.width * scale/oldScale,
                    dimSize.height * scale/oldScale);
        }
        oldScale = scale;
        mgr.layoutContainer(getContentPane());
        mgrInner.layoutContainer(theEmbeddedPanel);
    }

    class scaleAction implements ActionListener {
        int scale;
        scaleAction(int scale) {
            this.scale = scale;
        }
        public void actionPerformed(ActionEvent e) {
            setScale(scale);
        }

    }
}

