/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * InfoBox.java  
 *
 * Creator:
 * 16.02.2005 13:39:38 Pecar
 *
 * Maintainer:
 * 16.02.2005 13:39:38 Pecar
 *
 * Last Modification:
 * $Id: ColumnBox.java,v 1.1 2005/02/18 16:33:56 pecar Exp $
 *
 * Copyright (c) 2004 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.lib.ui.layout;

import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JALabel;

import javax.swing.*;
import java.awt.*;

public class ColumnBox extends JAPanel {
    public ColumnBox(int columnCount, int variableColumn, int hgap, int vgap) {
        super(new ColumnLayout(columnCount, variableColumn, hgap, vgap));
        //setBorder(BorderFactory.createLineBorder(Color.red)); //debugborder
    }
    public void addPair(Component name, Component value) {
        add(name);
        add(value);
    }
    public void addNameValue(String name, Component value) {
        addPair(new JALabel(name), value);
    }
    public void addNameText(String name, String text) {
        addPair(new JALabel(name), new JALabel(text));
    }
    public void addHorizontal(Component component) {
        add(component, ColumnLayout.FULL_LINE);
    }
    public void setLayout(LayoutManager mgr) {
        if(mgr instanceof ColumnLayout)
            super.setLayout(mgr);
        else
            throw new IllegalArgumentException("ColumnBox can only handle columnlayout");
    }
    public final ColumnLayout getColumnLayout() {
        return (ColumnLayout) getLayout();
    }
}