/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * JABox.java  
 *
 * Creator:
 * 06.09.2004 07:43:39 hemmer
 *
 * Maintainer:
 * 06.09.2004 07:43:39 hemmer
 *
 * Last Modification:
 * $Id: JABox.java,v 1.2 2004/09/06 11:50:43 hemmer Exp $
 *
 * Copyright (c) 2004 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.lib.ui.layout;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.Box;


/**
 * Class that wrappes the javax.swing.Box Class. The static Methods for getting a Box, Component etc (Filler) will set the Focusable Attribut to false, so the
 * ABACUS Focus-Management could handle that Fillers right.
 */

public class JABox extends Box {

  public JABox(int axis) {
    super(axis);
    setFocusable(false);
  }


  /**
   * Creates a <code>Box</code> that displays its components
   * from left to right.
   * @return the box
   */
  public static Box createHorizontalBox() {
    Box box = Box.createHorizontalBox();
    box.setFocusable(false);
    return box;
  }

  /**
   * Creates a <code>Box</code> that displays its components
   * from top to bottom.
   * @return the box
   */
  public static Box createVerticalBox() {
    Box box =  Box.createVerticalBox();
    box.setFocusable(false);
    return box;
  }

  /**
   * Creates an invisible component that's always the specified size.
   * <!-- WHEN WOULD YOU USE THIS AS OPPOSED TO A STRUT? -->
   * @param d the dimensions of the invisible component
   * @return the component
   * @see #createGlue
   * @see #createHorizontalStrut
   * @see #createVerticalStrut
   */
  public static Component createRigidArea(Dimension d) {
    Component comp = Box.createRigidArea(d);
    comp.setFocusable(false);
    return comp;
  }

  /**
   * Creates an invisible, fixed-width component.
   * In a horizontal box,
   * you typically use this method
   * to force a certain amount of space between two components.
   * In a vertical box,
   * you might use this method
   * to force the box to be at least the specified width.
   * The invisible component has no height
   * unless excess space is available,
   * in which case it takes its share of available space,
   * just like any other component that has no maximum height.
   * @param width the width of the invisible component, in pixels >= 0
   * @return the component
   * @see #createVerticalStrut
   * @see #createGlue
   * @see #createRigidArea
   */
  public static Component createHorizontalStrut(int width) {
    Component comp = Box.createHorizontalStrut(width);
    comp.setFocusable(false);
    return comp;
  }

  /**
   * Creates an invisible, fixed-height component.
   * In a vertical box,
   * you typically use this method
   * to force a certain amount of space between two components.
   * In a horizontal box,
   * you might use this method
   * to force the box to be at least the specified height.
   * The invisible component has no width
   * unless excess space is available,
   * in which case it takes its share of available space,
   * just like any other component that has no maximum width.
   * @param height the height of the invisible component, in pixels >= 0
   * @return the component
   * @see #createHorizontalStrut
   * @see #createGlue
   * @see #createRigidArea
   */
  public static Component createVerticalStrut(int height) {
    Component comp = Box.createVerticalStrut(height);
    comp.setFocusable(false);
    return comp;
  }

  /**
   * Creates an invisible "glue" component
   * that can be useful in a Box
   * whose visible components have a maximum width
   * (for a horizontal box)
   * or height (for a vertical box).
   * You can think of the glue component
   * as being a gooey substance
   * that expands as much as necessary
   * to fill the space between its neighboring components.
   * <p/>
   * <p/>
   * <p/>
   * For example, suppose you have
   * a horizontal box that contains two fixed-size components.
   * If the box gets extra space,
   * the fixed-size components won't become larger,
   * so where does the extra space go?
   * Without glue,
   * the extra space goes to the right of the second component.
   * If you put glue between the fixed-size components,
   * then the extra space goes there.
   * If you put glue before the first fixed-size component,
   * the extra space goes there,
   * and the fixed-size components are shoved against the right
   * edge of the box.
   * If you put glue before the first fixed-size component
   * and after the second fixed-size component,
   * the fixed-size components are centered in the box.
   * <p/>
   * <p/>
   * <p/>
   * To use glue,
   * call <code>Box.createGlue</code>
   * and add the returned component to a container.
   * The glue component has no minimum or preferred size,
   * so it takes no space unless excess space is available.
   * If excess space is available,
   * then the glue component takes its share of available
   * horizontal or vertical space,
   * just like any other component that has no maximum width or height.
   * @return the component
   */
  public static Component createGlue() {
    Component comp = Box.createGlue();
    comp.setFocusable(false);
    return comp;
  }

  /**
   * Creates a horizontal glue component.
   * @return the component
   */
  public static Component createHorizontalGlue() {
    Component comp = Box.createHorizontalGlue();
    comp.setFocusable(false);
    return comp;
  }

  /**
   * Creates a vertical glue component.
   * @return the component
   */
  public static Component createVerticalGlue() {
    Component comp = Box.createVerticalGlue();
    comp.setFocusable(false);
    return comp;
  }
}
