package ch.abacus.lib.ui.plaf.generic;

/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;

import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalCheckBoxUI;

/*
 * The only difference to the MetalCheckBoxUI is the icon, which has a gradient.
 */
public class GenericCheckBoxUI extends MetalCheckBoxUI {
  private final static GenericCheckBoxUI checkBoxUI = new GenericCheckBoxUI();

  private CheckBoxPLAFListener mCheckBoxPLAFListener;

  public GenericCheckBoxUI() {
    super();
  }

  public static ComponentUI createUI(JComponent b) {
      ((JCheckBox) b).setIcon(GenericIconFactory.getCheckBoxIcon());
      return checkBoxUI;
  }

  protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
    g.setColor(GenericLookAndFeel.getDarkGray());
    g.drawRect(t.x - 1, t.y - 1, t.width + 1, t.height + 1);
  }

  public void installUI(JComponent c) {
    super.installUI(c);
    if (mCheckBoxPLAFListener == null) {
      mCheckBoxPLAFListener = new GenericCheckBoxUI.CheckBoxPLAFListener();
    }
    c.addMouseListener(mCheckBoxPLAFListener);
    c.addFocusListener(mCheckBoxPLAFListener);
  }

  protected BasicButtonListener createButtonListener(AbstractButton b) {
    return new BasicButtonListener(b);
  }

  private class CheckBoxPLAFListener extends MouseAdapter implements FocusListener {
    public CheckBoxPLAFListener() {
      super();
    }

    public void focusGained(FocusEvent e) {
      if (((JCheckBox) e.getSource()).isEnabled()) {
        ((JCheckBox) e.getSource()).setIcon(GenericIconFactory.getFocusedCheckBoxIcon());
        ((JCheckBox) e.getSource()).repaint();
      }
    }

    public void focusLost(FocusEvent e) {
      if (((JCheckBox) e.getSource()).isEnabled()) {
        ((JCheckBox) e.getSource()).setIcon(GenericIconFactory.getCheckBoxIcon());
      }
    }

    public void mouseEntered(MouseEvent e) {
      if (((JCheckBox) e.getSource()).isEnabled()) {
        ((JCheckBox) e.getSource()).setIcon(GenericIconFactory.getFocusedCheckBoxIcon());
      }
    }
    public void mouseExited(MouseEvent e) {
      if (((JCheckBox) e.getSource()).isEnabled()) {
        ((JCheckBox) e.getSource()).setIcon(GenericIconFactory.getCheckBoxIcon());
      }
    }
  }
}