/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 18.04.2005 09:58:49 Misteli
 *
 * Maintainer:
 * 18.04.2005 09:58:49 Misteli
 *
 * Last Modification:
 * $Id: AccessorInterface.java,v 1.1 2005/09/02 14:26:04 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.core;

import ch.abacus.lib.ui.propertyinspector.display.ObjectInstance;

/**
 * The AccessorInterface is used to retrieve the physical values from a physical component and to set it back.
 * If an application needs to define Property Editors for Swing components, AccessorInterface.setValue would be used
 * to set a value from the property inspector to a single component, AccessorInterface.getValue would be used to retrieve the
 * physical value and prepare it in the format the renderes and editors understand.
 */
public interface AccessorInterface {

  /**
   * beginUpdate is used when properties needs to be written (could be more than one property or more than one component, so
   * if an application needs to refresh its UI after each property is written, it could wait for a beginUpdate/endUpdate pair until
   * it finally really refreshes the UI
   */
  public void beginUpdate();

  /**
   * setValue is called when the property editor needs to write a value to the physical component.
   * @param property the Property that the value belongs to
   * @param instance the physical instance of the compoent that needs to be written to
   * @param value the value of the property editor..
   */
  public void setValue(Property property, ObjectInstance instance, Object value);

  /**
   * getValue is called when a value is needed from the pyhsical class so that it can be displayed inside the property editor.
   * @param property the Property that shall be retrieved
   * @param instance the physical instance of the class..
   * @return the value for the property editor which must be in the format both renderer and editor understand.
   */
  public Object getValue(Property property, ObjectInstance instance);

  /**
   * endUpdate is called when all properties have been written to all physical classes that need to be written to
   */
  public void endUpdate();
}
