/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 15.04.2005 09:35:11 Misteli
 *
 * Maintainer:
 * 15.04.2005 09:35:11 Misteli
 *
 * Last Modification:
 * $Id: Property.java,v 1.3 2005/09/13 14:50:03 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.core;

import ch.abacus.lib.ui.propertyinspector.display.PropertyEditorInterface;
import ch.abacus.lib.ui.propertyinspector.display.PropertyRendererInterface;
import ch.abacus.lib.ui.propertyinspector.display.PropertyValueEditorInterface;

/**
 * The Property class defines a single Property of the Property Inspector. Each property has a unique enum id to identifiy the property
 * a name which is displayed in the property editor, a hint which is used as tooltip, and must belong to a Group.
 * Each property must define a renderer that is used to display the property in the property inspector and an editor which is used to
 * edit the property.
 * A property can contain dependencies to other properties, so that a property can be made disabled in the property inspector if the
 * dependencies contains several values or so..
 * A property can be defined as single selection, so that it is automatically disabled in multi selection mode. This makes, for example,
 * sense for Name properties which often must be unique.
 */
public class Property {

  private Enum id;
  private Object data;
  private String name = "";
  private String hint = "";
  private String help = null;
  private Group group;
  private boolean singleSelection;
  private boolean readOnly;
  private boolean valueEditorReadOnly;
  private PropertyValueEditorInterface editor;
  private PropertyRendererInterface renderer;
  private PropertyEditorInterface propertyEditor;
  private Properties dependencies = new Properties();

  public Property(Enum id, String name, String hint, Group group, PropertyRendererInterface renderer, PropertyValueEditorInterface editor) {
    this(id, name, hint, group, renderer, editor, editor instanceof PropertyEditorInterface ? (PropertyEditorInterface) editor : null);
  }

  public Property(Enum id, String name, String hint, Group group, PropertyRendererInterface renderer, PropertyValueEditorInterface editor, PropertyEditorInterface propertyEditor) {
    this.id = id;
    this.name = name;
    this.hint = hint;
    this.group = group;
    this.editor = editor;
    this.renderer = renderer;
    this.propertyEditor = propertyEditor;
  }

  public Object getData() {
    return data;
  }

  public void setData(Object data) {
    this.data = data;
  }

  public Properties getDependencies() {
    return dependencies;
  }

  public PropertyEditorInterface getPropertyEditor() {
    return propertyEditor;
  }

  public PropertyValueEditorInterface getEditor() {
    return editor;
  }

  public PropertyRendererInterface getRenderer() {
    return renderer;
  }

  public Enum getId() {
    return id;
  }

  public String getName() {
    return name;
  }

  public String getHint() {
    return hint;
  }

  public void setHint(String hint) {
    this.hint = hint;
  }

  public Group getGroup() {
    return group;
  }

  public boolean isSingleSelection() {
    return singleSelection;
  }

  public void setSingleSelection(boolean singleSelection) {
    this.singleSelection = singleSelection;
  }

  public boolean isReadOnly() {
    return readOnly;
  }

  public void setReadOnly(boolean readOnly) {
    this.readOnly = readOnly;
  }

  public String toString() {
    return "[" + id + "] " + name;
  }

  public boolean isValueEditorReadOnly() {
    return valueEditorReadOnly;
  }

  public void setValueEditorReadOnly(boolean valueEditorReadOnly) {
    this.valueEditorReadOnly = valueEditorReadOnly;
  }

  public String getHelp() {
    return help;
  }

  public void setHelp(String help) {
    this.help = help;
  }

}
