/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 22.04.2005 08:33:49 Misteli
 *
 * Maintainer:
 * 22.04.2005 08:33:49 Misteli
 *
 * Last Modification:
 * $Id: BaseStringListEditor.java,v 1.2 2005/09/20 07:44:25 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.editor;

import ch.abacus.lib.ui.propertyinspector.core.StringEntry;

import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import java.util.List;

public class BaseStringListEditor extends AbstractListEditor {

  protected List<ch.abacus.lib.ui.propertyinspector.core.StringEntry> list;
  protected List<Icon> icons;

  public BaseStringListEditor(List<StringEntry> list) {
    this(false, list, null);
  }

  public BaseStringListEditor(List<StringEntry> list, List<Icon> icons) {
    this(false, list, icons);
  }

  public BaseStringListEditor(boolean lazyInitialization, List<StringEntry> list, List<Icon> icons) {
    super(lazyInitialization);
    this.list = list;
    this.icons = icons;
  }

  public List getItemList() {
    return list;
  }

  public int indexOf(Object value) {
    for (int i=0; i<list.size(); i++)
      if (list.get(i).getProperty().equals(value))
        return i;
    return -1;
  }

  public ListCellRenderer getListCellRenderer() {
    return new IconListRenderer(list, icons);
  }

  public Object getValue() {
    Object result = super.getValue();
    StringEntry entry;
    if (!(result instanceof StringEntry))
      entry = new StringEntry(result, "");
    else
      entry = (StringEntry) result;
    return entry.getProperty();
  }
}
