/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/** Creator:
 * 20.04.2005 17:05:14 Misteli
 *
 * Maintainer:
 * 20.04.2005 17:05:14 Misteli
 *
 * Last Modification:
 * $Id: ColorIcon.java,v 1.1 2005/09/02 14:26:06 misteli Exp $
 *
 * Copyright (c) 2003 ABACUS Research AG, All Rights Reserved
 */

package ch.abacus.lib.ui.propertyinspector.display.renderer;

import javax.swing.Icon;
import javax.swing.UIManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

public class ColorIcon implements Icon {

  private Color color;

  public ColorIcon(Color color) {
    this.color = color;
  }

  public int getIconHeight() {
    return 10;
  }

  public int getIconWidth() {
    return 30;
  }

  public void paintIcon(Component c, Graphics g, int x, int y) {
    Color oldColor = g.getColor();

    if (color != null) {
      g.setColor(color);
      g.fillRect(x, y, getIconWidth(), getIconHeight());
    }

    g.setColor(UIManager.getColor("controlDkShadow"));
    g.drawRect(x, y, getIconWidth(), getIconHeight());

    g.setColor(oldColor);
  }
}
