/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.abaRenderer;

import ch.abacus.lib.ui.JAFrame;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.renderer.common.HammerException;

import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

/**
 * <p>Title: Abacus Java AbaRenderer</p>
 * <p>Description: This library renders java interfaces from XML descriptions</p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company:A Abacus Research</p>
 * @author Michael Gouker (Cagey Logic Technologies)
 * @version 1.0
 */

public class TestMe {
// someClassThatImplementsGlobalInterface globalInterface;
    public TestMe(String sDocumentName) throws HammerException {
        // Next line needs to be uncommented to work with global interface.
        //  AbaRenderer theRenderer = new AbaRenderer(sDocumentName, false, globalInterface);
        if (sDocumentName.endsWith(".jar") && !sDocumentName.startsWith("http:")) {
            File docFile = new File(sDocumentName);
            if (docFile.exists())
                sDocumentName = docFile.getAbsolutePath();
        }
        AbaRenderer theRenderer = new AbaRenderer(sDocumentName, true, null);
        AbaRenderer theRenderer2 = new AbaRenderer(sDocumentName, true, null);
        AbaRenderer theRenderer3 = new AbaRenderer(sDocumentName, true, null);
        // test discrete path for rog misteli.
        //theRenderer.setSystemConfigurationPathName("c:\\dev\\v2005_cdnew\\aba\\java\\src\\ch\\abacus\\lib\\ui\\renderer\\deploy\\");
        boolean bTest = theRenderer.load();

        if (bTest) {
            JAFrame theFrame = new JAFrame();
            theFrame.setTitle("Test Rendering of " + sDocumentName);
            theFrame.setLocation(100, 100);
            theFrame.setSize(500, 400);
            JAPanel thePanel = new JAPanel();
            thePanel.setLocation(0, 0);
            thePanel.setSize(500, 400);
            theFrame.getContentPane().add(thePanel);
            theFrame.show();
            theRenderer.renderInterface(thePanel);
            theFrame.setVisible(false);
            theFrame.setVisible(true);
//            theRenderer.renderInterface();
//            Dimension dimFrameSize = thRenderer.getBaseFrameSize();
//            System.out.println("Dim X: " + dimFrameSize.getWidth() + ", Dim Y: " + dimFrameSize.getHeight());
//            theRenderer.testRemove();
            theFrame.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
            theRenderer.setFocus();
            theFrame.addWindowListener(new MyWindowListener(theFrame, theRenderer));
            KeyboardFocusManager focusManager =
                    KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window newFocus = focusManager.getFocusedWindow();
            System.out.println("New focus is: " + newFocus.getName());

        }
        bTest = theRenderer2.load();

        if (bTest) {
            JAFrame theFrame = new JAFrame();
            theFrame.setTitle("Test Rendering of " + sDocumentName);
            theFrame.setLocation(100, 100);
            theFrame.setSize(500, 400);
            JAPanel thePanel = new JAPanel();
            thePanel.setLocation(0, 0);
            thePanel.setSize(500, 400);
            theFrame.getContentPane().add(thePanel);
            theFrame.show();
            theRenderer2.renderInterface(thePanel);
            theFrame.setVisible(false);
            theFrame.setVisible(true);
//            theRenderer.renderInterface();
//            Dimension dimFrameSize = thRenderer.getBaseFrameSize();
//            System.out.println("Dim X: " + dimFrameSize.getWidth() + ", Dim Y: " + dimFrameSize.getHeight());
//            theRenderer.testRemove();
            theFrame.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
            theRenderer2.setFocus();
            theFrame.addWindowListener(new MyWindowListener(theFrame, theRenderer));
            KeyboardFocusManager focusManager =
                    KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window newFocus = focusManager.getFocusedWindow();
            System.out.println("New focus is: " + newFocus.getName());

        }
        bTest = theRenderer3.load();

        if (bTest) {
            JAFrame theFrame = new JAFrame();
            theFrame.setTitle("Test Rendering of " + sDocumentName);
            theFrame.setLocation(100, 100);
            theFrame.setSize(500, 400);
            JAPanel thePanel = new JAPanel();
            thePanel.setLocation(0, 0);
            thePanel.setSize(500, 400);
            theFrame.getContentPane().add(thePanel);
            theFrame.show();
            theRenderer3.renderInterface(thePanel);
            theFrame.setVisible(false);
            theFrame.setVisible(true);
//            theRenderer.renderInterface();
//            Dimension dimFrameSize = thRenderer.getBaseFrameSize();
//            System.out.println("Dim X: " + dimFrameSize.getWidth() + ", Dim Y: " + dimFrameSize.getHeight());
//            theRenderer.testRemove();
            theFrame.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
            theRenderer3.setFocus();
            theFrame.addWindowListener(new MyWindowListener(theFrame, theRenderer));
            KeyboardFocusManager focusManager =
                    KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window newFocus = focusManager.getFocusedWindow();
            System.out.println("New focus is: " + newFocus.getName());

        }
    }

    class MyWindowListener extends WindowAdapter {
        private JAFrame theFrame;
        private AbaRenderer theRenderer;

        MyWindowListener(JAFrame theFrame, AbaRenderer theRenderer) {
            this.theFrame = theFrame;
            this.theRenderer = theRenderer;
        }

        public void windowClosing(WindowEvent evt) {
            System.out.println("Window is closed.  Getting back resources.");
            theRenderer.close();
            super.windowClosing(evt);
            theRenderer = null;
            theFrame = null;
            System.gc();
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                new TestMe(args[0]);
            } catch (HammerException e1) {
                System.out.println("Hammer Exception: " + e1.getExceptionCode() + " = " + e1.getMessage());
            }
        }
    }
}