/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: Jun 26, 2003
 * Time: 2:50:41 PM
 * To change this template use Options | File Templates.
 */
public interface AbaMetaDataUser {
    public static final int NO_MODE = 0;
    public static final int DESIGN_MODE = 1;
    public static final int EXECUTION_MODE = 2;

    public int getMode();

    public void setMode(int iMode);

    public HammerFileManager getFileManager();

    public void setFileManager(HammerFileManager theFileManager);

    public HammerConfigurationManager getConfigurationManager();

    public void setConfigurationManager(HammerConfigurationManager theConfigurationManager);

    public HammerClassLoader getClassLoader();

    public void setClassLoader(HammerClassLoader theClassLoader);

    public HammerLogFileAccess getLogFile();

    public java.util.Properties getProps();

    public String getBaseDir();

    public String getUserHome();

    public int getVersionNumber();

    public int getRevisionNumber();

    public int getSubRevisionNumber();

    public int getBuildNumber();

    // Moved this into here because otherwise the DesignObject is exposed to the renderer.
    public void updateDisplayLayer(MetaObject metaObject, int iLayer);

    public void processObjectNameChanged(MetaObject metaObject);

    public void propertyEditedRepaint(MetaObject metaObject);

    public void processCreateLayout(MetaObject metaObject);

    public void processPlacement(MetaObject metaObject);

    public void processDoFrameSizeboxes(MetaObject metaObject);

    public void doNewVisualObject(MetaObject metaObject);

    public void processDeleteObject(MetaObject metaObject);

    public boolean getAttachedToDesigner();

    public void processProjectChangedState(boolean bState);

    public MetaObject getSelectedContainer();

    public MetaObject getSelectedObject();

    public void processTabPages(MetaObject metaObject);

    public void processMenus(MetaObject metaObject);

    public void processMenuSeparators(MetaObject theMetaObject);

    public void processMenuItems(MetaObject metaObject);


    public String getSystemMetadataDocumentName();

    public void setSystemMetadataDocumentName(String SystemMetadataDocumentName);

    public String getSystemConfigurationPathName();

    public void setSystemConfigurationPathName(String systemConfigurationPathName);

    public String getSystemConfigurationDocumentName();

    public void setSystemConfigurationDocumentName(String systemConfigurationDocumentName);

    public boolean getGuruState();

    void showObject(MetaObject theBottomPanel);

    void tellProgress(String s);

    boolean getNovaState();

    boolean getOpenSourceState();

    boolean getDropletsState();
}
