/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

/*
=====================================================================

  CheckTreeCellRenderer.java

  Created by Claude Duguay
  Copyright (c) 2000

=====================================================================
*/

import javax.swing.*;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import java.awt.*;


public class CheckTreeCellRenderer extends JPanel
        implements TreeCellRenderer {
    protected CheckTreeNode node;
    protected TreeCellRenderer renderer;
    protected JCheckBox check;

    public CheckTreeCellRenderer(JTree tree) {
        this(tree, new DefaultTreeCellRenderer());
    }

    public CheckTreeCellRenderer(JTree tree, TreeCellRenderer renderer) {
        setOpaque(false);
        setLayout(new BorderLayout());

        this.renderer = renderer;
        add(BorderLayout.CENTER,
                renderer.getTreeCellRendererComponent(
                        tree, "", true, true, true, 0, true));
//    if (node != null) {
//        int iCount = node.getChildCount();
//        if (iCount==0) {
        check = new JCheckBox();
        check.setMargin(new Insets(0, 0, 0, 0));
        check.setBorderPaintedFlat(true);
        check.setOpaque(false);
        add(BorderLayout.WEST, check);
//        }
//    }
    }

    public Component getTreeCellRendererComponent(
            JTree tree, Object value, boolean selected,
            boolean expanded, boolean leaf, int row,
            boolean hasFocus) {
        if (value instanceof CheckTreeNode) {
            node = (CheckTreeNode) value;
            check.setSelected(node.isSelected());
            value = node.getUserObject();
            add(BorderLayout.WEST, check);
        } else {
            remove(check);
        }
        renderer.getTreeCellRendererComponent(
                tree, value, selected, expanded, leaf, row, hasFocus);
        return this;
    }

}

