/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;


/**
 * <p>Title: uifactory</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2001</p>
 * <p>Company: Abacus Research</p>
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

public class HammerLanguagePresentation {
    static public final int DEFAULT = 0;
    static public final int DEUTSCH = 0;
    static public final int FRANCAIS = 1;
    static public final int ENGLISH = 3;
    static public final int ITALIAN = 2;
    static public final int LAST_LANGUAGE = 3;
    public int theLanguage = DEFAULT;
    public HammerLanguagePresentation theNextLanguage = null;
    public HammerLanguagePresentation thePreviousLanguage = null;
    public MetaProject theDesignProject = null;

    public HammerLanguagePresentation() {
    }

    public HammerLanguagePresentation(int theLanguage, MetaProject theDesignProject) {
        this.theLanguage = theLanguage;
        this.theDesignProject = theDesignProject;
    }

    static public String getLanguageName(int iLanguage) {
        switch (iLanguage) {
            case DEUTSCH:
                return "Deutsch (Default)";
            case FRANCAIS:
                return "Francais";
            case ITALIAN:
                return "Italiano";
            case ENGLISH:
                return "English";
        }
        return "";
    }

    public boolean save(electric.xml.Element theParent) {
        // create the property elements
        electric.xml.Element xmlLanguage = new electric.xml.Element("Language");
        theParent.addElement(xmlLanguage);
        xmlLanguage.setAttribute("Name", new Integer(theLanguage).toString());
        return true;
    }

    public boolean load(electric.xml.Element theElement) {
        String theAttribute = theElement.getAttribute("Name");
        try {
            Integer theValue = new Integer(theAttribute);
            theLanguage = theValue.intValue();
        } catch (java.lang.NumberFormatException e1) {
            theLanguage = DEFAULT;
        }
        return true;
    }

    public boolean saveValue(electric.xml.Element theParent, String theData) {
        // create the property elements
        electric.xml.Element xmlLanguage = new electric.xml.Element("Language");
        theParent.addElement(xmlLanguage);
        xmlLanguage.setAttribute("Name", new Integer(theLanguage).toString());
        electric.xml.Element xmlData = new electric.xml.Element("Data");
        xmlData.setText(theData);
        xmlLanguage.addElement(xmlData);
        return true;
    }

    public String[] loadValue(electric.xml.Element theElement, String[] theValues) {
        electric.xml.Element xmlData = theElement.getElement("Data");
        if (xmlData != null)
            theValues[theLanguage] = xmlData.getTextString();
        return theValues;
    }
}

