/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.File;
import java.io.FileNotFoundException;

/**
 * <p>Title: Abajamm</p>
 * <p>Description: Abacus Java Module Manager</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: Abacus </p>
 * @author Michael Gouker - Cagey Logic
 * @version 1.0
 */


public class HammerLogFileAccess {
    PrintStream theLogWriter = null;

    public HammerLogConsoleStream getLogConsoleStream() {
        return theLogConsoleStream;
    }

    public void setLogConsoleStream(HammerLogConsoleStream theLogConsoleStream) {
        this.theLogConsoleStream = theLogConsoleStream;
    }

    public boolean isExtendedLogging() {
        return bExtendedLogging;
    }

    public boolean isConsoleLogging() {
        return bConsoleLogging;
    }

    public boolean isFileLogging() {
        return bFileLogging;
    }

    public boolean isDedicatedConsoles() {
        return bDedicatedConsoles;
    }

    public void setDedicatedConsoles(boolean bDedicatedConsoles) {
        this.bDedicatedConsoles = bDedicatedConsoles;
    }

    public boolean isDebuggingLogging() {
        return bDebuggingLogging;
    }


    public boolean isClassLoaderLogging() {
        return bClassLoaderLogging;
    }

    public boolean isCacheManagerLogging() {
        return bCacheManagerLogging;
    }

    public PrintStream getLogWriter() {
        return theLogWriter;
    }

    public void setLogWriter(PrintStream theLogWriter) {
        this.theLogWriter = theLogWriter;
    }

    public void setUser(AbaMetaDataUser theUser) {
        this.theUser = theUser;
    }

    public HammerLogConsoleStream theLogConsoleStream = null;
    AbaMetaDataUser theUser = null;
    public boolean bExtendedLogging = false;
    public boolean bConsoleLogging = false;
    public boolean bFileLogging = false;
    public boolean bDedicatedConsoles = false;
    public boolean bDebuggingLogging = false;
    public boolean bClassLoaderLogging = false;
    public boolean bCacheManagerLogging = false;
    public boolean bNLSLogging = false;
    public boolean bConfigured = false;
    private boolean bCustomizerLogging = false;

    private static final String LOG_FILENAME = "designcockpit.log"; // name of the logfile
    private static final int MAX_LOG_FILESIZE = 2000000; // size of log file to trigger a auto-clear of contents

    public HammerLogFileAccess(AbaMetaDataUser theUser)
    {
        this.theUser = theUser;
        // 050224, acg
        // SWB 27 Feb, 2005: the configuration manager can be null (as it is in the Metadata Editor)...
        final HammerConfigurationManager configurationManager = this.theUser.getConfigurationManager();
        if (configurationManager != null)
            bFileLogging = configurationManager.checkConfigurationSetting("FileLogging");
        else
            bFileLogging = false;

        if ( bFileLogging )
        {
            File logFile = getLogFile();
            if (logFile.exists() && logFile.length() > MAX_LOG_FILESIZE)
                clearLogContents();

            theLogWriter = createLogWriter(logFile, true);
        }

        theLogConsoleStream = new HammerLogConsoleStream(theUser);
        bConfigured = true;
    }

    private File getLogFile() {
        String sLogDirectory = this.theUser.getConfigurationManager().getLogDirectory();
        if ( sLogDirectory==null )
        {
            sLogDirectory="";
        }
        else if ( !sLogDirectory.endsWith( System.getProperty("file.separator") ) )
        {
            sLogDirectory += System.getProperty("file.separator");
        }

        File logFile = new File(sLogDirectory + LOG_FILENAME);

        return logFile;
    }

    public boolean isCustomizerLogging() {
        return bCustomizerLogging;
    }

    public void setNLSLogging(boolean newLogging) {
        bNLSLogging = newLogging;
    }

    public boolean isNLSLogging() {
        return bNLSLogging;
    }

    public void setExtendedLogging(boolean newLogging) {
        bExtendedLogging = newLogging;
    }

    public void setDedicatedConsole(boolean dedicatedConsoles) {
        bDedicatedConsoles = dedicatedConsoles;
    }

    public void setConsoleLogging(boolean consoleLogging) {
        bConsoleLogging = consoleLogging;
    }

    public void setClassLoaderLogging(boolean classLoaderLogging) {
        this.bClassLoaderLogging = classLoaderLogging;
    }

    public void setDebuggingLogging(boolean debuggingLogging) {
        this.bDebuggingLogging = debuggingLogging;
    }

    public void setFileLogging(boolean fileLogging) {
        bFileLogging = fileLogging;
    }

    public void doDebuggingLogEntry(String sDescription, String sMessage) {
        if (bDebuggingLogging)
            doLogEntry("Debugging: ", sDescription + sMessage);
    }

    public void setCacheManagerLogging(boolean cacheManagerLogging) {
        bCacheManagerLogging = cacheManagerLogging;
    }

    public void setCustomizerLogging(boolean customizerLogging) {
        this.bCustomizerLogging = customizerLogging;
    }

    public void doClassLoaderLogEntry(String sDescription, String sMessage) {
        if (bClassLoaderLogging)
            doLogEntry("ClassLoader: ", sDescription + sMessage);
    }

    public void doCacheManagerLogEntry(String sDescription, String sMessage) {
        if (bCacheManagerLogging)
            doLogEntry("CacheManager: ", sDescription + sMessage);
    }

    public void doLogEntry(String pDescription, String pMessage) {
        if (bExtendedLogging == true) {
            if (theLogWriter != null) {
                String sMessage = "Description: " + pDescription + ", " + pMessage + "\r\n";
                if (bFileLogging) {
                    theLogWriter.print(sMessage);
                    theLogWriter.flush();
                }
                if (bConsoleLogging) {
                    boolean bOldLogging = bClassLoaderLogging;
                    bClassLoaderLogging = false;  // need to turn this off to stop recursion
                    theLogConsoleStream.print(sMessage);
                    theLogConsoleStream.flush();
                    bClassLoaderLogging = bOldLogging;
                }
            }
        }
    }

    /**
     * Clears the contents of the log file. Typically called after creating an AbaRenderer instance to guarantee that the log is empty and will only contain valid data relating to the current instance (remember, by default the log file does not get deleted and just keeps growing)
     */
    public void clearLogContents() {
        if (theLogWriter != null) {
            theLogWriter.flush();
            theLogWriter.close();
        }

        File logFile = getLogFile();

        theLogWriter = createLogWriter(logFile, false);
    }

    private PrintStream createLogWriter(File logFile, boolean bKeepContents){
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(logFile, bKeepContents));
        } catch (FileNotFoundException e) {
            System.err.println("Cannot create " +LOG_FILENAME);
        }
        return printStream;
    }
}