/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.droplets.DropletSimpleLog;
import electric.xml.CData;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;

import java.io.*;
import java.util.Enumeration;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: Jun 30, 2003
 * Time: 6:55:09 PM
 * To change this template use Options | File Templates.
 */
public class HammerMetadataDocument {

    public MetadataDispenser theMetadataDispenser;

    private boolean bAlreadyLoaded          = false;
    private boolean bCustomAlreadyLoaded    = false;
    private boolean bLoadingComplete        = false;

    public String sFullPathName;
    public String sJarName;
    public int mode;
    public String sDocumentComments         = null;
    public String sJarEntryName;

    public HammerMetadataDocument(MetadataDispenser theMetadataDispenser) {
        this.theMetadataDispenser = theMetadataDispenser;
    }

    /**
     * loads the attributes of  a property.<p>
     * <b>Note:</b> If you add/delete/change property attributes, you <b>must</b> also update MetaDocumentGenerator.doPropertyListLevel, to write the attribute back to teh document.
     * @param theClassDetail the Metaclass metadata
     * @param xmlProperty the xml element
     * @param iOrder the "order" of the property used in the creation of the MetaPropertyDescriptor
     * @return a MetaPropertyDescriptor of the newly created property
     */
    MetaPropertyDescriptor doPropertyList(MetaClassDetail theClassDetail, electric.xml.Element xmlProperty, int iOrder) {

        electric.xml.Element xmlPropName = xmlProperty.getElement("Name");
        electric.xml.Element xmlPropClass = xmlProperty.getElement("Class");
        electric.xml.Element xmlPropType = xmlProperty.getElement("Type");
        electric.xml.Elements xmlPropValueChoices = xmlProperty.getElements("ValueChoice");
        electric.xml.Element xmlPropDefaultValue = xmlProperty.getElement("DefaultValue");
        electric.xml.Element xmlPropSet = xmlProperty.getElement("Set");
        electric.xml.Element xmlPropGet = xmlProperty.getElement("Get");
        electric.xml.Element xmlPropertyHelper = xmlProperty.getElement("Helper");
        electric.xml.Element xmlPropertyDoc = xmlProperty.getElement("Doc");
        electric.xml.Element xmlPropGenerate = xmlProperty.getElement("Generate");
        electric.xml.Element xmlPropVisible = xmlProperty.getElement("Visible");
        electric.xml.Element xmlPropArray = xmlProperty.getElement("Array");
        electric.xml.Element xmlPropDataAwareness = xmlProperty.getElement("DataAwareness");
        electric.xml.Element xmlPropObjRef = xmlProperty.getElement("ObjectReference");
        electric.xml.Element xmlPropObjList = xmlProperty.getElement("ObjectList");
        electric.xml.Element xmlPropDefConstants = xmlProperty.getElement("DefaultConstantType");
        electric.xml.Element xmlPropLanguages = xmlProperty.getElement("Languages");
        electric.xml.Element xmlPropReadOnly = xmlProperty.getElement("ReadOnly");
        String sPropertyName = xmlPropName.getTextString();
        String sPropertyClass = "String";
        String sPropertyType = "";

//        String sPropertyValue = "";
        String sPropertyDefaultValue = "";
        String sPropertySetName = "";
        String sPropertyGetName = "";
        String sPropertyDoc = "";
        String sPropertyHelper = "";

        if (xmlPropClass != null)
            sPropertyClass = xmlPropClass.getTextString();
        if (xmlPropType != null)
            sPropertyType = xmlPropType.getTextString();
        if (xmlPropSet != null)
            sPropertySetName = xmlPropSet.getTextString();
        if (xmlPropGet != null)
            sPropertyGetName = xmlPropGet.getTextString();
        if (xmlPropertyHelper != null)
            sPropertyHelper = xmlPropertyHelper.getTextString();
        if (xmlPropDefaultValue != null)
            sPropertyDefaultValue = xmlPropDefaultValue.getTextString();
        if (xmlPropertyDoc != null) {
            electric.xml.Children theChildren = xmlPropertyDoc.getChildren();
            electric.xml.Child childTest = theChildren.first();
            electric.xml.CData cData = (CData) childTest;
            sPropertyDoc = cData.getString();
        }
        boolean bVisible = false;
        boolean bAutoGenerate = false;
        boolean bArray = false;
        boolean bLanguages = false;
        boolean bObjectReference = false;
        boolean bObjectPromptList = false;
        boolean bDataAwareness = false;
        boolean bReadOnly = false;
        String sIncludeTypeConstants = null;
        if (xmlPropDataAwareness != null)
            bDataAwareness = true;
        if (xmlPropGenerate != null)
            bAutoGenerate = true;
        if (xmlPropVisible != null)
            bVisible = true;
        if (xmlPropArray != null)
            bArray = true;
        if (xmlPropLanguages != null)
            bLanguages = true;
        if (xmlPropObjRef != null)  // tells renderer to resolve as an obj ref.
            bObjectReference = true;
        if (xmlPropObjList != null) { // tells design cockpit to give obj list as prompt.
            bObjectPromptList = true;
        }
        if (xmlPropReadOnly != null)
            bReadOnly = true;

        if (xmlPropDefConstants != null) {
            sIncludeTypeConstants = xmlPropDefConstants.getTextString();
        }
        String[] sValueChoices = new String[xmlPropValueChoices.size()];
        for (int iValueChoice = 0; iValueChoice < xmlPropValueChoices.size(); iValueChoice++) {
            Element elementValueChoice = xmlPropValueChoices.next();
            sValueChoices[iValueChoice] = elementValueChoice.getTextString();
        }
        MetaPropertyDescriptor theNewProperty =
                new MetaPropertyDescriptor(sPropertyName, sPropertyType,
                        sPropertyClass, sValueChoices, sPropertyDoc,
                        sPropertyDefaultValue,
                        sPropertySetName,
                        sPropertyGetName,
                        sPropertyHelper,
                        sIncludeTypeConstants,
                        iOrder,
                        theMetadataDispenser,
                        theClassDetail
                );
        theNewProperty.bGenerate = bAutoGenerate;
        theNewProperty.bVisible = bVisible;
        theNewProperty.bAllowMultipleValues = bArray;
        theNewProperty.bAllowMultipleLanguages = bLanguages;
        theNewProperty.bObjectReference = bObjectReference;
        theNewProperty.bObjectPromptList = bObjectPromptList;
        theNewProperty.setReadOnly(bReadOnly);
        theNewProperty.setDataAwareness(bDataAwareness);

        electric.xml.Elements theProperties = xmlProperty.getElements("Property");
        int iSubOrder = 0;
        for (int iProperty = 0; iProperty < theProperties.size(); iProperty++) {
            xmlProperty = theProperties.next();
            MetaPropertyDescriptor thePropertyList = doPropertyList(theClassDetail, xmlProperty, iSubOrder++);
            theNewProperty.addSubproperty(thePropertyList);
        }

        return theNewProperty;

    }

    public MetaClass loadClass(DropletSimpleLog theLog, electric.xml.Element xmlClass, MetaClass theParent) {
        String sClassComment = null;
        String sClassName = xmlClass.getName();

        electric.xml.Element xmlClassComment = xmlClass.getElement("Comments");
        if (xmlClassComment != null)
            sClassComment = xmlClassComment.getTextString();

        electric.xml.Element xmlFullClassName = xmlClass.getElement("FullClassName");
        String sFullClassName = "";
        if (xmlFullClassName != null)
            sFullClassName = xmlFullClassName.getTextString();
        if (theLog != null)
            theLog.writeMessage("Full class name of metaclass is " + sFullClassName);
        MetaClassDetail theClass = new MetaClassDetail(sClassName, sFullClassName);
        theClass.sClassComment = sClassComment;
        theClass.sFullClassName = sFullClassName;

        setLanguageAlias(theClass, xmlClass);

        electric.xml.Element xmlSuperClass = xmlClass.getElement("Superclass");
        String sSuperClassName = "";
        String sFullPathName = "";
        if (xmlSuperClass != null) {
            sSuperClassName = xmlSuperClass.getElement("Name").getTextString();
            sFullPathName = xmlSuperClass.getElement("FullPath").getTextString();
        }
        theClass.setSuperClass(sSuperClassName, sFullPathName);
        electric.xml.Element xmlDisplayClass = xmlClass.getElement("Display");
        if (xmlDisplayClass != null)
            theClass.setDisplayClass(xmlDisplayClass.getTextString());
        electric.xml.Element xmlHidden = xmlClass.getElement("Hidden");
        if (xmlHidden != null)
            theClass.bHidden = true;
        electric.xml.Element xmlSkipDecl = xmlClass.getElement("SkipDeclarations");
        if (xmlSkipDecl != null)
            theClass.bSkipDecl = true;
        electric.xml.Element xmlDesignBorders = xmlClass.getElement("DesignBorders");
        if (xmlDesignBorders != null)
            theClass.bDesignBorders = true;
        electric.xml.Element xmlCompositeComponents = xmlClass.getElement("CompositeComponent");
        if (xmlCompositeComponents!= null)
            theClass.bCompositeComponent = true;
        electric.xml.Element xmlSkipDefaultListeners = xmlClass.getElement("SkipDefaultListeners");
        if (xmlSkipDefaultListeners != null)
            theClass.bDefaultListeners = false;
        electric.xml.Element xmlDisplayClassIcon = xmlClass.getElement("Icon");
        if (xmlDisplayClassIcon!= null)
            theClass.setDisplayClassIcon(xmlDisplayClassIcon.getTextString());

        // We need some default classes for splitters.
        boolean bHorzSplitterClass = false;
        boolean bVertSplitterClass = false;
        boolean bPanelClass = false;

        electric.xml.Element xmlContainerType = xmlClass.getElement("ContainerType");
        if (xmlContainerType != null) {
            String sContainerType = xmlContainerType.getTextString();
            if ((sContainerType != null) && (sContainerType.trim().length() != 0)) {
                theClass.containerType = new MetaContainerType();
                theClass.containerType.setContainerType(sContainerType);
                if (sContainerType.equals("vsplit"))
                    bVertSplitterClass = true;
                else if (sContainerType.equals("hsplit"))
                    bHorzSplitterClass = true;
                else if (sContainerType.equals("panel"))
                    bPanelClass = true;
            }
        }

        electric.xml.Element xmlCustomCodeGenerator = xmlClass.getElement("Custom");
        if (xmlCustomCodeGenerator != null)
            theClass.sCustomCodeGenerationMethod = xmlCustomCodeGenerator.getTextString();

        electric.xml.Element xmlClassFactory = xmlClass.getElement("ClassFactory");
        if (xmlClassFactory != null)
            theClass.theFactoryName = xmlClassFactory.getTextString();

        electric.xml.Element xmlDesignEditor = xmlClass.getElement("DesignEditor");
        if (xmlDesignEditor != null)
            theClass.theDesignEditor = xmlDesignEditor.getTextString();

        // Associate listeners if any.
        if (theMetadataDispenser.iMode == MetaObject.DESIGN_MODE) {
            electric.xml.Elements xmlListeners = xmlClass.getElements("Listener");
            for (int iListener = 0; iListener < xmlListeners.size(); iListener++) {
                electric.xml.Element xmlListener = xmlListeners.next();
                theClass.addListener(xmlListener.getTextString(), theMetadataDispenser);
            }
            electric.xml.Elements xmlDataElements = xmlClass.getElements("MemberData");
            for (int iData = 0; iData < xmlDataElements.size(); iData++) {
                electric.xml.Element xmlDataElement = xmlDataElements.next();
                String sFieldName = xmlDataElement.getElement("Name").getTextString();

                electric.xml.Element xmlFieldType = xmlDataElement.getElement("Type");
                electric.xml.Element xmlFieldClass = xmlDataElement.getElement("Class");
                String sFieldClass = "";
                String sFieldType = "String";
                if (xmlFieldClass != null) {
                    sFieldType = "Class";
                    sFieldClass = xmlDataElement.getElement("Class").getTextString();
                } else {
                    if (xmlFieldType != null)
                        sFieldType = xmlFieldType.getTextString();
                }
                String sFieldValue = "";
                String sFieldDoc = "";
                electric.xml.Element xmlFieldValue = xmlDataElement.getElement("Value");
                electric.xml.Element xmlFieldDoc = xmlDataElement.getElement("Doc");
                if (xmlFieldValue != null)
                    sFieldValue = xmlFieldValue.getTextString();
                if (xmlFieldDoc != null) {
                    electric.xml.Children theChildren = xmlFieldDoc.getChildren();
                    int iDocChildren = theChildren.size();
                    if ((theChildren != null) && (iDocChildren != 0)) {
                        electric.xml.Child childTest = theChildren.first();
                        electric.xml.CData cData = (CData) childTest;
                        sFieldDoc = cData.getString();
                    }
                }
                theClass.addData(sFieldName, sFieldType, sFieldClass, sFieldValue, sFieldDoc);
            }
            electric.xml.Elements theMethods = xmlClass.getElements("Method");
            for (int iMethod = 0; iMethod < theMethods.size(); iMethod++) {
                electric.xml.Element xmlMethod = theMethods.next();
                String sMethodName = xmlMethod.getElement("Name").getTextString();
                electric.xml.Element xmlMethodCode = xmlMethod.getElement("Code");
                String sMethodBody = "";
                if (xmlMethodCode != null) {
                    electric.xml.Children theChildren = xmlMethodCode.getChildren();
                    electric.xml.Child childTest = theChildren.first();
                    electric.xml.CData cData = (CData) childTest;
                    sMethodBody = cData.getString();
                }
                electric.xml.Element xmlMethodDoc = xmlMethod.getElement("Doc");
                String sMethodDoc = "";
                if (xmlMethodDoc != null) {
                    electric.xml.Children theChildren = xmlMethodDoc.getChildren();
                    int iDocChildren = theChildren.size();
                    if ((theChildren != null) && (iDocChildren != 0)) {
                        electric.xml.Child childTest = theChildren.first();
                        electric.xml.CData cData = (CData) childTest;
                        sMethodDoc = cData.getString();
                    }
                }
                theClass.addMethod(sMethodName, sMethodBody, sMethodDoc);
            }
        }


        electric.xml.Elements theProperties = xmlClass.getElements("Property");
        for (int iProperty = 0; iProperty < theProperties.size(); iProperty++) {
            electric.xml.Element xmlProperty = theProperties.next();
            MetaPropertyDescriptor thePropertyList = doPropertyList(theClass, xmlProperty, 0);
            theClass.addProperties(thePropertyList);
        }

        // No place for doc yet.
        electric.xml.Element theDoc = xmlClass.getElement("Doc");

        // Create the design class.  Attach it to the parent.  This has to be done before
        // we process subclasses.
        MetaClass theMetaClass;
        if (theMetadataDispenser.getMetadataUser().getDropletsState())
            theMetaClass = new MetaClass(theLog, theClass, theParent, theMetadataDispenser);
        else
            theMetaClass = new MetaClass(theClass, theParent, theMetadataDispenser, true);

        if (theLog != null) {
            if (theMetaClass == null)
                theLog.writeMessage("No metaclass could be created!");
            else
                theLog.writeMessage("Metaclass is " + theMetaClass.toString());
        }

        if (bVertSplitterClass)
            theMetadataDispenser.setVerticalSplitterClass(theMetaClass);
        else if (bHorzSplitterClass)
            theMetadataDispenser.setHorizontalSplitterClass(theMetaClass);
        else if (bPanelClass)
            theMetadataDispenser.setDefaultPanelClass(theMetaClass);

        // Attach to parent.
        if (theParent != null)
            theParent.addClass(theMetaClass);


        electric.xml.Element xmlClassList = xmlClass.getElement("Classes");
        if (xmlClassList != null) {
            electric.xml.Elements xmlClasses = xmlClassList.getElements();
            for (int iClass = 0; iClass < xmlClasses.size(); iClass++) {
                electric.xml.Element xmlSubClass = xmlClasses.next();
                // load subclass
                loadClass(theLog, xmlSubClass, theMetaClass);
            }
        }
        return theMetaClass;
    }

    /**
     * Tries to set the display name for the class based upon the language string coded as an Attribute in the Element<p>
     *
     * @param metaClassDetail the class to set the display name for
     * @param xmlClass the xml element of the class being parsed
     */
    private void setLanguageAlias(MetaClassDetail metaClassDetail, electric.xml.Element xmlClass) {
        if (theMetadataDispenser.getGlobalInterface() != null) {
            String sIsoCode = theMetadataDispenser.getGlobalInterface().getLanguage().getISOCode();
            String sClassAlias = xmlClass.getAttribute(sIsoCode);
            if (sClassAlias != null)
                metaClassDetail.setDisplayName(sClassAlias);
        }
    }

    public MetaClass loadClass(electric.xml.Element xmlClass, MetaClass theParent) {
        return loadClass(null, xmlClass, theParent);
    }


    public MetaConstantGroup loadConstants(electric.xml.Element xmlConstantGroup) {
        String sGroupName = xmlConstantGroup.getName();
        MetaConstantGroup theGroup = theMetadataDispenser.findConstantGroup(sGroupName);
        if(theGroup==null)
            theGroup = new MetaConstantGroup(sGroupName, theMetadataDispenser);
        electric.xml.Elements theNames = xmlConstantGroup.getElements();
        int iNameCount = theNames.size();
        for (int i = 0; i < iNameCount; i++) {
            electric.xml.Element theName = theNames.next();
            String sName = theName.getName();
            String sValue = theName.getTextString();
            if ((sName != null) && (sValue != null))
                theGroup.set(sName, sValue);
        }
        return theGroup;
    }

    public MetaConstantGroupCollection loadConstantGroupCollections(electric.xml.Element xmlConstantGroupCollection) {
        String sCollectionName = xmlConstantGroupCollection.getName();
        MetaConstantGroupCollection theCollection = new MetaConstantGroupCollection(sCollectionName, theMetadataDispenser);
        electric.xml.Elements theNames = xmlConstantGroupCollection.getElements();
        int iNameCount = theNames.size();
        for (int i = 0; i < iNameCount; i++) {
            electric.xml.Element theName = theNames.next();
            String sName = theName.getName();
            MetaConstantGroup theGroup = theMetadataDispenser.findConstantGroup(sName);
            if (theGroup != null) {
                theCollection.addGroup(theGroup);
            }
        }
        return theCollection;
    }


    public boolean loadMeta(DropletSimpleLog theLog, String sSystemDocument) {
        if (bAlreadyLoaded == true)
            return true;
        theMetadataDispenser.theFirstClass = null;
        theMetadataDispenser.theLastClass = null;
        theMetadataDispenser.theFirstListener = null;
        theMetadataDispenser.theLastListener = null;
        HammerInputStream hisMetadataStream = theMetadataDispenser.getMetadataUser().getFileManager().getInputStream(sSystemDocument);
        if (theLog != null) {
            if (hisMetadataStream == null)
                theLog.writeMessage(sSystemDocument + " is not open!!!");
            else
                theLog.writeMessage("Input stream for metadata " + sSystemDocument + " is " + hisMetadataStream.toString());
        }
        if ((hisMetadataStream == null) || (hisMetadataStream.theStream == null))
            return false;

        this.mode = hisMetadataStream.mode;
        this.sFullPathName = hisMetadataStream.sFullPathName;
        this.sJarName = hisMetadataStream.sJarName;
        if (theLog != null) {
            theLog.writeMessage("MetadataMeta: " + sFullPathName);
            theLog.writeMessage("MetadataMeta Jar: " + sJarName);
        }

        InputStream theMetadataStream = new BufferedInputStream(hisMetadataStream.theStream);
        Document xmlSystemDocument = null;
        try {
            xmlSystemDocument = new Document(theMetadataStream);
        } catch (ParseException e) {
            e.printStackTrace();
            return false;
        }

        if (theLog != null)
            theLog.writeMessage("Metadata.meta has been loaded into an xml document.");
        electric.xml.Element xmlSystemRoot = xmlSystemDocument.getRoot();
        if (theLog != null) {
            if (xmlSystemRoot != null)
                theLog.writeMessage("System root is " + xmlSystemRoot.getTextString());
        }
        electric.xml.Element xmlDocumentComments = xmlSystemRoot.getElement("Comments");
        if (xmlDocumentComments != null) {
            sDocumentComments = xmlDocumentComments.getTextString();
        }

        // Version information
        electric.xml.Element xmlDesignBorderDefinition = xmlSystemRoot.getElement("DesignBorderDefinition");
        if (xmlDesignBorderDefinition != null) {
            theMetadataDispenser.sDesignBorderDefinition = xmlDesignBorderDefinition.getTextString();
        }
        electric.xml.Element xmlVersion = xmlSystemRoot.getElement("Version");
        if (xmlVersion != null) {
            theMetadataDispenser.theMetaDataAdministrator = new MetadataAdministrator(theMetadataDispenser, xmlVersion);
        }
        if (theMetadataDispenser.iMode == MetaObject.DESIGN_MODE) {
            electric.xml.Element xmlListenerRoot = xmlSystemRoot.getElement("Listeners");
            // Listeners. Must be loaded before classes for validation.
            if (xmlListenerRoot != null) {
                electric.xml.Elements xmlListeners = xmlListenerRoot.getElements();
                for (int iListener = 0; iListener < xmlListeners.size(); iListener++) {
                    electric.xml.Element xmlListener = xmlListeners.next();
                    MetaClass theMetaClass = loadClass(xmlListener, null);
                    if (theMetadataDispenser.theFirstListener == null)
                        theMetadataDispenser.theFirstListener = theMetaClass;
                    else
                        theMetadataDispenser.theLastListener.theNextSibling = theMetaClass;
                    theMetaClass.thePrevSibling = theMetadataDispenser.theLastClass;
                    theMetadataDispenser.theLastListener = theMetaClass;
                    theMetadataDispenser.iListenerCount++;
                }
            }
            // Add basic listeners that all classes get.
            int iBasicSwingListeners = theMetadataDispenser.theListenerCollection.iListenerCount;
            for (int iListener = 0; iListener < iBasicSwingListeners; iListener++) {
                MetaClassDetail theListenerMetadata = theMetadataDispenser.theListenerCollection.getDefaultListenerClassMetadata(iListener);
                theListenerMetadata.sClassName = theMetadataDispenser.theListenerCollection.getDefaultListenerName(iListener);
                theListenerMetadata.sAddListenerMethod = theMetadataDispenser.theListenerCollection.getAddListenerName(iListener);
                theListenerMetadata.sRemoveListenerMethod = theMetadataDispenser.theListenerCollection.getRemoveListenerName(iListener);
                MetaClass theListener = new MetaClass(theListenerMetadata, null, theMetadataDispenser, true);
                if (theListener != null) {
                    if (theMetadataDispenser.theFirstListener == null)
                        theMetadataDispenser.theFirstListener = theListener;
                    else
                        theMetadataDispenser.theLastListener.theNextSibling = theListener;
                    theListener.thePrevSibling = theMetadataDispenser.theLastClass;
                    theMetadataDispenser.theLastListener = theListener;
                    theMetadataDispenser.iListenerCount++;
                }
            }
        }
        if (theLog != null)
            theLog.writeMessage("About to load constants.");
        // Constants.
        electric.xml.Element xmlConstantsRoot = xmlSystemRoot.getElement("Constants");
        if (xmlConstantsRoot != null) {
            electric.xml.Elements xmlTypes = xmlConstantsRoot.getElements();
            for (int iType = 0; iType < xmlTypes.size(); iType++) {
                electric.xml.Element xmlType = xmlTypes.next();
                MetaConstantGroup theMetaConstantGroup = loadConstants(xmlType);
                if (theMetadataDispenser.theFirstMetaConstantGroup == null)
                    theMetadataDispenser.theFirstMetaConstantGroup = theMetaConstantGroup;
                else
                    theMetadataDispenser.theLastMetaConstantGroup.theNextSibling = theMetaConstantGroup;
                theMetaConstantGroup.thePrevSibling = theMetadataDispenser.theLastMetaConstantGroup;
                theMetadataDispenser.theLastMetaConstantGroup = theMetaConstantGroup;
            }
        }
        // Constant Group Collections
        electric.xml.Element xmlConstantCollectionsRoot = xmlSystemRoot.getElement("ConstantCollections");
        if (xmlConstantCollectionsRoot != null) {
            electric.xml.Elements xmlTypes = xmlConstantCollectionsRoot.getElements();
            for (int iType = 0; iType < xmlTypes.size(); iType++) {
                electric.xml.Element xmlType = xmlTypes.next();
                MetaConstantGroupCollection theMetaConstantGroupCollection = loadConstantGroupCollections(xmlType);
                if (theMetadataDispenser.theFirstMetaConstantGroupCollection == null)
                    theMetadataDispenser.theFirstMetaConstantGroupCollection = theMetaConstantGroupCollection;
                else
                    theMetadataDispenser.theLastMetaConstantGroupCollection.theNextSibling = theMetaConstantGroupCollection;
                theMetaConstantGroupCollection.thePreviousSibling = theMetadataDispenser.theLastMetaConstantGroupCollection;
                theMetadataDispenser.theLastMetaConstantGroupCollection = theMetaConstantGroupCollection;
            }
        }
        if (theLog != null)
            theLog.writeMessage("About to load classes.");
        // Now normal classes.
        electric.xml.Element xmlClassesRoot = xmlSystemRoot.getElement("Classes");
        // Classes.  Must be loaded before objects for validation.
        if (xmlClassesRoot != null) {
            if (theLog != null)
                theLog.writeMessage("There are classes.");
            electric.xml.Elements xmlClasses = xmlClassesRoot.getElements();
            for (int iClass = 0; iClass < xmlClasses.size(); iClass++) {
                electric.xml.Element xmlClass = xmlClasses.next();
                MetaClass theMetaClass = loadClass(theLog, xmlClass, null);
                if (theMetadataDispenser.theFirstClass == null)
                    theMetadataDispenser.theFirstClass = theMetaClass;
                else
                    theMetadataDispenser.theLastClass.theNextSibling = theMetaClass;
                theMetaClass.thePrevSibling = theMetadataDispenser.theLastClass;
                theMetadataDispenser.theLastClass = theMetaClass;
            }

            bAlreadyLoaded = true;
            return true;
        } else {
            if (theLog != null)
                theLog.writeMessage("There are no classes!");
        }

        return false;
    }

    protected boolean loadCustomMeta(InputStream customMetadataStream)
    {

        Document xmlReposit = null;

        try
        {
            InputStream repoMetadataStream = new BufferedInputStream(customMetadataStream);
            xmlReposit = new Document(repoMetadataStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }


        electric.xml.Element xmlRepoRootClass = xmlReposit.getRoot();
        // Constants.
        electric.xml.Element xmlConstantsRoot = xmlRepoRootClass.getElement("Constants");
        if (xmlConstantsRoot != null) {
            electric.xml.Elements xmlTypes = xmlConstantsRoot.getElements();
            for (int iType = 0; iType < xmlTypes.size(); iType++) {
                electric.xml.Element xmlType = xmlTypes.next();
                String sGroupName = xmlType.getName();
                MetaConstantGroup theGroup = theMetadataDispenser.findConstantGroup(sGroupName);

                MetaConstantGroup theMetaConstantGroup = loadConstants(xmlType);
                // If theGroup  is null then this a new ConstantGroup from the custom metadata
                // if not then the items were added to an existing constant group.
                if(theGroup==null)
                {
                    if (theMetadataDispenser.theFirstMetaConstantGroup == null)
                        theMetadataDispenser.theFirstMetaConstantGroup = theMetaConstantGroup;
                    else
                        theMetadataDispenser.theLastMetaConstantGroup.theNextSibling = theMetaConstantGroup;
                    theMetaConstantGroup.thePrevSibling = theMetadataDispenser.theLastMetaConstantGroup;
                    theMetadataDispenser.theLastMetaConstantGroup = theMetaConstantGroup;
                }
            }
        }

        if (theMetadataDispenser.iMode == MetaObject.DESIGN_MODE) {
            electric.xml.Element xmlListenerRoot = xmlRepoRootClass.getElement("Listeners");
            // Listeners. Must be loaded before classes for validation.
            if (xmlListenerRoot != null) {
                electric.xml.Elements xmlListeners = xmlListenerRoot.getElements();
                for (int iListener = 0; iListener < xmlListeners.size(); iListener++) {
                    electric.xml.Element xmlListener = xmlListeners.next();
                    MetaClass theMetaClass = loadClass(xmlListener, null);
                    if (theMetadataDispenser.theFirstListener == null)
                        theMetadataDispenser.theFirstListener = theMetaClass;
                    else
                        theMetadataDispenser.theLastListener.theNextSibling = theMetaClass;
                    theMetaClass.thePrevSibling = theMetadataDispenser.theLastClass;
                    theMetadataDispenser.theLastListener = theMetaClass;
                    theMetadataDispenser.iListenerCount++;
                }
            }
        }
        electric.xml.Element xmlRepoClasses = xmlRepoRootClass.getElement("Classes");
        electric.xml.Elements xmlCustomClasses = xmlRepoClasses.getElements();

        String parenClass =xmlCustomClasses.first().getName();
        MetaClass pClass = theMetadataDispenser.findClass(parenClass);

        if(pClass!=null)
        {
            electric.xml.Element xmlRepoClassesEx = xmlCustomClasses.first().getElement("Classes");
            xmlCustomClasses = xmlRepoClassesEx.getElements();
        }

        for (int iClass = 0;iClass < xmlCustomClasses.size(); iClass++)
        {
            electric.xml.Element xmlRepoClass = xmlCustomClasses.next();

            MetaClass repositMetaClass = loadClass(null,xmlRepoClass, pClass);
            if(pClass==null)
            {
                theMetadataDispenser.theLastClass.theNextSibling = repositMetaClass;
                repositMetaClass.thePrevSibling = theMetadataDispenser.theLastClass;
                theMetadataDispenser.theLastClass = repositMetaClass;
            }
        }

        return true;
    }

    public boolean loadCustomMeta(String sSystemDocument,String repositoryLocation)
    {
        if (bCustomAlreadyLoaded == true)
            return true;

        HammerInputStream hisMetadataStream = theMetadataDispenser.getMetadataUser().getFileManager().getInputStream(sSystemDocument);

        if ((hisMetadataStream == null) || (hisMetadataStream.theStream == null))
            return false;

        FilenameFilter filter = new FilenameFilter() {
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };

        HammerInputStream  jarRepoMetadataStream  = null;

        // 2005/08/10, acg: fixed Unix path problems.

        String dirRepositories[] = repositoryLocation.split(File.pathSeparator);

        for(int c=0;c < dirRepositories.length;c++)
        {
            File dir = new File(dirRepositories[c]);

            String[] children = dir.list(filter);
            if (children == null)
            {
                 // This sections opens a Jar in order to look for the metadata s-b-s files.
                HammerClassByteFileLoader tmpByteFileLoader = theMetadataDispenser.getMetadataUser().getClassLoader().getLoader().classByteFileLoader;
                ArrayList e= tmpByteFileLoader.getFilesInPath(repositoryLocation);

                for(int i=0;i < e.size();i++)
                {
                    String repositoryFile= (String)e.get(i);
                    jarRepoMetadataStream = theMetadataDispenser.getMetadataUser().getFileManager().getInputStream(repositoryFile);
                    if(jarRepoMetadataStream.sJarName==null)
                        return false;
                    loadCustomMeta(jarRepoMetadataStream.theStream);
                }
                bCustomAlreadyLoaded = true;
                return true;
            }

            // This sections opens a physical dir on disk

            for (int i=0; i<children.length; i++)
            {
                // Get filename of file or directory
                String filename = new StringBuffer().append(dirRepositories[c]).append(File.separator).append(children[i]).toString();
                InputStream  repoHammerMetadataStream = null;
                try
                {
                    repoHammerMetadataStream = new FileInputStream(filename);
                }
                catch (java.io.FileNotFoundException e) {
                    e.printStackTrace();
                }
                loadCustomMeta(repoHammerMetadataStream);
            }

        }
        bCustomAlreadyLoaded = true;
        return true;
    }

    public boolean loadMeta(String sSystemDocument) {
        if (bAlreadyLoaded == true)
            return true;

        HammerInputStream hisMetadataStream = theMetadataDispenser.getMetadataUser().getFileManager().getInputStream(sSystemDocument);
        return loadMeta(hisMetadataStream);

    }

    public boolean loadMeta(HammerInputStream hisMetadataStream) {
        if ((hisMetadataStream == null) || (hisMetadataStream.theStream == null))
            return false;

        theMetadataDispenser.theFirstClass = null;
        theMetadataDispenser.theLastClass = null;
        theMetadataDispenser.theFirstListener = null;
        theMetadataDispenser.theLastListener = null;

        this.mode = hisMetadataStream.mode;
        this.sFullPathName = hisMetadataStream.sFullPathName;
        this.sJarName = hisMetadataStream.sJarName;
        this.sJarEntryName = hisMetadataStream.sJarEntryName;

        InputStream theMetadataStream = new BufferedInputStream(hisMetadataStream.theStream);
        Document xmlSystemDocument = null;
        try {
            xmlSystemDocument = new Document(theMetadataStream);
        } catch (ParseException e) {
            return false;
        }
        Element xmlSystemRoot = xmlSystemDocument.getRoot();

        Element xmlDocumentComments = xmlSystemRoot.getElement("Comments");
        if (xmlDocumentComments != null) {
            sDocumentComments = xmlDocumentComments.getTextString();
        }

        // Version information
        Element xmlDesignBorderDefinition = xmlSystemRoot.getElement("DesignBorderDefinition");
        if (xmlDesignBorderDefinition != null) {
            theMetadataDispenser.sDesignBorderDefinition = xmlDesignBorderDefinition.getTextString();
        }
        Element xmlVersion = xmlSystemRoot.getElement("Version");
        if (xmlVersion != null) {
            theMetadataDispenser.theMetaDataAdministrator = new MetadataAdministrator(theMetadataDispenser, xmlVersion);
        }
        if (theMetadataDispenser.iMode == MetaObject.DESIGN_MODE) {
            Element xmlListenerRoot = xmlSystemRoot.getElement("Listeners");
            // Listeners. Must be loaded before classes for validation.
            if (xmlListenerRoot != null) {
                electric.xml.Elements xmlListeners = xmlListenerRoot.getElements();
                for (int iListener = 0; iListener < xmlListeners.size(); iListener++) {
                    Element xmlListener = xmlListeners.next();
                    MetaClass theMetaClass = loadClass(xmlListener, null);
                    if (theMetadataDispenser.theFirstListener == null)
                        theMetadataDispenser.theFirstListener = theMetaClass;
                    else
                        theMetadataDispenser.theLastListener.theNextSibling = theMetaClass;
                    theMetaClass.thePrevSibling = theMetadataDispenser.theLastClass;
                    theMetadataDispenser.theLastListener = theMetaClass;
                    theMetadataDispenser.iListenerCount++;
                }
            }
            // Add basic listeners that all classes get.
            int iBasicSwingListeners = theMetadataDispenser.theListenerCollection.iListenerCount;
            for (int iListener = 0; iListener < iBasicSwingListeners; iListener++) {
                MetaClassDetail theListenerMetadata = theMetadataDispenser.theListenerCollection.getDefaultListenerClassMetadata(iListener);
                theListenerMetadata.sClassName = theMetadataDispenser.theListenerCollection.getDefaultListenerName(iListener);
                theListenerMetadata.sAddListenerMethod = theMetadataDispenser.theListenerCollection.getAddListenerName(iListener);
                theListenerMetadata.sRemoveListenerMethod = theMetadataDispenser.theListenerCollection.getRemoveListenerName(iListener);
                MetaClass theListener = new MetaClass(theListenerMetadata, null, theMetadataDispenser, true);
                if (theListener != null) {
                    if (theMetadataDispenser.theFirstListener == null)
                        theMetadataDispenser.theFirstListener = theListener;
                    else
                        theMetadataDispenser.theLastListener.theNextSibling = theListener;
                    theListener.thePrevSibling = theMetadataDispenser.theLastClass;
                    theMetadataDispenser.theLastListener = theListener;
                    theMetadataDispenser.iListenerCount++;
                }
            }
        }
        // Constants.
        Element xmlConstantsRoot = xmlSystemRoot.getElement("Constants");
        if (xmlConstantsRoot != null) {
            electric.xml.Elements xmlTypes = xmlConstantsRoot.getElements();
            for (int iType = 0; iType < xmlTypes.size(); iType++) {
                Element xmlType = xmlTypes.next();
                MetaConstantGroup theMetaConstantGroup = loadConstants(xmlType);
                if (theMetadataDispenser.theFirstMetaConstantGroup == null)
                    theMetadataDispenser.theFirstMetaConstantGroup = theMetaConstantGroup;
                else
                    theMetadataDispenser.theLastMetaConstantGroup.theNextSibling = theMetaConstantGroup;
                theMetaConstantGroup.thePrevSibling = theMetadataDispenser.theLastMetaConstantGroup;
                theMetadataDispenser.theLastMetaConstantGroup = theMetaConstantGroup;
            }
        }
        // Constant Group Collections
        Element xmlConstantCollectionsRoot = xmlSystemRoot.getElement("ConstantCollections");
        if (xmlConstantCollectionsRoot != null) {
            electric.xml.Elements xmlTypes = xmlConstantCollectionsRoot.getElements();
            for (int iType = 0; iType < xmlTypes.size(); iType++) {
                Element xmlType = xmlTypes.next();
                MetaConstantGroupCollection theMetaConstantGroupCollection = loadConstantGroupCollections(xmlType);
                if (theMetadataDispenser.theFirstMetaConstantGroupCollection == null)
                    theMetadataDispenser.theFirstMetaConstantGroupCollection = theMetaConstantGroupCollection;
                else
                    theMetadataDispenser.theLastMetaConstantGroupCollection.theNextSibling = theMetaConstantGroupCollection;
                theMetaConstantGroupCollection.thePreviousSibling = theMetadataDispenser.theLastMetaConstantGroupCollection;
                theMetadataDispenser.theLastMetaConstantGroupCollection = theMetaConstantGroupCollection;
            }
        }
        // Now normal classes.
        Element xmlClassesRoot = xmlSystemRoot.getElement("Classes");
        // Classes.  Must be loaded before objects for validation.
        if (xmlClassesRoot != null) {
            electric.xml.Elements xmlClasses = xmlClassesRoot.getElements();
            for (int iClass = 0; iClass < xmlClasses.size(); iClass++) {
                Element xmlClass = xmlClasses.next();
                MetaClass theMetaClass = loadClass(xmlClass, null);
                if (theMetadataDispenser.theFirstClass == null)
                    theMetadataDispenser.theFirstClass = theMetaClass;
                else
                    theMetadataDispenser.theLastClass.theNextSibling = theMetaClass;
                theMetaClass.thePrevSibling = theMetadataDispenser.theLastClass;
                theMetadataDispenser.theLastClass = theMetaClass;
            }
            bAlreadyLoaded = true;
            return true;
        }

        return false;
    }


    public boolean writeMetaDocument() {
        String sOutputDocumentName;
        String sConfigPath = theMetadataDispenser.getMetadataUser().getSystemConfigurationPathName();
        if (sConfigPath != null)
            sOutputDocumentName = sConfigPath + theMetadataDispenser.getMetadataUser().getSystemMetadataDocumentName();
        else
            sOutputDocumentName = theMetadataDispenser.getMetadataUser().getSystemMetadataDocumentName();
        if (sOutputDocumentName == null)
            sOutputDocumentName = "metadata.meta";
        if (mode == HammerInputStream.FROM_FILE)
            sOutputDocumentName = this.sFullPathName;
//        MetaProjectHeader theProgram = getDesignProject().theProgramData = getProgramMetadata();
        MetaClass theFirstClass = null;
        MetaClass theLastClass = null;
        /**
         * Build the class heirarchy for the meta file. Cloning.
         */
        MetaClass theClass = theMetadataDispenser.theFirstClass;
        while (theClass != null) {
            MetaClassDetail theClassMetadata = new MetaClassDetail(theClass.getMetadata(), theMetadataDispenser);
            // Write all classes in the saved document.
            theClassMetadata.bUsed = true;
            // Make new class.
            MetaClass theNewClass = new MetaClass(theClassMetadata,
                    theMetadataDispenser.theFirstClass, theMetadataDispenser, true);
            if (theMetadataDispenser.iMode == MetaObject.DESIGN_MODE) {
                // Add special listeners (non default ones - stored in this class)
                MetaClassDetail theListener = theClass.theMetadata.theFirstListener;
                while (theListener != null) {
                    int i = 0;
                    String theListenerName = theListener.sClassName;
                    for (i = 0; i < theMetadataDispenser.getDefaultListenerCount(); i++) {
                        if (theListenerName.equals(theMetadataDispenser.theListenerCollection.getDefaultListenerName(i)))
                            break;
                    }
                    if (i == theMetadataDispenser.getDefaultListenerCount())  // not a default, need to add.
                        theNewClass.addListener(theListenerName, theMetadataDispenser);
                    theListener = theListener.theNextClass;
                }
            }
            // Update the list of cloned classes.
            if (theFirstClass == null)
                theFirstClass = theNewClass;
            else
                theLastClass.theNextSibling = theNewClass;
            theLastClass = theNewClass;
            if (theClass.theFirstClass != null)
                doMetaDocChildren(theNewClass, theClass.theFirstClass);
            theClass = theClass.theNextSibling;
        }
        /**
         * We now have enough information to write the file.
         */
        MetadataDocumentGenerator theGenerator =
                new MetadataDocumentGenerator(sOutputDocumentName, theFirstClass, theLastClass);
        theGenerator.GenerateFromMetadata(theMetadataDispenser);
        return true;
    }

    /**
     * Add a design class to theClass for every sibling of theFirstClass
     */

    void doMetaDocChildren(MetaClass theParentClass, MetaClass theFirstClass) {
        MetaClass theClass = theFirstClass;
        while (theClass != null) {
            MetaClassDetail theClassMetadata = new MetaClassDetail(theClass.theMetadata, theMetadataDispenser);
            // Always true for writing the project.
            theClassMetadata.bUsed = true;
            MetaClass theNewClass = new MetaClass(theClassMetadata, theParentClass, theMetadataDispenser, true);

            if (theParentClass.theFirstClass == null)
                theParentClass.theFirstClass = theNewClass;
            else
                theParentClass.theLastClass.theNextSibling = theNewClass;
            theParentClass.theLastClass = theNewClass;
            if (theClass.theFirstClass != null)
                doMetaDocChildren(theNewClass, theClass.theFirstClass);
            theClass = theClass.theNextSibling;
        }
    }

    public boolean isCustomMetadataComplete()
    {
        return bLoadingComplete;
    }

    public void setCustomMetadataComplete(boolean bFlag)
    {
        bLoadingComplete=bFlag;
    }

    public boolean isbAlreadyLoaded() {
        return bAlreadyLoaded;
    }

    public void setbAlreadyLoaded(boolean bAlreadyLoaded) {
        this.bAlreadyLoaded = bAlreadyLoaded;
    }


}
