/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.JATextArea;

import javax.swing.*;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import java.awt.*;
import java.util.Hashtable;

/**
 * Created by IntelliJ IDEA.
 * User: michael
 * Date: May 5, 2003
 * Time: 10:15:45 PM
 * To change this template use Options | File Templates.
 */
public class HammerSourceTextArea extends JATextArea implements UndoableEditListener {

    Hashtable actions;
    JAScrollPane thePane = null;
    public HammerEditorPopupMenu thePopupMenu = null;
    //Setting Undo Limit to 1500 edits
    public static final int UNDO_LIMIT = 1500;

    //UndoManager
    private UndoManager m_undoManager;

    public HammerSourceTextArea() {
        super();
        createActionTable();
        //add the UndoableEditListener to the TextArea
        getDocument().addUndoableEditListener(this);
        //add the KeyListener
        //addKeyListener(this);
        createUndoMananger();
    }

    public HammerSourceTextArea(int iRows, int iCols) {
        super(iRows, iCols);
        createActionTable();
        //add the UndoableEditListener to the TextArea
        getDocument().addUndoableEditListener(this);
        //add the KeyListener
        //addKeyListener(this);
        createUndoMananger();
    }

    private void createActionTable() {
        actions = new Hashtable();
        Action[] actionsArray = getActions();
        for (int i = 0; i < actionsArray.length; i++) {
            Action a = actionsArray[i];
            String theName = (String) a.getValue(Action.NAME);
            actions.put(theName, a);
        }
    }

    public Action getActionByName(String name) {
        return (Action) (actions.get(name));
    }

    public void setPane(JAScrollPane objPane) {
        thePane = objPane;
    }

    /**
     * fixupSize maintains preferred size.
     */

    public void fixupSize() {
        int iRows = getRows();
        int iColumns = getColumns();
        Font theFont = getFont();
        if (theFont != null) {
            FontMetrics theFontMetrics = getFontMetrics(theFont);
            if (theFontMetrics != null) {
                int iXSize = iColumns * theFontMetrics.stringWidth("m    WXZ") / 8;
                int iYSize = iRows * theFontMetrics.getHeight();
                thePane.setPreferredSize(new Dimension(iXSize, iYSize));
            }
        }
    }

    //createUndoMananger creating undo manager
    private void createUndoMananger() {
        m_undoManager = new UndoManager();
        m_undoManager.setLimit(UNDO_LIMIT);
    }


    //undoableEditHappened called when edit happened
    public void undoableEditHappened(UndoableEditEvent e) {
        //add the edits to the unod manager
        m_undoManager.addEdit(e.getEdit());
    }

    public boolean undo() {
        try {
            //Undo changes
            m_undoManager.undo();
        } catch (CannotUndoException cue) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        return true;
    }

    public boolean redo() {
        try {
            //Redo changes
            m_undoManager.redo();
        } catch (CannotRedoException cue) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        return true;
    }

//    public void keyPressed(KeyEvent e)
//    {
//        //identify the key pressed is the combination of
//        //Controlkey and Z key
//        if((e.getKeyCode() == KeyEvent.VK_Z) && (e.isControlDown()))
//        {
//            try
//            {
//                //Undo changes
//                m_undoManager.undo();
//            }
//            catch(CannotUndoException cue)
//            {
//                Toolkit.getDefaultToolkit().beep();
//            }
//        }
//
//        //identify the key pressed is the combination of
//        //Controlkey and Y key
//        if((e.getKeyCode() == KeyEvent.VK_Y) && (e.isControlDown()))
//        {
//            try
//            {
//                //Redo changes
//                m_undoManager.redo();
//            }
//            catch(CannotRedoException cue)
//            {
//                Toolkit.getDefaultToolkit().beep();
//            }
//        }
//    }
//
//    public void keyReleased(KeyEvent e)
//    {
//    }
//
//    public void keyTyped(KeyEvent e)
//    {
//    }
//
}
