/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

package ch.abacus.lib.ui.renderer.common;

import javax.swing.event.*;
import java.awt.event.*;

/**
 * Title:        uifactory
 * Description:
 * Copyright:    Copyright (c) 2001
 * Company:      Abacus Research
 * @author Michael Gouker (Cagey Logic)
 * @version 1.0
 */

class UIFactoryComponentAdapter extends ComponentAdapter {
    /**
     * Invoked when component has been hidden.
     */
    public void componentHidden(ComponentEvent e) {
    }

    /**
     * Invoked when component has been moved.
     */
    public void componentMoved(ComponentEvent e) {
    }

    /**
     * Invoked when component has been resized.
     */
    public void componentResized(ComponentEvent e) {
    }

    /**
     * Invoked when component has been shown
     */
    public void componentShown(ComponentEvent e) {
    }
}

class UIFactoryContainerAdapter extends ContainerAdapter {
    /**
     *      Invoked when a component has been added to the container.
     */
    public void componentAdded(ContainerEvent e) {
    }

    /**
     *     Invoked when a component has been removed from the container.
     */
    public void componentRemoved(ContainerEvent e) {
    }
}

class UIFactoryFocusAdapter extends FocusAdapter {

    /**
     *    Invoked when a component gains the keyboard focus.
     */
    public void focusGained(FocusEvent e) {
    }

    /**
     *    Invoked when a component loses the keyboard focus.
     */
    public void focusLost(FocusEvent e) {
    }

}

class UIFactoryKeyAdapter extends KeyAdapter {
    /**
     *           Invoked when a key has been pressed.
     */
    public void keyPressed(KeyEvent e) {
    }

    /**
     *           Invoked when a key has been released.
     */
    public void keyReleased(KeyEvent e) {
    }

    /**
     *           Invoked when a key has been typed.
     */
    public void keyTyped(KeyEvent e) {
    }
}

class UIFactoryMouseAdapter extends MouseAdapter {
    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }
}

class UIFactoryMouseMotionAdapter extends MouseMotionAdapter {
    public void mouseMoved(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
    }
}

class UIFactoryWindowAdapter extends WindowAdapter {
    /**
     *           Invoked when the Window is set to be the active Window.
     */
    public void windowActivated(WindowEvent e) {
    }

    /**
     *           Invoked when a window has been closed as the result of calling dispose on the window.
     */
    public void windowClosed(WindowEvent e) {
    }

    /**
     *           Invoked when the user attempts to close the window from the window's system menu.
     */

    public void windowClosing(WindowEvent e) {
    }

    /**
     *           Invoked when a Window is no longer the active Window.
     */
    public void windowDeactivated(WindowEvent e) {
    }

    /**
     *           Invoked when a window is changed from a minimized to a normal state.
     */
    public void windowDeiconified(WindowEvent e) {
    }

    /**
     *           Invoked when a window is changed from a normal to a minimized state.
     */
    public void windowIconified(WindowEvent e) {
    }

    /**
     *           Invoked the first time a window is made visible.
     */
    public void windowOpened(WindowEvent e) {
    }

}

class UIFactoryActionListener implements ActionListener {
    /**
     *           Invoked when an action occurs.
     */
    public void actionPerformed(ActionEvent e) {
    }
}

class UIFactoryAdjustmentListener implements AdjustmentListener {
    /**
     *      Invoked when the value of the adjustable has changed.
     */
    public void adjustmentValueChanged(AdjustmentEvent e) {
    }
}

class UIFactoryAncestorListener implements AncestorListener {
    /**
     *          Called when the source or one of its ancestors is made visible
     *          either by setVisible(true) being called or by its being added to the component hierarchy.
     */
    public void ancestorAdded(AncestorEvent event) {
    }

    /**
     *         Called when either the source or one of its ancestors is moved.
     */
    public void ancestorMoved(AncestorEvent event) {
    }

    /**
     *  Called when the source or one of its ancestors is made invisible either
     *  by setVisible(false) being called or by its being remove from the
     *  component hierarchy.
     */
    public void ancestorRemoved(AncestorEvent event) {
    }
}

class UIFactoryChangeListener implements ChangeListener {
    /**
     * Called when the state of the object is changed.
     */
    public void stateChanged(ChangeEvent event) {
    }
}

class UIFactoryItemListener implements ItemListener {
    /**
     * Called when the state of the object is changed.
     */
    public void itemStateChanged(ItemEvent event) {
    }
}

class UIFactoryListSelectionListener implements ListSelectionListener {
    /**
     * Called when the state of the object is changed.
     */
    public void valueChanged(ListSelectionEvent event) {
    }
}

class UIFactoryTreeSelectionListener implements TreeSelectionListener {
    /**
     * Called when the state of the object is changed.
     */
    public void valueChanged(TreeSelectionEvent event) {
    }
}

//      objDefaultListeners[14] = new UIFactoryMenuListener();
//      objDefaultListeners[15] = new UIFactoryCellEditorListener();
//      objDefaultListeners[16] = new UIFactoryDocumentListener();
//      objDefaultListeners[17] = new UIFactoryPropertyChangeListener();


public class ListenerCollection {
    static final int DEFAULT_LISTENERS = 14;
    public ListenerEntry[] objDefaultListeners = {

        new ListenerEntry("ComponentAdapter", new UIFactoryComponentAdapter(), "addComponentListener", "removeComponentListener"),
        new ListenerEntry("ContainerAdapter", new UIFactoryContainerAdapter(), "addContainerListener", "removeContainerListener"),
        new ListenerEntry("FocusAdapter", new UIFactoryFocusAdapter(), "addFocusListener", "removeFocusListener"),
        new ListenerEntry("KeyAdapter", new UIFactoryKeyAdapter(), "addKeyListener", "removeKeyListener"),
        new ListenerEntry("MouseAdapter", new UIFactoryMouseAdapter(), "addMouseListener", "removeMouseListener"),
        new ListenerEntry("MouseMotionAdapter", new UIFactoryMouseMotionAdapter(), "addMouseMotionListener", "removeMouseMotionListener"),

        new ListenerEntry("AncestorListener", new UIFactoryAncestorListener(), "addAncestorListener", "removeAncestorListener"),

        new ListenerEntry("WindowAdapter", new UIFactoryWindowAdapter(), "addWindowListener", "removeWindowListener"),

        new ListenerEntry("ActionListener", new UIFactoryActionListener(), "addActionListener", "removeActionListener"),
        new ListenerEntry("AdjustmentListener", new UIFactoryAdjustmentListener(), "addAdjustmentListener", "removeAdjustmentListener"),
        new ListenerEntry("ChangeListener", new UIFactoryChangeListener(), "addChangeListener", "removeChangeListener"),
        new ListenerEntry("ItemListener", new UIFactoryItemListener(), "addItemListener", "removeItemListener"),
        new ListenerEntry("ListSelectionListener", new UIFactoryListSelectionListener(), "addListSelectionListener", "removeListSelectionListener"),
        new ListenerEntry("TreeSelectionListener", new UIFactoryTreeSelectionListener(), "addTreeSelectionListener", "removeTreeSelectionListener")
    };
    public final int iDefaultListeners = 7;
    public int iListenerCount = DEFAULT_LISTENERS;
    public final int iContainerListenerIndex = 1;

    public ListenerCollection() {
    }

    public Class getDefaultListenerClass(int i) {
        return objDefaultListeners[i].objExample.getClass();
    }

    public int getDefaultListenerClass(String sClassName) {
        for (int i = 0; i < objDefaultListeners.length; i++) {
            if (sClassName.equals(objDefaultListeners[i].sInterfaceName))
                return i;
        }
        return -1;
    }

    public MetaClassDetail getDefaultListenerClassMetadata(int i) {
        return new MetaClassDetail(objDefaultListeners[i].objExample.getClass());
    }

    public int getContainerListener() {
        return iContainerListenerIndex;
    }

    public String getDefaultListenerName(int i) {
        return objDefaultListeners[i].sInterfaceName;
    }

    public String getAddListenerName(int i) {
        return objDefaultListeners[i].sAddListenerMethod;
    }

    public String getRemoveListenerName(int i) {
        return objDefaultListeners[i].sRemoveListenerMethod;
    }

}
