/*
 * 2004  Abacus Research AG , St. Gallen , Switzerland . All rights reserved.
 * Terms of Use under The GNU GENERAL PUBLIC LICENSE Version 2
 *
 * THIS SOFTWARE IS PROVIDED BY ABACUS RESEARCH AG ``AS IS'' AND ANY EXPRESS 
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR 
 * NON-INFRINGEMENT, ARE DISCLAIMED. IN NO EVENT SHALL ABACUS RESEARCH AG BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * Average.java  
 *
 * Creator:
 * 09.12.2005 08:54:09 pecar
 *
 * Maintainer:
 * 09.12.2005 08:54:09 pecar
 *
 * Last Modification:
 * $Id: AverageLong.java,v 1.1 2005/12/09 15:26:20 pecar Exp $
 *
 * Copyright (c) 2005 ABACUS Research AG, All Rights Reserved
 */
package ch.abacus.lib.util.math;

/**
 * a class for calculating an average amount
 */
public class AverageLong {
    private long mSum;
    private int mCount;

    public void add(long value) {
        mSum += value;
        mCount++;
    }

    public void add(int value) {
        mSum += value;
        mCount++;
    }

    public float getFloatValue() {
        return (float) mSum / (float) mCount;
    }

    public long getLongValue() {
        return mSum / mCount;
    }

    public int getCount() {
        return mCount;
    }

    public long getSum() {
        return mSum;
    }

    public void reset() {
        mSum = 0;
        mCount = 0;
    }
}
