/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.csharp.importer.csparser.types;

import java.util.ArrayList;
import java.util.List;
import org.argouml.language.csharp.importer.csparser.collections.NodeCollection;
import org.argouml.language.csharp.importer.csparser.members.ConstantNode;
import org.argouml.language.csharp.importer.csparser.members.ConstructorNode;
import org.argouml.language.csharp.importer.csparser.members.DestructorNode;
import org.argouml.language.csharp.importer.csparser.members.EventNode;
import org.argouml.language.csharp.importer.csparser.members.FieldNode;
import org.argouml.language.csharp.importer.csparser.members.IndexerNode;
import org.argouml.language.csharp.importer.csparser.members.MethodNode;
import org.argouml.language.csharp.importer.csparser.members.PropertyNode;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.BaseNode;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.IdentifierExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.TypeNode;

public class ClassNode
extends BaseNode {
    public long Modifiers;
    public IdentifierExpression Name;
    public List<TypeNode> BaseClasses = new ArrayList<TypeNode>();
    public NodeCollection<ConstantNode> Constants = new NodeCollection();
    public NodeCollection<FieldNode> Fields = new NodeCollection();
    public NodeCollection<PropertyNode> Properties = new NodeCollection();
    public NodeCollection<ConstructorNode> Constructors = new NodeCollection();
    public NodeCollection<DestructorNode> Destructors = new NodeCollection();
    public NodeCollection<MethodNode> Methods = new NodeCollection();
    public NodeCollection<IndexerNode> Indexers = new NodeCollection();
    public NodeCollection<EventNode> Events = new NodeCollection();

    public void ToSource(StringBuilder sb) {
        this.WriteLocalSource(sb, "class");
    }

    protected void WriteLocalSource(StringBuilder sb, String kind) {
        if (this.attributes != null) {
            this.attributes.ToSource(sb);
            this.NewLine(sb);
        }
        this.TraceModifiers(this.Modifiers, sb);
        sb.append(kind + " ");
        this.Name.ToSource(sb);
        sb.append(" ");
        if (this.BaseClasses != null && this.BaseClasses.size() > 1) {
            sb.append(": ");
            String comma = "";
            for (TypeNode bcls : this.BaseClasses) {
                sb.append(comma);
                comma = ", ";
                bcls.ToSource(sb);
            }
        }
        this.NewLine(sb);
        sb.append("{");
        ++indent;
        this.NewLine(sb);
        if (this.Constants != null) {
            this.Constants.ToSource(sb);
        }
        if (this.Fields != null) {
            this.Fields.ToSource(sb);
        }
        if (this.Properties != null) {
            this.Properties.ToSource(sb);
        }
        if (this.Constructors != null) {
            this.Constructors.ToSource(sb);
        }
        if (this.Methods != null) {
            this.Methods.ToSource(sb);
        }
        if (this.Indexers != null) {
            this.Indexers.ToSource(sb);
        }
        if (this.Events != null) {
            this.Events.ToSource(sb);
        }
        if (this.Destructors != null) {
            this.Destructors.ToSource(sb);
        }
        --indent;
        this.NewLine(sb);
        sb.append("}");
        this.NewLine(sb);
    }
}

