/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.reveng.classfile;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserUtils {
    public static String convertFieldDescriptor(String desc) {
        return ParserUtils.convertFieldDescriptor(new FieldDescriptorLexer(desc).parse());
    }

    public static String[] convertMethodDescriptor(String desc) {
        LinkedList<String> buf = new LinkedList<String>();
        MethodDescriptorLexer lexer = new MethodDescriptorLexer(desc);
        for (Token t : lexer.parse()) {
            buf.add(t.getValue());
        }
        return buf.toArray(new String[0]);
    }

    public static String convertFieldTypeSignature(String desc) {
        List<Token> lexer = new FieldTypeSignatureLexer(desc).parse();
        return ParserUtils.convertFieldTypeSignature(lexer);
    }

    public static String convertClassTypeSignature(String desc) {
        List<Token> lexer = new ClassTypeSignatureLexer(desc).parse();
        return ParserUtils.convertClassTypeSignature(lexer);
    }

    public static String convertClassSignature(String desc) {
        return ParserUtils.convertClassSignature(new ClassSignatureLexer(desc).parse());
    }

    public static List<String> extractTypeParameters(String desc) {
        LinkedList<String> result = new LinkedList<String>();
        if (desc.startsWith("<")) {
            int endIndex = AbstractLexer.balancedBracketPosition(desc, '<', '>');
            desc = desc.substring(1, endIndex);
            while (desc.length() > 0) {
                int index = AbstractLexer.firstIndexNotInside(',', '<', '>', desc);
                if (index == 0 || index == desc.length()) {
                    result.add(desc.trim());
                    desc = "";
                    continue;
                }
                result.add(desc.substring(0, index).trim());
                desc = desc.substring(index + 1);
            }
        }
        return result;
    }

    public static List<Token> parseClassSignature(String s) {
        return new ClassSignatureLexer(s).parse();
    }

    public static String convertMethodTypeSignature(String desc) {
        return ParserUtils.convertMethodTypeSignature(new MethodTypeSignatureLexer(desc).parse());
    }

    protected static String convertFieldDescriptor(List<Token> tokens) {
        String brackets = "";
        for (Token t : tokens) {
            if (t.getType() == 0) {
                return ParserUtils.convertBaseType(t.getValue()) + brackets;
            }
            if (t.getType() == 2) {
                return t.getValue().replaceAll("/", ".") + brackets;
            }
            if (t.getType() != 3) continue;
            brackets = brackets + t.getValue();
        }
        throw new IllegalArgumentException("Can not parse field descriptor");
    }

    protected static String convertClassTypeSignature(List<Token> tokens) {
        StringBuilder buf = new StringBuilder();
        for (Token t : tokens) {
            buf.append(t.getValue());
        }
        return buf.toString();
    }

    protected static String convertFieldTypeSignature(List<Token> tokens) {
        StringBuilder buf = new StringBuilder();
        for (Token t : tokens) {
            buf.append(t.getValue());
        }
        return buf.toString();
    }

    protected static String convertClassSignature(List<Token> tokens) {
        StringBuilder buf = new StringBuilder();
        for (Token t : tokens) {
            buf.append(t.getValue());
        }
        return buf.toString();
    }

    protected static String convertMethodTypeSignature(List<Token> tokens) {
        StringBuilder buf = new StringBuilder();
        for (Token t : tokens) {
            buf.append(t.getValue());
        }
        return buf.toString();
    }

    protected static String convertBaseType(String s) {
        switch (s.charAt(0)) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
        }
        throw new IllegalArgumentException(s + " is not a base type");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractLexer {
        protected String desc;

        public AbstractLexer(String d) {
            this.desc = d;
        }

        public abstract List<Token> parse();

        public String getRest() {
            return this.desc;
        }

        protected static int firstIndexNotInside(char symbol, char openBracket, char closeBracket, String text) {
            int count = 0;
            int index = 0;
            for (char c : text.toCharArray()) {
                if (c == symbol && count == 0) break;
                if (c == openBracket) {
                    ++count;
                }
                if (c == closeBracket) {
                    --count;
                }
                ++index;
            }
            return index;
        }

        protected static int balancedBracketPosition(String text, char openBracket, char closeBracket) {
            if (text.charAt(0) != openBracket) {
                throw new IllegalArgumentException(text + " does not start with open bracket ");
            }
            if (text.indexOf(closeBracket) == -1) {
                throw new IllegalArgumentException(text + " does not contain close bracket ");
            }
            int count = -1;
            char[] chars = text.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == openBracket) {
                    ++count;
                    continue;
                }
                if (c != closeBracket) continue;
                if (count == 0) {
                    return i;
                }
                --count;
            }
            throw new IllegalArgumentException(text + " has no balanced bracket for " + openBracket);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ThrowsSignatureLexer
    extends AbstractLexer {
        public ThrowsSignatureLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            LinkedList<Token> result = new LinkedList<Token>();
            if (this.desc.charAt(0) == '^') {
                this.desc = this.desc.substring(1);
                if (this.desc.charAt(0) == 'T') {
                    TypeVariableSignatureLexer l = new TypeVariableSignatureLexer(this.desc);
                    result.addAll(l.parse());
                    this.desc = l.getRest();
                } else {
                    ClassTypeSignatureLexer l = new ClassTypeSignatureLexer(this.desc);
                    result.addAll(l.parse());
                    this.desc = l.getRest();
                }
            } else {
                throw new IllegalArgumentException(this.desc + " is not a throws signature");
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MethodTypeSignatureLexer
    extends AbstractLexer {
        public MethodTypeSignatureLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            AbstractLexer t2;
            LinkedList<Token> result = new LinkedList<Token>();
            if (this.desc.charAt(0) == '<') {
                result.add(new Token(7, "<"));
                int formalTypeParametersEndIndex = MethodTypeSignatureLexer.balancedBracketPosition(this.desc, '<', '>');
                String formalTypeParameters = this.desc.substring(1, formalTypeParametersEndIndex);
                this.desc = this.desc.substring(formalTypeParametersEndIndex + 1);
                FormalTypeParameterLexer l = new FormalTypeParameterLexer(formalTypeParameters);
                result.addAll(l.parse());
                Pattern.compile("([^:]*):((.*))").matcher(formalTypeParameters);
                result.add(new Token(8, ">"));
            }
            result.add(new Token(16, "("));
            int typeSignaturesEndIndex = MethodTypeSignatureLexer.balancedBracketPosition(this.desc, '(', ')');
            String typeSignatures = this.desc.substring(1, typeSignaturesEndIndex);
            this.desc = this.desc.substring(typeSignaturesEndIndex + 1);
            if (typeSignatures.length() > 0) {
                TypeSignatureLexer t = new TypeSignatureLexer(typeSignatures);
                result.addAll(t.parse());
                typeSignatures = t.getRest();
                while (typeSignatures.length() > 0) {
                    result.add(new Token(10, ","));
                    t2 = new TypeSignatureLexer(typeSignatures);
                    result.addAll(((TypeSignatureLexer)t2).parse());
                    typeSignatures = t2.getRest();
                }
            }
            result.add(new Token(17, ")"));
            result.add(new Token(19, " return "));
            if (this.desc.charAt(0) == 'V') {
                result.add(new Token(1, "void"));
                this.desc = this.desc.substring(1);
            } else {
                TypeSignatureLexer t3 = new TypeSignatureLexer(this.desc);
                result.addAll(t3.parse());
                this.desc = t3.getRest();
            }
            if (this.desc.length() > 0) {
                result.add(new Token(18, " throws "));
                ThrowsSignatureLexer t4 = new ThrowsSignatureLexer(this.desc);
                result.addAll(t4.parse());
                this.desc = t4.getRest();
                while (this.desc.length() > 0) {
                    result.add(new Token(10, ","));
                    t2 = new ThrowsSignatureLexer(this.desc);
                    result.addAll(((ThrowsSignatureLexer)t2).parse());
                    this.desc = t2.getRest();
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FormalTypeParameterLexer
    extends AbstractLexer {
        public FormalTypeParameterLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            LinkedList<Token> result = new LinkedList<Token>();
            Matcher m = Pattern.compile("([^:]*):((.*))").matcher(this.desc);
            if (m.matches()) {
                AbstractLexer l;
                String identifier = m.group(1);
                String other = m.group(2);
                result.add(new Token(6, identifier));
                result.add(new Token(13, " extends "));
                if (other.charAt(0) == ':') {
                    other = other.substring(1);
                }
                FieldTypeSignatureLexer f = new FieldTypeSignatureLexer(other);
                result.addAll(f.parse());
                other = f.getRest();
                if (other.length() > 0 && other.startsWith(":")) {
                    while (other.startsWith(":")) {
                        result.add(new Token(20, " & "));
                        l = new FieldTypeSignatureLexer(other.substring(1));
                        result.addAll(((FieldTypeSignatureLexer)l).parse());
                        other = l.getRest();
                    }
                }
                if (other.length() > 0) {
                    result.add(new Token(10, ","));
                    l = new FormalTypeParameterLexer(other);
                    result.addAll(((FormalTypeParameterLexer)l).parse());
                }
                this.desc = other;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassSignatureLexer
    extends AbstractLexer {
        public ClassSignatureLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            LinkedList<Token> result = new LinkedList<Token>();
            if (this.desc.charAt(0) == '<') {
                result.add(new Token(7, "<"));
                int formalTypeParametersEndIndex = ClassSignatureLexer.balancedBracketPosition(this.desc, '<', '>');
                String formalTypeParameters = this.desc.substring(1, formalTypeParametersEndIndex);
                this.desc = this.desc.substring(formalTypeParametersEndIndex + 1);
                FormalTypeParameterLexer l = new FormalTypeParameterLexer(formalTypeParameters);
                result.addAll(l.parse());
                Pattern.compile("([^:]*):((.*))").matcher(formalTypeParameters);
                result.add(new Token(8, ">"));
            }
            ClassTypeSignatureLexer l = new ClassTypeSignatureLexer(this.desc);
            result.add(new Token(13, " extends "));
            result.addAll(l.parse());
            String interfaces = l.getRest();
            if (interfaces.length() > 0) {
                result.add(new Token(13, " implements "));
                ClassTypeSignatureLexer l2 = new ClassTypeSignatureLexer(interfaces);
                result.addAll(l2.parse());
                String others = l2.getRest();
                while (others.length() > 0) {
                    l2 = new ClassTypeSignatureLexer(others);
                    result.add(new Token(10, ","));
                    result.addAll(l2.parse());
                    others = l2.getRest();
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ClassTypeSignatureLexer
    extends AbstractLexer {
        public ClassTypeSignatureLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            LinkedList<Token> result = new LinkedList<Token>();
            int index = ClassTypeSignatureLexer.firstIndexNotInside(';', '<', '>', this.desc);
            String classTypeSignature = this.desc.substring(0, index + 1);
            this.desc = this.desc.substring(index + 1);
            Matcher m = Pattern.compile("L([^<\\.;]*/)*([^<\\.;]*)((.*));$").matcher(classTypeSignature);
            if (m.matches()) {
                String packageSpecifier = m.group(1);
                String identifier = m.group(2);
                String other = m.group(3);
                String arguments = "";
                String suffixes = "";
                if (other != null && other.length() > 0) {
                    if (other.charAt(0) == '<') {
                        arguments = other.substring(0, ClassTypeSignatureLexer.balancedBracketPosition(other, '<', '>') + 1);
                    }
                    suffixes = other.substring(arguments.length());
                }
                if (packageSpecifier != null && packageSpecifier.length() > 0) {
                    result.add(new Token(5, packageSpecifier.replaceAll("/", ".")));
                }
                SimpleClassTypeSignatureLexer sl = new SimpleClassTypeSignatureLexer(identifier + arguments);
                result.addAll(sl.parse());
                while (suffixes.length() > 0) {
                    suffixes = suffixes.substring(1);
                    index = ClassTypeSignatureLexer.firstIndexNotInside('.', '<', '>', suffixes);
                    String suffix = suffixes.substring(0, index);
                    result.add(new Token(11, "."));
                    result.addAll(new SimpleClassTypeSignatureLexer(suffix).parse());
                    suffixes = suffixes.substring(index);
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SimpleClassTypeSignatureLexer
    extends AbstractLexer {
        public SimpleClassTypeSignatureLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            LinkedList<Token> result = new LinkedList<Token>();
            Matcher m = Pattern.compile("([^<.]*)(<.*>)?((.*))").matcher(this.desc);
            if (m.matches()) {
                String identifier = m.group(1);
                String typeArguments = m.group(2);
                if (identifier == null || identifier.length() <= 0) {
                    throw new IllegalArgumentException(this.desc + " is not a SimpleClassTypeSignature");
                }
                result.add(new Token(6, identifier));
                if (typeArguments != null && typeArguments.length() > 0) {
                    result.add(new Token(7, "<"));
                    String arguments = typeArguments.substring(1, typeArguments.length() - 1);
                    if (arguments.charAt(0) == '*') {
                        result.add(new Token(9, "?"));
                    } else {
                        if (arguments.charAt(0) == '+') {
                            result.add(new Token(9, "? extends "));
                            arguments = arguments.substring(1);
                        } else if (arguments.charAt(0) == '-') {
                            result.add(new Token(9, "? super "));
                            arguments = arguments.substring(1);
                        }
                        while (arguments.length() > 0) {
                            FieldTypeSignatureLexer l = new FieldTypeSignatureLexer(arguments);
                            result.addAll(l.parse());
                            arguments = l.getRest();
                            if (arguments.length() <= 0) continue;
                            result.add(new Token(10, ","));
                        }
                    }
                    result.add(new Token(8, ">"));
                }
            }
            this.desc = m.group(3);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TypeSignatureLexer
    extends AbstractLexer {
        public TypeSignatureLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            LinkedList<Token> result = new LinkedList<Token>();
            Matcher m = Pattern.compile("^(B|C|D|F|I|J|S|Z)((.*))").matcher(this.desc);
            if (m.matches()) {
                result.add(new Token(0, ParserUtils.convertBaseType(m.group(1))));
                this.desc = this.desc.substring(1);
            } else {
                FieldTypeSignatureLexer l = new FieldTypeSignatureLexer(this.desc);
                result.addAll(((AbstractLexer)l).parse());
                this.desc = l.getRest();
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ArrayTypeSignatureLexer
    extends AbstractLexer {
        public ArrayTypeSignatureLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            LinkedList<Token> result = new LinkedList<Token>();
            if (this.desc.charAt(0) == '[') {
                this.desc = this.desc.substring(1);
                TypeSignatureLexer l = new TypeSignatureLexer(this.desc);
                result.addAll(l.parse());
                this.desc = l.getRest();
                result.add(new Token(3, "[]"));
                return result;
            }
            throw new IllegalArgumentException(this.desc + " is not an array type signature");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TypeVariableSignatureLexer
    extends AbstractLexer {
        public TypeVariableSignatureLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            LinkedList<Token> result = new LinkedList<Token>();
            Matcher m = Pattern.compile("T([^;]*);((.*))").matcher(this.desc);
            if (m.matches()) {
                result.add(new Token(6, m.group(1)));
                this.desc = m.group(2);
            } else {
                new IllegalArgumentException(this.desc + " is not a type variable signature");
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FieldTypeSignatureLexer
    extends AbstractLexer {
        public FieldTypeSignatureLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            LinkedList<Token> result = new LinkedList<Token>();
            AbstractLexer lexer = null;
            switch (this.desc.charAt(0)) {
                case 'L': {
                    lexer = new ClassTypeSignatureLexer(this.desc);
                    break;
                }
                case '[': {
                    lexer = new ArrayTypeSignatureLexer(this.desc);
                    break;
                }
                case 'T': {
                    lexer = new TypeVariableSignatureLexer(this.desc);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(this.desc + " is not a field type signature");
                }
            }
            result.addAll(lexer.parse());
            this.desc = lexer.getRest();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MethodDescriptorLexer
    extends AbstractLexer {
        public MethodDescriptorLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            LinkedList<Token> result = new LinkedList<Token>();
            Matcher m = Pattern.compile("^(\\()(.*)(\\))((.+))").matcher(this.desc);
            if (m.matches()) {
                FieldDescriptorLexer lexer;
                String returnDescriptor = m.group(4);
                String parameters = m.group(2);
                while (parameters.length() > 0) {
                    lexer = new FieldDescriptorLexer(parameters);
                    result.add(new Token(4, ParserUtils.convertFieldDescriptor(lexer.parse())));
                    parameters = lexer.getRest();
                }
                if (returnDescriptor.equals("V")) {
                    result.add(new Token(1, "void"));
                } else {
                    lexer = new FieldDescriptorLexer(returnDescriptor);
                    result.add(new Token(4, ParserUtils.convertFieldDescriptor(lexer.parse())));
                }
                return result;
            }
            throw new IllegalArgumentException(this.desc + " is not a MethodDescriptor");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FieldDescriptorLexer
    extends AbstractLexer {
        public FieldDescriptorLexer(String desc) {
            super(desc);
        }

        @Override
        public List<Token> parse() {
            LinkedList<Token> result = new LinkedList<Token>();
            Matcher m = Pattern.compile("^(L)(.+)(;)").matcher(this.desc);
            if (m.matches()) {
                result.add(new Token(2, m.group(2)));
                this.desc = this.desc.substring(m.group(0).length());
                return result;
            }
            m = Pattern.compile("^(\\[)((.+))").matcher(this.desc);
            if (m.matches()) {
                result.add(new Token(3, "[]"));
                this.desc = this.desc.substring(1);
                result.addAll(this.parse());
                return result;
            }
            m = Pattern.compile("^(B|C|D|F|I|J|S|Z)((.*))").matcher(this.desc);
            if (m.matches()) {
                result.add(new Token(0, m.group(1)));
                this.desc = this.desc.substring(1);
                return result;
            }
            if (this.desc.length() == 0) {
                return result;
            }
            throw new IllegalArgumentException(this.desc + " is not a FieldDescriptor");
        }
    }

    public static class Token {
        public static final int BASE_TYPE = 0;
        public static final int VOID_TYPE = 1;
        public static final int CLASS_NAME = 2;
        public static final int ARRAY_BRACKET = 3;
        public static final int FIELD_DESCRIPTOR = 4;
        public static final int PACKAGE = 5;
        public static final int IDENTIFIER = 6;
        public static final int LABRACKET = 7;
        public static final int RABRACKET = 8;
        public static final int WILDCARD = 9;
        public static final int COMMA = 10;
        public static final int POINT = 11;
        public static final int COLON = 12;
        public static final int SUPERCLASS = 13;
        public static final int SUPERINTERFACE = 15;
        public static final int LBRACKET = 16;
        public static final int RBRACKET = 17;
        public static final int THROWS = 18;
        public static final int RETURN = 19;
        public static final int AMPERSAND = 20;
        private String value;
        private int type;

        public Token(int t, String v) {
            this.type = t;
            this.value = v;
        }

        public int getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.type + ":" + this.value;
        }
    }
}

