/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmi.reflect.InvalidObjectException;
import org.argouml.model.CollaborationsHelper;
import org.argouml.model.CoreHelper;
import org.argouml.model.InvalidElementException;
import org.argouml.model.Model;
import org.argouml.model.ModelManagementHelper;
import org.argouml.model.mdr.CollectionHelper;
import org.argouml.model.mdr.CoreHelperMDRImpl;
import org.argouml.model.mdr.MDRModelImplementation;
import org.omg.uml.UmlPackage;
import org.omg.uml.behavioralelements.collaborations.AssociationEndRole;
import org.omg.uml.behavioralelements.collaborations.AssociationRole;
import org.omg.uml.behavioralelements.collaborations.ClassifierRole;
import org.omg.uml.behavioralelements.collaborations.Collaboration;
import org.omg.uml.behavioralelements.collaborations.Interaction;
import org.omg.uml.behavioralelements.collaborations.Message;
import org.omg.uml.behavioralelements.commonbehavior.Action;
import org.omg.uml.behavioralelements.commonbehavior.Instance;
import org.omg.uml.behavioralelements.commonbehavior.Stimulus;
import org.omg.uml.foundation.core.AssociationEnd;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Feature;
import org.omg.uml.foundation.core.GeneralizableElement;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.UmlAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollaborationsHelperMDRImpl
implements CollaborationsHelper {
    private MDRModelImplementation modelImpl;
    private static final Logger LOG = Logger.getLogger(CollaborationsHelperMDRImpl.class.getName());

    CollaborationsHelperMDRImpl(MDRModelImplementation implementation) {
        this.modelImpl = implementation;
    }

    @Override
    public Collection<ClassifierRole> getAllClassifierRoles(Object ns) {
        if (!(ns instanceof Namespace)) {
            throw new IllegalArgumentException();
        }
        try {
            ArrayList<ClassifierRole> list = new ArrayList<ClassifierRole>();
            for (Object o : ((Namespace)ns).getOwnedElement()) {
                if (o instanceof Namespace) {
                    list.addAll(this.getAllClassifierRoles(o));
                }
                if (!(o instanceof ClassifierRole)) continue;
                list.add((ClassifierRole)o);
            }
            return list;
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
    }

    @Override
    public Collection getAllPossibleAssociationRoles(Object roleArg) {
        if (!(roleArg instanceof ClassifierRole)) {
            throw new IllegalArgumentException();
        }
        ClassifierRole role = (ClassifierRole)roleArg;
        try {
            if (role.getBase().isEmpty()) {
                return Collections.emptyList();
            }
            HashSet associations = new HashSet();
            for (Classifier base : role.getBase()) {
                associations.addAll(this.modelImpl.getCoreHelper().getAssociations(base));
            }
            return associations;
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
    }

    @Override
    public Collection<Classifier> getClassifierRoles(Object role) {
        if (role == null) {
            return Collections.emptySet();
        }
        if (!(role instanceof ClassifierRole)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Classifier> roles = new ArrayList<Classifier>();
        try {
            Collection associationEnds = Model.getFacade().getAssociationEnds(role);
            if (!associationEnds.isEmpty()) {
                for (AssociationEnd end : associationEnds) {
                    if (!(end instanceof AssociationEndRole)) continue;
                    UmlAssociation assoc = end.getAssociation();
                    for (AssociationEnd end2 : assoc.getConnection()) {
                        Classifier classifier = end2.getParticipant();
                        if (classifier == role || !(classifier instanceof ClassifierRole)) continue;
                        roles.add(classifier);
                    }
                }
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        return roles;
    }

    @Override
    public Object getAssociationRole(Object afrom, Object ato) {
        if (afrom == null || ato == null) {
            throw new IllegalArgumentException();
        }
        ClassifierRole from = (ClassifierRole)afrom;
        ClassifierRole to = (ClassifierRole)ato;
        try {
            Collection ends = Model.getFacade().getAssociationEnds(from);
            for (AssociationEnd end : ends) {
                if (!(end instanceof AssociationEndRole)) continue;
                UmlAssociation assoc = end.getAssociation();
                for (AssociationEnd end2 : assoc.getConnection()) {
                    Classifier classifier = end2.getParticipant();
                    if (classifier != to) continue;
                    return assoc;
                }
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        return null;
    }

    @Override
    public Collection<Message> getAllPossibleActivators(Object ames) {
        Message mes = (Message)ames;
        if (mes == null || mes.getInteraction() == null) {
            return Collections.unmodifiableCollection(Collections.EMPTY_LIST);
        }
        try {
            Interaction inter = mes.getInteraction();
            Collection predecessors = mes.getPredecessor();
            Collection allMessages = inter.getMessage();
            ArrayList<Message> list = new ArrayList<Message>();
            for (Message m : allMessages) {
                if (predecessors.contains(m) || mes == m || this.hasAsActivator(m, mes) || m.getPredecessor().contains(mes)) continue;
                list.add(m);
            }
            return list;
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
    }

    @Override
    public boolean hasAsActivator(Object message, Object activator) {
        if (!(message instanceof Message)) {
            throw new IllegalArgumentException();
        }
        if (!(activator instanceof Message)) {
            throw new IllegalArgumentException();
        }
        try {
            Message messActivator = ((Message)message).getActivator();
            if (messActivator == null) {
                return false;
            }
            if (messActivator == activator || messActivator.getPredecessor().contains(activator)) {
                return true;
            }
            return this.hasAsActivator(messActivator, activator);
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
    }

    @Override
    public void setActivator(Object ames, Object anactivator) {
        if (ames == null) {
            throw new IllegalArgumentException("message is null");
        }
        if (!(ames instanceof Message)) {
            throw new IllegalArgumentException("message");
        }
        if (anactivator != null && !(anactivator instanceof Message)) {
            throw new IllegalArgumentException("An activator must be a message");
        }
        Message mes = (Message)ames;
        Message activator = (Message)anactivator;
        if (mes == activator) {
            throw new IllegalArgumentException("In setActivator: message may not be equal to activator");
        }
        if (activator != null) {
            if (mes.getInteraction() != activator.getInteraction()) {
                throw new IllegalArgumentException("In setActivator: interaction of message should equal interaction of activator");
            }
            if (this.hasAsActivator(activator, mes)) {
                throw new IllegalArgumentException("In setActivator: message may not be the activator for the original activator");
            }
            if (mes.getPredecessor().contains(activator)) {
                mes.getPredecessor().remove(activator);
            }
        }
        ArrayList<Message> listToChange = new ArrayList<Message>();
        Collection predecessors = mes.getPredecessor();
        listToChange.addAll(predecessors);
        listToChange.add(mes);
        Interaction inter = mes.getInteraction();
        for (Message mes2 : inter.getMessage()) {
            if (!mes2.getPredecessor().contains(mes)) continue;
            listToChange.add(mes2);
        }
        for (Message mes2 : listToChange) {
            mes2.setActivator(activator);
        }
    }

    @Override
    public Collection<Message> getAllPossiblePredecessors(Object amessage) {
        Message message = (Message)amessage;
        if (message == null) {
            throw new IllegalArgumentException("In getAllPossiblePredecessors: argument message is null");
        }
        try {
            Interaction inter = message.getInteraction();
            ArrayList<Message> list = new ArrayList<Message>();
            for (Message mes : inter.getMessage()) {
                if (mes.getActivator() != message.getActivator() || message == mes || mes.getPredecessor().contains(message) || message.getPredecessor().contains(message)) continue;
                list.add(mes);
            }
            return list;
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
    }

    @Override
    public void addBase(Object arole, Object abase) {
        ClassifierRole role = (ClassifierRole)arole;
        Classifier base = (Classifier)abase;
        if (role == null || base == null) {
            throw new IllegalArgumentException("In addBase: either the role or the base is null");
        }
        role.getBase().add(base);
        if (this.modelImpl.getFacade().getBases(role).size() == 1) {
            role.getAvailableContents().clear();
            role.getAvailableContents().addAll(base.getOwnedElement());
            role.getAvailableFeature().clear();
            role.getAvailableFeature().addAll(base.getFeature());
        } else {
            for (ModelElement elem : base.getOwnedElement()) {
                if (role.getAvailableContents().contains(elem)) continue;
                role.getAvailableContents().add(elem);
            }
            for (Feature feature : base.getFeature()) {
                if (role.getAvailableFeature().contains(feature)) continue;
                role.getAvailableFeature().add(feature);
            }
        }
    }

    @Override
    public void setBases(Object role, Collection bases) {
        if (role == null || bases == null) {
            throw new IllegalArgumentException("In setBases: either the role or the collection bases is null");
        }
        CollectionHelper.update(((ClassifierRole)role).getBase(), bases);
    }

    @Override
    public Collection<Feature> allAvailableFeatures(Object arole) {
        LOG.log(Level.INFO, "allAvailableFeatures start");
        if (arole instanceof ClassifierRole) {
            try {
                ArrayList<Feature> returnList = new ArrayList<Feature>();
                ClassifierRole role = (ClassifierRole)arole;
                for (ModelElement modelElement : CoreHelperMDRImpl.getAllParents((GeneralizableElement)role)) {
                    if (!(modelElement instanceof ClassifierRole)) continue;
                    returnList.addAll(this.allAvailableFeatures(modelElement));
                }
                for (Classifier classifier : role.getBase()) {
                    returnList.addAll(classifier.getFeature());
                }
                LOG.log(Level.INFO, "allAvailableFeatures {0}", returnList.size());
                return returnList;
            }
            catch (InvalidObjectException e) {
                throw new InvalidElementException(e);
            }
        }
        throw new IllegalArgumentException("Cannot get available features on " + arole);
    }

    @Override
    public Collection allAvailableContents(Object arole) {
        LOG.log(Level.INFO, "allAvailableContents start");
        try {
            if (arole instanceof ClassifierRole) {
                ArrayList returnList = new ArrayList();
                ClassifierRole role = (ClassifierRole)arole;
                for (ModelElement modelElement : CoreHelperMDRImpl.getAllParents((GeneralizableElement)role)) {
                    if (!(modelElement instanceof ClassifierRole)) continue;
                    returnList.addAll(this.allAvailableContents(modelElement));
                }
                for (Classifier classifier : role.getBase()) {
                    returnList.addAll(classifier.getOwnedElement());
                }
                LOG.log(Level.INFO, "allAvailableFeatures {0}", returnList.size());
                return returnList;
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        throw new IllegalArgumentException("Cannot get available contents on " + arole);
    }

    @Override
    public Collection getAllPossibleBases(Object role) {
        try {
            if (role instanceof ClassifierRole) {
                return this.getAllPossibleBases((ClassifierRole)role);
            }
            if (role instanceof AssociationRole) {
                return this.getAllPossibleBases((AssociationRole)role);
            }
            throw new IllegalArgumentException("Illegal type " + role);
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
    }

    private Collection getAllPossibleBases(AssociationRole aRole) {
        HashSet ret = new HashSet();
        if (aRole == null || aRole.getNamespace() == null) {
            return ret;
        }
        HashSet bases = new HashSet();
        for (AssociationEnd end : aRole.getConnection()) {
            assert (end instanceof AssociationEndRole);
            ClassifierRole type = (ClassifierRole)end.getParticipant();
            if (type == null) continue;
            bases.addAll(type.getBase());
        }
        if (bases.isEmpty()) {
            ModelManagementHelper mmh = this.modelImpl.getModelManagementHelper();
            Namespace ns = ((Collaboration)aRole.getNamespace()).getNamespace();
            ret.addAll(mmh.getAllModelElementsOfKind((Object)ns, UmlAssociation.class));
            ret.removeAll(mmh.getAllModelElementsOfKind((Object)ns, AssociationRole.class));
        } else {
            CoreHelper ch = this.modelImpl.getCoreHelper();
            for (Classifier base1 : bases) {
                for (Classifier base2 : bases) {
                    ret.addAll(ch.getAssociations(base1, base2));
                }
            }
        }
        ArrayList<UmlAssociation> listToRemove = new ArrayList<UmlAssociation>();
        for (UmlAssociation association : ret) {
            Collection associationRoles = ((UmlPackage)association.refOutermostPackage()).getCollaborations().getABaseAssociationRole().getAssociationRole(association);
            if (associationRoles.isEmpty()) continue;
            if (aRole.getName() == null || aRole.getName().equals("")) {
                listToRemove.add(association);
                continue;
            }
            for (AssociationRole ar : associationRoles) {
                if (ar.getName() != null && !ar.getName().equals("")) continue;
                listToRemove.add(association);
            }
        }
        ret.removeAll(listToRemove);
        return ret;
    }

    private Collection getAllPossibleBases(ClassifierRole role) {
        if (role == null || this.modelImpl.getFacade().getNamespace(role) == null) {
            return Collections.EMPTY_SET;
        }
        Collaboration collaboration = (Collaboration)role.getNamespace();
        Namespace ns = collaboration.getNamespace();
        ModelManagementHelper mmh = this.modelImpl.getModelManagementHelper();
        Collection returnList = mmh.getAllModelElementsOfKind((Object)ns, Classifier.class);
        returnList.removeAll(mmh.getAllModelElementsOfKind((Object)ns, ClassifierRole.class));
        ArrayList<Classifier> listToRemove = new ArrayList<Classifier>();
        for (Classifier classifier : returnList) {
            Collection classifierRoles = ((UmlPackage)classifier.refOutermostPackage()).getCollaborations().getAClassifierRoleBase().getClassifierRole(classifier);
            if (classifierRoles.isEmpty()) continue;
            if (role.getName() == null || role.getName().equals("")) {
                listToRemove.add(classifier);
                continue;
            }
            for (ClassifierRole cr : classifierRoles) {
                if (cr.getName() != null && !cr.getName().equals("")) continue;
                listToRemove.add(classifier);
            }
        }
        returnList.removeAll(listToRemove);
        if (!(ns instanceof org.omg.uml.modelmanagement.UmlPackage)) {
            while (ns != null && !((ns = ns.getNamespace()) instanceof org.omg.uml.modelmanagement.UmlPackage)) {
            }
        }
        if (this.modelImpl.getFacade().isAPackage(ns)) {
            returnList.addAll(this.getAllImportedClassifiers(ns));
        }
        return returnList;
    }

    private Collection<Classifier> getAllImportedClassifiers(Object obj) {
        Collection c = this.modelImpl.getModelManagementHelper().getAllImportedElements(obj);
        return this.filterClassifiers(c);
    }

    private Collection<Classifier> filterClassifiers(Collection in) {
        ArrayList<Classifier> out = new ArrayList<Classifier>();
        for (Object o : in) {
            if (!(o instanceof Classifier) || o instanceof ClassifierRole) continue;
            out.add((Classifier)o);
        }
        return out;
    }

    @Override
    public void setBase(Object arole, Object abase) {
        if (arole == null) {
            throw new IllegalArgumentException("role is null");
        }
        if (arole instanceof AssociationRole) {
            AssociationRole role = (AssociationRole)arole;
            UmlAssociation base = (UmlAssociation)abase;
            if (base != null && !this.getAllPossibleBases(role).contains(base)) {
                throw new IllegalArgumentException("base is not allowed for this role");
            }
            role.setBase(base);
            ClassifierRole sender = (ClassifierRole)this.modelImpl.getCoreHelper().getSource(role);
            ClassifierRole receiver = (ClassifierRole)this.modelImpl.getCoreHelper().getDestination(role);
            Collection senderBases = sender.getBase();
            Collection receiverBases = receiver.getBase();
            AssociationEndRole senderRole = (AssociationEndRole)this.modelImpl.getCoreHelper().getAssociationEnd(sender, role);
            AssociationEndRole receiverRole = (AssociationEndRole)this.modelImpl.getCoreHelper().getAssociationEnd(receiver, role);
            if (base != null) {
                for (AssociationEnd end : base.getConnection()) {
                    if (senderBases.contains(end.getParticipant())) {
                        senderRole.setBase(end);
                        continue;
                    }
                    if (!receiverBases.contains(end.getParticipant())) continue;
                    receiverRole.setBase(end);
                }
            }
            return;
        }
        if (arole instanceof AssociationEndRole) {
            AssociationEndRole role = (AssociationEndRole)arole;
            AssociationEnd base = (AssociationEnd)abase;
            role.setBase(base);
            return;
        }
        throw new IllegalArgumentException("role");
    }

    @Override
    public boolean isAddingCollaborationAllowed(Object context) {
        return context instanceof Classifier || context instanceof Operation;
    }

    @Override
    public void removeBase(Object handle, Object c) {
        try {
            if (handle instanceof ClassifierRole && c instanceof Classifier) {
                ((ClassifierRole)handle).getBase().remove(c);
                return;
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        throw new IllegalArgumentException("There must be a ClassifierRole and a Classifier");
    }

    @Override
    public void removeConstrainingElement(Object handle, Object constraint) {
        try {
            if (handle instanceof Collaboration && constraint instanceof ModelElement) {
                Collaboration collab = (Collaboration)handle;
                collab.getConstrainingElement().remove(constraint);
                return;
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        throw new IllegalArgumentException("handle: " + handle + " or constraint: " + constraint);
    }

    @Override
    public void removeMessage(Object handle, Object message) {
        try {
            if (handle instanceof Interaction && message instanceof Message) {
                ((Interaction)handle).getMessage().remove(message);
                return;
            }
            if (handle instanceof AssociationRole && message instanceof Message) {
                ((AssociationRole)handle).getMessage().remove(message);
                return;
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        throw new IllegalArgumentException("handle: " + handle + " or message: " + message);
    }

    @Override
    public void removeSuccessor(Object handle, Object mess) {
        try {
            if (handle instanceof Message && mess instanceof Message) {
                ((UmlPackage)((Message)handle).refOutermostPackage()).getCollaborations().getAPredecessorSuccessor().remove((Message)handle, (Message)mess);
                return;
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        throw new IllegalArgumentException("predecessor: " + handle + " or successor: " + mess);
    }

    @Override
    public void removePredecessor(Object handle, Object message) {
        try {
            if (handle instanceof Message && message instanceof Message) {
                ((Message)handle).getPredecessor().remove(message);
                return;
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        throw new IllegalArgumentException("handle: " + handle + " or message: " + message);
    }

    @Override
    public void addConstrainingElement(Object handle, Object constraint) {
        if (handle instanceof Collaboration && constraint instanceof ModelElement) {
            ((Collaboration)handle).getConstrainingElement().add((ModelElement)constraint);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or constraint: " + constraint);
    }

    @Override
    public void addInstance(Object classifierRole, Object instance) {
        if (classifierRole instanceof ClassifierRole && instance instanceof Instance) {
            ((ClassifierRole)classifierRole).getConformingInstance().add((Instance)instance);
        }
        throw new IllegalArgumentException("classifierRole: " + classifierRole + " or instance: " + instance);
    }

    @Override
    public void addMessage(Object handle, Object elem) {
        if (handle instanceof Interaction && elem instanceof Message) {
            Message message = (Message)elem;
            Interaction interaction = (Interaction)handle;
            Interaction oldInteraction = message.getInteraction();
            if (oldInteraction != null) {
                oldInteraction.getMessage().remove(message);
            }
            interaction.getMessage().add(message);
            return;
        }
        if (handle instanceof AssociationRole && elem instanceof Message) {
            ((AssociationRole)handle).getMessage().add((Message)elem);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or elem: " + elem);
    }

    @Override
    public void addSuccessor(Object handle, Object mess) {
        if (handle instanceof Message && mess instanceof Message) {
            ((Message)mess).getPredecessor().add((Message)handle);
            return;
        }
        throw new IllegalArgumentException("predecessor: " + handle + " or successor: " + mess);
    }

    @Override
    public void addPredecessor(Object handle, Object predecessor) {
        if (handle != null && handle instanceof Message && predecessor != null && predecessor instanceof Message) {
            ((Message)handle).getPredecessor().add((Message)predecessor);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or predecessor: " + predecessor);
    }

    @Override
    public void setAction(Object handle, Object action) {
        if (handle instanceof Message && (action == null || action instanceof Action)) {
            ((Message)handle).setAction((Action)action);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or action: " + action);
    }

    @Override
    public void setContext(Object handle, Object col) {
        if (handle instanceof Interaction && (col instanceof Collaboration || col == null)) {
            ((Interaction)handle).setContext((Collaboration)col);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or col: " + col);
    }

    @Override
    public void setSuccessors(Object handle, Collection messages) {
        if (handle instanceof Message) {
            Collection currentMessages = Model.getFacade().getSuccessors(handle);
            if (!currentMessages.isEmpty()) {
                ArrayList successors = new ArrayList(currentMessages);
                for (Object msg : successors) {
                    this.removeSuccessor(handle, msg);
                }
            }
            for (Object msg : messages) {
                this.addSuccessor(handle, msg);
            }
            return;
        }
        throw new IllegalArgumentException("predecessor: " + handle + " or messages: " + messages);
    }

    @Override
    public void setMessageSort(Object message, Object messageSort) {
        this.setAction(message, messageSort);
    }

    @Override
    public void setPredecessors(Object handle, Collection predecessors) {
        if (handle instanceof Message) {
            CollectionHelper.update(((Message)handle).getPredecessor(), predecessors);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or predecessors: " + predecessors);
    }

    @Override
    public void setRepresentedClassifier(Object handle, Object classifier) {
        if (handle instanceof Collaboration && (classifier == null || classifier instanceof Classifier)) {
            ((Collaboration)handle).setRepresentedClassifier((Classifier)classifier);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or classifier: " + classifier);
    }

    @Override
    public void setRepresentedOperation(Object handle, Object operation) {
        if (handle instanceof Collaboration && (operation == null || operation instanceof Operation)) {
            ((Collaboration)handle).setRepresentedOperation((Operation)operation);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or operation: " + operation);
    }

    @Override
    public void setSender(Object handle, Object sender) {
        if (handle instanceof Message && (sender instanceof ClassifierRole || sender == null)) {
            ((Message)handle).setSender((ClassifierRole)sender);
            return;
        }
        if (handle instanceof Stimulus && sender instanceof Instance) {
            ((Stimulus)handle).setSender((Instance)sender);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or sender: " + sender);
    }

    @Override
    public void removeInteraction(Object collab, Object interaction) {
        try {
            if (collab instanceof Collaboration && interaction instanceof Interaction) {
                ((Collaboration)collab).getInteraction().remove(interaction);
                return;
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        throw new IllegalArgumentException("collab: " + collab + " or interaction: " + interaction);
    }
}

