/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.argouml.model.Model;
import org.argouml.model.UmlHelper;
import org.argouml.model.mdr.MDRModelImplementation;
import org.omg.uml.behavioralelements.collaborations.Message;
import org.omg.uml.behavioralelements.commonbehavior.Action;
import org.omg.uml.behavioralelements.commonbehavior.ActionSequence;
import org.omg.uml.behavioralelements.commonbehavior.Argument;
import org.omg.uml.behavioralelements.commonbehavior.Link;
import org.omg.uml.behavioralelements.commonbehavior.LinkEnd;
import org.omg.uml.behavioralelements.statemachines.Event;
import org.omg.uml.behavioralelements.statemachines.Transition;
import org.omg.uml.behavioralelements.usecases.Extend;
import org.omg.uml.behavioralelements.usecases.ExtensionPoint;
import org.omg.uml.behavioralelements.usecases.UseCase;
import org.omg.uml.foundation.core.AssociationEnd;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.BehavioralFeature;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.core.Enumeration;
import org.omg.uml.foundation.core.EnumerationLiteral;
import org.omg.uml.foundation.core.Feature;
import org.omg.uml.foundation.core.Operation;
import org.omg.uml.foundation.core.Parameter;
import org.omg.uml.foundation.core.Relationship;
import org.omg.uml.foundation.core.UmlAssociation;

class UmlHelperMDRImpl
implements UmlHelper {
    private MDRModelImplementation modelImpl;

    UmlHelperMDRImpl(MDRModelImplementation implementation) {
        this.modelImpl = implementation;
    }

    public void addListenersToModel(Object model) {
    }

    public void deleteCollection(Collection col) {
        Iterator it = col.iterator();
        while (it.hasNext()) {
            this.modelImpl.getUmlFactory().delete(it.next());
        }
    }

    public Object getSource(Object relationship) {
        if (relationship instanceof Message) {
            Message message = (Message)relationship;
            return message.getSender();
        }
        if (relationship instanceof Relationship) {
            return this.modelImpl.getCoreHelper().getSource(relationship);
        }
        if (relationship instanceof Transition) {
            return this.modelImpl.getStateMachinesHelper().getSource(relationship);
        }
        if (relationship instanceof AssociationEnd) {
            return this.modelImpl.getCoreHelper().getSource(relationship);
        }
        throw new IllegalArgumentException();
    }

    public Object getDestination(Object relationship) {
        if (relationship instanceof Message) {
            Message message = (Message)relationship;
            return message.getSender();
        }
        if (relationship instanceof Relationship) {
            return this.modelImpl.getCoreHelper().getDestination(relationship);
        }
        if (relationship instanceof Transition) {
            return this.modelImpl.getStateMachinesHelper().getDestination(relationship);
        }
        if (relationship instanceof AssociationEnd) {
            return this.modelImpl.getCoreHelper().getDestination(relationship);
        }
        throw new IllegalArgumentException();
    }

    public void move(Object parent, Object element, UmlHelper.Direction direction) {
        if (element instanceof Argument) {
            Argument arg = (Argument)element;
            Action action = arg.getAction();
            List f = action.getActualArgument();
            int oldIndex = f.indexOf(arg);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(arg);
            f.add(newIndex, arg);
        } else if (element instanceof Action) {
            Action act = (Action)element;
            ActionSequence actionSequence = act.getActionSequence();
            List f = actionSequence.getAction();
            int oldIndex = f.indexOf(act);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(actionSequence);
            f.add(newIndex, actionSequence);
        } else if (element instanceof AssociationEnd) {
            AssociationEnd assEnd = (AssociationEnd)element;
            UmlAssociation assoc = assEnd.getAssociation();
            List f = assoc.getConnection();
            int oldIndex = f.indexOf(assEnd);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(assEnd);
            f.add(newIndex, assEnd);
        } else if (element instanceof Attribute && parent instanceof AssociationEnd) {
            Attribute attr = (Attribute)element;
            AssociationEnd assocEnd = attr.getAssociationEnd();
            List f = assocEnd.getQualifier();
            int oldIndex = f.indexOf(assocEnd);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(attr);
            f.add(newIndex, attr);
        } else if (element instanceof Feature) {
            Feature att = (Feature)element;
            Classifier cls = att.getOwner();
            List f = Model.getFacade().getFeatures(cls);
            int oldIndex = f.indexOf(att);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            Model.getCoreHelper().removeFeature(cls, att);
            Model.getCoreHelper().addFeature(cls, newIndex, att);
        } else if (element instanceof Parameter && parent instanceof Event) {
            Parameter param = (Parameter)element;
            Event event = (Event)parent;
            List f = event.getParameter();
            int oldIndex = f.indexOf(param);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(param);
            f.add(newIndex, param);
        } else if (element instanceof Parameter) {
            Parameter param = (Parameter)element;
            BehavioralFeature bf = param.getBehavioralFeature();
            List f = bf.getParameter();
            int oldIndex = f.indexOf(param);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(param);
            f.add(newIndex, param);
        } else if (element instanceof EnumerationLiteral) {
            EnumerationLiteral lit = (EnumerationLiteral)element;
            Enumeration enumeration = lit.getEnumeration();
            List f = enumeration.getLiteral();
            int oldIndex = f.indexOf(lit);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(lit);
            f.add(newIndex, lit);
        } else if (element instanceof ExtensionPoint && parent instanceof Extend) {
            ExtensionPoint ep = (ExtensionPoint)element;
            Extend extend = (Extend)parent;
            List f = extend.getExtensionPoint();
            int oldIndex = f.indexOf(ep);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(ep);
            f.add(newIndex, ep);
        } else if (element instanceof LinkEnd) {
            LinkEnd le = (LinkEnd)element;
            Link link = le.getLink();
            ArrayList<LinkEnd> f = new ArrayList<LinkEnd>(Model.getFacade().getConnections(link));
            int oldIndex = f.indexOf(le);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(le);
            f.add(newIndex, le);
            Model.getCoreHelper().setConnections(link, f);
        } else if (element instanceof ExtensionPoint && parent instanceof UseCase) {
            ExtensionPoint ep = (ExtensionPoint)element;
            UseCase extend = ep.getUseCase();
            ArrayList<ExtensionPoint> f = new ArrayList<ExtensionPoint>(Model.getFacade().getExtensionPoints(extend));
            int oldIndex = f.indexOf(ep);
            int newIndex = this.newPosition(oldIndex, f.size(), direction);
            f.remove(ep);
            f.add(newIndex, ep);
            Model.getUseCasesHelper().setExtensionPoints(extend, f);
        }
    }

    public boolean isMovable(Object metaType) {
        Class[] movableMetaType = new Class[]{Action.class, Argument.class, AssociationEnd.class, Attribute.class, EnumerationLiteral.class, Extend.class, ExtensionPoint.class, Feature.class, LinkEnd.class, Operation.class, Parameter.class};
        return Arrays.asList(movableMetaType).contains(metaType);
    }

    private int newPosition(int index, int size, UmlHelper.Direction direction) {
        int posn = direction == UmlHelper.Direction.DOWN ? index + 1 : (direction == UmlHelper.Direction.UP ? index - 1 : (direction == UmlHelper.Direction.TOP ? 0 : (direction == UmlHelper.Direction.BOTTOM ? size - 1 : 0)));
        return posn;
    }
}

