/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Logger;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.argouml.model.UmlException;
import org.argouml.model.XmiExtensionWriter;
import org.argouml.model.XmiWriter;
import org.argouml.model.mdr.MDRModelImplementation;
import org.argouml.model.mdr.XmiHeaderProviderImpl;
import org.argouml.model.mdr.XmiReferenceProviderImpl;
import org.netbeans.api.xmi.XMIOutputConfig;
import org.netbeans.api.xmi.XMIReferenceProvider;
import org.netbeans.api.xmi.XMIWriter;
import org.netbeans.api.xmi.XMIWriterFactory;
import org.netbeans.lib.jmi.xmi.OutputConfig;
import org.netbeans.lib.jmi.xmi.XMIHeaderProvider;

class XmiWriterMDRImpl
implements XmiWriter {
    private static final Logger LOG = Logger.getLogger(XmiWriterMDRImpl.class.getName());
    private MDRModelImplementation modelImpl;
    private Object model;
    private OutputConfig config;
    private Writer writer;
    private OutputStream oStream;
    private static final String ENCODING = "UTF-8";
    private static final String XMI_VERSION = "1.2";
    private XmiExtensionWriter xmiExtensionWriter;
    private static final char[] TARGET = "/XMI.content".toCharArray();

    private XmiWriterMDRImpl(MDRModelImplementation theParent, Object theModel, String version) {
        if (theModel == null) {
            throw new IllegalArgumentException("A model must be provided");
        }
        if (theParent == null) {
            throw new IllegalArgumentException("A parent must be provided");
        }
        this.modelImpl = theParent;
        this.model = theModel;
        this.config = new OutputConfig();
        this.config.setEncoding(ENCODING);
        this.config.setReferenceProvider((XMIReferenceProvider)new XmiReferenceProviderImpl(this.modelImpl.getObjectToId()));
        this.config.setHeaderProvider((XMIHeaderProvider)new XmiHeaderProviderImpl(version));
    }

    public XmiWriterMDRImpl(MDRModelImplementation theParent, Object theModel, OutputStream theStream, String version) {
        this(theParent, theModel, version);
        if (theStream == null) {
            throw new IllegalArgumentException("A writer must be provided");
        }
        this.oStream = theStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws UmlException {
        XMIWriter xmiWriter = XMIWriterFactory.getDefault().createXMIWriter((XMIOutputConfig)this.config);
        try {
            this.modelImpl.getRepository().beginTrans(false);
            try {
                RefPackage extent = ((RefObject)this.model).refOutermostPackage();
                xmiWriter.write(this.oStream, "file:///ThisIsADummyName.xmi", extent, XMI_VERSION);
            }
            finally {
                this.modelImpl.getRepository().endTrans();
            }
        }
        catch (IOException e) {
            throw new UmlException(e);
        }
    }

    public void setXmiExtensionWriter(XmiExtensionWriter theWriter) {
        this.xmiExtensionWriter = theWriter;
    }
}

