/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.layouts;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JToolBar;
import org.tigris.toolbar.layouts.DockBoundary;

class StackingDockBoundary
extends DockBoundary {
    private ArrayList ourDockSlivers = new ArrayList();

    public StackingDockBoundary(int n) {
        super(n);
    }

    public StackingDockBoundary(int n, int n2) {
        super(n, n2);
    }

    public int getDockIndex(Point point) {
        for (int i = 0; i < this.ourDockSlivers.size(); ++i) {
            DockSliver dockSliver = (DockSliver)this.ourDockSlivers.get(i);
            if (!dockSliver.contains(point)) continue;
            return dockSliver.getDockIndex(point);
        }
        return Integer.MAX_VALUE;
    }

    public int getDockIndex(JToolBar jToolBar) {
        DockSliver dockSliver = this.getDockSliver(jToolBar);
        if (dockSliver == null) {
            return -1;
        }
        return dockSliver.getDockIndex(jToolBar);
    }

    public int getRowIndex(Point point) {
        for (int i = 0; i < this.ourDockSlivers.size(); ++i) {
            DockSliver dockSliver = (DockSliver)this.ourDockSlivers.get(i);
            if (!dockSliver.contains(point)) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    public int getRowIndex(JToolBar jToolBar) {
        for (int i = 0; i < this.ourDockSlivers.size(); ++i) {
            DockSliver dockSliver = (DockSliver)this.ourDockSlivers.get(i);
            if (!dockSliver.containsToolBar(jToolBar)) continue;
            return i;
        }
        return -1;
    }

    public void validate() {
        int n = this.getSpacing();
        int n2 = this.getOrientation();
        int n3 = this.getEdge();
        int n4 = 0;
        n4 = n2 == 0 ? this.width : this.height;
        int n5 = 0;
        for (int i = 0; i < this.ourDockSlivers.size(); ++i) {
            DockSliver dockSliver = (DockSliver)this.ourDockSlivers.get(i);
            if (n5 != 0) {
                n5 += n;
            }
            if (n2 == 0) {
                dockSliver.setPosition(this.x, this.y + n5, n4);
            } else {
                dockSliver.setPosition(this.x + n5, this.y, n4);
            }
            if (n3 == 3 || n3 == 5) {
                Rectangle rectangle = dockSliver.getBounds();
                if (n2 == 0) {
                    this.mirrorBounds(rectangle, this.y);
                } else {
                    this.mirrorBounds(rectangle, this.x);
                }
                dockSliver.setBounds(rectangle);
                dockSliver.validate();
            }
            n5 += dockSliver.getDepth();
        }
        this.setDepth(n5);
    }

    protected void toolBarAdded(JToolBar jToolBar, int n, int n2) {
        this.getDockSliver(n).addToolBar(jToolBar, n2);
    }

    protected void toolBarRemoved(JToolBar jToolBar) {
        DockSliver dockSliver = this.getDockSliver(jToolBar);
        if (dockSliver != null) {
            dockSliver.removeToolBar(jToolBar);
            if (dockSliver.getToolBarCount() == 0) {
                this.ourDockSlivers.remove(dockSliver);
            }
        }
    }

    private DockSliver getDockSliver(int n) {
        if (n < 0) {
            DockSliver dockSliver = new DockSliver();
            this.ourDockSlivers.add(0, dockSliver);
            return dockSliver;
        }
        if (n >= this.ourDockSlivers.size()) {
            DockSliver dockSliver = new DockSliver();
            this.ourDockSlivers.add(dockSliver);
            return dockSliver;
        }
        return (DockSliver)this.ourDockSlivers.get(n);
    }

    private DockSliver getDockSliver(JToolBar jToolBar) {
        for (int i = 0; i < this.ourDockSlivers.size(); ++i) {
            DockSliver dockSliver = (DockSliver)this.ourDockSlivers.get(i);
            if (!dockSliver.containsToolBar(jToolBar)) continue;
            return dockSliver;
        }
        return null;
    }

    private class DockSliver
    extends Rectangle {
        private ArrayList myToolBars = new ArrayList();

        public void addToolBar(JToolBar jToolBar) {
            this.myToolBars.add(jToolBar);
        }

        public void addToolBar(JToolBar jToolBar, int n) {
            if (n < 0) {
                this.myToolBars.add(0, jToolBar);
            } else if (n >= this.myToolBars.size()) {
                this.myToolBars.add(jToolBar);
            } else {
                this.myToolBars.add(n, jToolBar);
            }
        }

        public void removeToolBar(JToolBar jToolBar) {
            this.myToolBars.remove(jToolBar);
        }

        public int getToolBarCount() {
            return this.myToolBars.size();
        }

        public boolean containsToolBar(JToolBar jToolBar) {
            return this.myToolBars.contains(jToolBar);
        }

        public void setPosition(int n, int n2, int n3) {
            this.setLocation(n, n2);
            if (StackingDockBoundary.this.getOrientation() == 0) {
                this.width = n3;
            } else {
                this.height = n3;
            }
            this.validate();
        }

        public void validate() {
            int n = 0;
            int n2 = 0;
            int n3 = StackingDockBoundary.this.getOrientation();
            int n4 = StackingDockBoundary.this.getSpacing();
            int n5 = 0;
            if (n3 == 0) {
                n = this.x;
                n2 = this.x;
                n5 = this.width;
                this.height = this.getPreferredDepth();
            } else {
                n = this.y;
                n2 = this.y;
                n5 = this.height;
                this.width = this.getPreferredDepth();
            }
            for (int i = 0; i < this.myToolBars.size(); ++i) {
                JToolBar jToolBar = (JToolBar)this.myToolBars.get(i);
                int n6 = StackingDockBoundary.this.getPreferredToolBarLength(jToolBar);
                if (n + n6 > n5 + n2) {
                    n6 = n2 + n5 - n;
                }
                if (n3 == 0) {
                    jToolBar.setBounds(n, this.y, n6, this.height);
                } else {
                    jToolBar.setBounds(this.x, n, this.width, n6);
                }
                n += n6 + n4;
            }
        }

        public int getPreferredDepth() {
            int n = 0;
            for (int i = 0; i < this.myToolBars.size(); ++i) {
                JToolBar jToolBar = (JToolBar)this.myToolBars.get(i);
                int n2 = StackingDockBoundary.this.getPreferredToolBarDepth(jToolBar);
                n = Math.max(n, n2);
            }
            return n;
        }

        public int getDepth() {
            if (StackingDockBoundary.this.getOrientation() == 0) {
                return this.height;
            }
            return this.width;
        }

        public int getDockIndex(Point point) {
            for (int i = 0; i < this.myToolBars.size(); ++i) {
                JToolBar jToolBar = (JToolBar)this.myToolBars.get(i);
                if (!jToolBar.getBounds().contains(point)) continue;
                return i;
            }
            return Integer.MAX_VALUE;
        }

        public int getDockIndex(JToolBar jToolBar) {
            return this.myToolBars.indexOf(jToolBar);
        }
    }
}

